/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.solver.TimeModel.BasicType;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.BasicTypeFactory;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Element;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.Integer;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.IntegerElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.PrimitiveElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceElement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.BasicType.SequenceType;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.solver.SolverElement;
import java.util.Iterator;

public class SolverSequenceElement
extends SolverElement {
    private int finitePartIndex;
    private int nonFinitePartIndex;

    public void setFinitePartIndex(int finitePartIndex) {
        this.finitePartIndex = finitePartIndex;
    }

    public void setNonFinitePartIndex(int nonFinitePartIndex) {
        this.nonFinitePartIndex = nonFinitePartIndex;
    }

    public int getFinitePartIndex() {
        return this.finitePartIndex;
    }

    public int getNonFinitePartIndex() {
        return this.nonFinitePartIndex;
    }

    public SolverSequenceElement(SequenceElement seq, InstantiatedElement ie) {
        super((Element)seq);
        this.setInstantiatedElement(ie);
        this.finitePartIndex = 0;
        this.nonFinitePartIndex = 0;
    }

    public SolverSequenceElement(SolverSequenceElement seq, InstantiatedElement ie) {
        super((Element)seq.getSequenceElement());
        this.setInstantiatedElement(ie);
        this.finitePartIndex = seq.finitePartIndex;
        this.nonFinitePartIndex = seq.nonFinitePartIndex;
    }

    public SolverSequenceElement(InstantiatedElement element, SequenceElement seq) {
        super(element, (Element)seq);
        this.finitePartIndex = 0;
        this.nonFinitePartIndex = 0;
    }

    public SequenceElement getSequenceElement() {
        return (SequenceElement)this.getModelElement();
    }

    public boolean isEmpty() {
        return this.finitePartIsEmpty() && this.nonFinitePartIsEmpty();
    }

    public boolean finitePartIsEmpty() {
        return this.getSequenceElement().getFinitePart().isEmpty() || this.finitePartIndex >= this.getSequenceElement().getFinitePart().size();
    }

    public boolean nonFinitePartIsEmpty() {
        return this.getSequenceElement().getNonFinitePart().isEmpty();
    }

    public void reset() {
        this.finitePartIndex = 0;
        this.nonFinitePartIndex = 0;
    }

    public PrimitiveElement getHead() {
        if (this.finitePartIsEmpty()) {
            if (this.nonFinitePartIsEmpty()) {
                IntegerElement fake = BasicTypeFactory.eINSTANCE.createIntegerElement();
                fake.setValue(java.lang.Integer.valueOf(-1));
                fake.setName("fake");
                return fake;
            }
            return (PrimitiveElement)this.getSequenceElement().getNonFinitePart().get(this.nonFinitePartIndex);
        }
        return (PrimitiveElement)this.getSequenceElement().getFinitePart().get(this.finitePartIndex);
    }

    public PrimitiveElement nextHead() {
        if (this.finitePartIsEmpty()) {
            if (this.nonFinitePartIsEmpty()) {
                return null;
            }
            PrimitiveElement res = (PrimitiveElement)this.getSequenceElement().getNonFinitePart().get(this.nonFinitePartIndex);
            ++this.nonFinitePartIndex;
            if (this.nonFinitePartIndex == this.getSequenceElement().getNonFinitePart().size()) {
                this.nonFinitePartIndex = 0;
            }
            return res;
        }
        PrimitiveElement res = (PrimitiveElement)this.getSequenceElement().getFinitePart().get(this.finitePartIndex);
        ++this.finitePartIndex;
        return res;
    }

    public SolverSequenceElement getTail() {
        SolverSequenceElement res = this;
        res.finitePartIndex = this.finitePartIndex;
        res.nonFinitePartIndex = this.nonFinitePartIndex;
        res.nextHead();
        return res;
    }

    public boolean isAnIntegerSequence() {
        return this.getSequenceElement().getType() != null && this.getSequenceElement().getType() instanceof SequenceType && ((SequenceType)this.getSequenceElement().getType()).getElementType() instanceof Integer;
    }

    public String toString() {
        String res = String.valueOf(this.getSequenceElement().getName()) + "=";
        if (!this.finitePartIsEmpty()) {
            int i = this.finitePartIndex;
            while (i < this.getSequenceElement().getFinitePart().size()) {
                res = String.valueOf(res) + this.getSequenceElement().getFinitePart().get(i);
                if (i < this.getSequenceElement().getFinitePart().size() - 1) {
                    res = String.valueOf(res) + "; ";
                }
                ++i;
            }
        }
        if (!this.nonFinitePartIsEmpty()) {
            res = String.valueOf(res) + "(";
            Iterator it = this.getSequenceElement().getNonFinitePart().iterator();
            while (it.hasNext()) {
                PrimitiveElement elt = (PrimitiveElement)it.next();
                if (elt == this.getSequenceElement().getNonFinitePart().get(this.nonFinitePartIndex)) {
                    res = String.valueOf(res) + "^";
                }
                res = String.valueOf(res) + elt;
                if (!it.hasNext()) continue;
                res = String.valueOf(res) + "; ";
            }
            res = String.valueOf(res) + ")";
        }
        return res;
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = new SerializedConstraintState();
        currentState.dump((Object)this.getFinitePartIndex());
        currentState.dump((Object)this.getNonFinitePartIndex());
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState newState) {
        this.setFinitePartIndex((java.lang.Integer)newState.restore(0));
        this.setNonFinitePartIndex((java.lang.Integer)newState.restore(1));
    }
}

