/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ValueProvider;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;

public class RuntimeWait
extends AbstractRuntimeExpression {
    private RuntimeClock clock;
    private int initialDelay;
    private ValueProvider<Integer> delayProvider = null;
    private int delay = -1;

    public RuntimeWait(RuntimeClock iClock, RuntimeClock waitClock, ValueProvider<Integer> waitCount) {
        super(iClock);
        this.clock = waitClock;
        this.delayProvider = waitCount;
    }

    public RuntimeWait(RuntimeClock iClock, RuntimeClock waitClock, Integer waitCount) {
        super(iClock);
        this.clock = waitClock;
        this.initialDelay = waitCount;
        this.delayProvider = null;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        this.delay = this.delayProvider != null ? this.delayProvider.getValue() : this.initialDelay;
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (this.clock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock)).semantic(helper);
        }
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.isDead()) {
            helper.inhibitClock(this.getExpressionClock());
        } else if (this.delay == 1) {
            helper.semanticBDDAnd(helper.createEqual(this.getExpressionClock(), this.clock));
        } else {
            helper.inhibitClock(this.getExpressionClock());
        }
        helper.registerClockUse(new RuntimeClock[]{this.getExpressionClock(), this.clock});
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (this.clock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock)).update(helper);
        }
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(helper);
        if (helper.clockHasFired(this.clock)) {
            if (this.delay == 1) {
                this.terminate(helper);
            } else if (this.delay > 1) {
                --this.delay;
            }
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.clock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock)).deathSemantic(helper);
        }
        helper.registerDeathImplication(this.clock, this.getExpressionClock());
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = super.dumpState();
        currentState.dump(new Integer(this.delay));
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState newState) {
        super.restoreState(newState);
        this.delay = (Integer)newState.restore(2);
    }
}

