/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.AbstractConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;

public class RuntimeConcatenation
extends AbstractRuntimeExpression {
    private RuntimeClock leftClock;
    private RuntimeClock rightClock;
    private ConcatState concatState;

    public RuntimeConcatenation(RuntimeClock iClock, RuntimeClock leftClock, RuntimeClock rightClock) {
        super(iClock);
        this.leftClock = leftClock;
        this.rightClock = rightClock;
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        this.concatState = ConcatState.FOLLOWLEFT;
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.concatState == ConcatState.FOLLOWLEFT) {
            helper.registerClockEquality(this.getExpressionClock(), this.leftClock);
            helper.registerClockUse(new RuntimeClock[]{this.getExpressionClock(), this.leftClock});
            if (this.leftClock instanceof ICCSLConstraint) {
                ((ICCSLConstraint)((Object)this.leftClock)).semantic(helper);
            }
        } else if (this.concatState == ConcatState.FOLLOWRIGHT) {
            helper.registerClockEquality(this.getExpressionClock(), this.rightClock);
            helper.registerClockUse(new RuntimeClock[]{this.getExpressionClock(), this.rightClock});
            if (this.rightClock instanceof ICCSLConstraint) {
                ((ICCSLConstraint)((Object)this.rightClock)).semantic(helper);
            }
        }
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (this.concatState == ConcatState.FOLLOWLEFT) {
            if (this.leftClock instanceof ICCSLConstraint) {
                ((ICCSLConstraint)((Object)this.leftClock)).update(helper);
            }
        } else if (this.concatState == ConcatState.FOLLOWRIGHT && this.rightClock != this.getExpressionClock() && this.rightClock instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.rightClock)).update(helper);
        }
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(helper);
        if (this.concatState == ConcatState.FOLLOWLEFT) {
            if (this.leftClock.isDead()) {
                if (this.rightClock != this.getExpressionClock()) {
                    this.concatState = ConcatState.FOLLOWRIGHT;
                    helper.registerClockToStart(this.rightClock);
                } else {
                    helper.registerClockToStart(this.leftClock);
                }
            }
        } else if (this.concatState == ConcatState.FOLLOWRIGHT && !this.isRecursive() && this.rightClock.isDead()) {
            this.terminate(helper);
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.concatState == ConcatState.FOLLOWLEFT) {
            if (this.leftClock instanceof ICCSLConstraint) {
                ((ICCSLConstraint)((Object)this.leftClock)).deathSemantic(helper);
            }
        } else if (!this.isRecursive()) {
            if (this.rightClock instanceof ICCSLConstraint) {
                ((ICCSLConstraint)((Object)this.rightClock)).deathSemantic(helper);
            }
            helper.registerDeathImplication(this.rightClock, this.getExpressionClock());
        }
    }

    private boolean isRecursive() {
        return this.rightClock == this.getExpressionClock();
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = super.dumpState();
        currentState.dump(this.concatState.ordinal());
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState newState) {
        super.restoreState(newState);
        this.concatState = ConcatState.values()[(Integer)newState.restore(2)];
    }

    public String toString() {
        String res = "[" + this.getExpressionClock().getName() + "]" + (this.state != AbstractConstraint.State.DEAD && this.state != AbstractConstraint.State.INIT ? "*" : "") + "Concat(";
        res = String.valueOf(res) + (this.concatState == ConcatState.FOLLOWLEFT ? "^" : "") + this.leftClock + ", ";
        res = String.valueOf(res) + (this.concatState == ConcatState.FOLLOWRIGHT ? "^" : "") + this.rightClock + ")";
        return res;
    }

    public static enum ConcatState {
        FOLLOWLEFT,
        FOLLOWRIGHT;

    }
}

