/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.manager.datastructure;

import fr.inria.aoste.timesquare.backend.manager.datastructure.Entity;
import java.util.ArrayList;
import java.util.List;

public abstract class ABehaviorList<T extends Entity> {
    private List<T> _data;

    protected ABehaviorList(List<T> data) {
        assert (data != null);
        this._data = data;
    }

    public final void addEntity(T entity) {
        if (!this._data.contains(entity)) {
            this._data.add(entity);
        }
    }

    public final List<T> getData() {
        return this._data;
    }

    public final void deleteEntity(T entity) {
        if (entity != null) {
            this._data.remove(entity);
        }
    }

    public final void deleteEntitiesByPluginName(String pluginName) {
        ArrayList<Entity> toBeRemoved = new ArrayList<Entity>();
        for (Entity e : this._data) {
            if (!e.getPluginName().equals(pluginName)) continue;
            toBeRemoved.add(e);
        }
        for (Entity e : toBeRemoved) {
            this._data.remove(e);
        }
    }

    public final void clear() {
        try {
            this._data.clear();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public final void displayConsole() {
        System.out.println("Data representation : ");
        for (Entity e : this._data) {
            System.out.println("- " + e.getDescription());
        }
    }

    protected final boolean pluginPresent(String pluginName) {
        for (Entity be : this._data) {
            if (!be.getPluginName().equals(pluginName)) continue;
            return true;
        }
        return false;
    }
}

