/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.engine.core;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gemoc.commons.eclipse.emf.URIHelper;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionWorkspace;

public class ExecutionWorkspace
implements IExecutionWorkspace {
    private IPath _executionTopParentPath;
    private IPath _projectPath;
    private IPath _executionPath;
    private IPath _modelPath;

    public ExecutionWorkspace(URI modelURI) throws CoreException {
        this._modelPath = new Path(URIHelper.removePlatformScheme((URI)modelURI));
        this._projectPath = this._modelPath.removeLastSegments(this._modelPath.segmentCount() - 1);
        this._executionTopParentPath = this._projectPath.append("gemoc-gen");
        this._executionPath = this._executionTopParentPath.append("execution").append(this.generateSpecificExecutionFolderName());
        this.createExecutionContext();
    }

    public IPath getProjectPath() {
        return this._projectPath;
    }

    public IPath getExecutionPath() {
        return this._executionPath;
    }

    public IPath getModelPath() {
        return this._modelPath;
    }

    public IPath getMoCPath() {
        IPath mocPath = new Path(this.getModelPath().removeFileExtension().lastSegment()).addFileExtension("timemodel");
        return this._executionTopParentPath.append(mocPath);
    }

    private String generateSpecificExecutionFolderName() {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(Calendar.getInstance().getTime());
        return "/execution-" + timeStamp;
    }

    private void createExecutionContext() throws CoreException {
        this.createExecutionFolders();
    }

    private void createExecutionFolders() throws CoreException {
        this.createFolder(this._executionPath.removeLastSegments(2));
        this.createFolder(this._executionPath.removeLastSegments(1));
        this.createFolder(this._executionPath);
    }

    private void createFolder(IPath folderPath) throws CoreException {
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(folderPath);
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
    }

    public void copyFileTo(IPath sourceFilePath, IPath destinationFolderPath) throws CoreException {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(sourceFilePath);
        IPath destinationFilePath = destinationFolderPath.append(sourceFilePath.lastSegment());
        file.copy(destinationFilePath, true, null);
    }

    public void copyFileToExecutionFolder(IPath sourcePath) throws CoreException {
        this.copyFileTo(sourcePath, this._executionPath);
    }

    public IPath getMSEModelPath() {
        IPath msePath = new Path(this.getModelPath().removeFileExtension().lastSegment()).addFileExtension("msemodel");
        return this._executionTopParentPath.append(msePath);
    }
}

