/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecoretools.ale.core.env.IAleEnvironment;
import org.eclipse.emf.ecoretools.ale.core.env.IBehaviors;
import org.eclipse.emf.ecoretools.ale.ide.env.WithAbsoluteBehaviorPathsAleEnvironment;
import org.eclipse.emf.ecoretools.ale.ide.ui.Activator;
import org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig.AleEvaluationJob;
import org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig.MethodRepresentation;
import org.eclipse.emf.ecoretools.ale.ide.ui.launchconfig.UiUtils;
import org.eclipse.emf.ecoretools.ale.implementation.BehavioredClass;
import org.eclipse.emf.ecoretools.ale.implementation.ExtendedClass;
import org.eclipse.emf.ecoretools.ale.implementation.Method;
import org.eclipse.emf.ecoretools.ale.implementation.RuntimeClass;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class AleLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        block4: {
            WithAbsoluteBehaviorPathsAleEnvironment environment = null;
            try {
                String modelLocation = configuration.getAttribute("MODEL_FILE", "");
                String mainMethod = configuration.getAttribute("MAIN_METHOD", "");
                String mainModelElement = configuration.getAttribute("MAIN_MODEL_ELEMENT", "");
                List<String> behaviorsPath = Arrays.asList(configuration.getAttribute("BEHAVIORS_PATH", "").split(","));
                List<String> metamodelsPath = Arrays.asList(configuration.getAttribute("METAMODELS_PATH", "").split(","));
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IResource modelFile = workspace.getRoot().findMember(modelLocation);
                environment = new WithAbsoluteBehaviorPathsAleEnvironment(IAleEnvironment.fromPaths(metamodelsPath, behaviorsPath));
                IBehaviors semantics = environment.getBehaviors();
                List<Method> potentialMains = this.getPotentialMains(semantics, mainMethod);
                List<EObject> potentialCallers = this.getPotentialCallers((IAleEnvironment)environment, modelFile, mainModelElement);
                List<EvaluationArguments> potentialArgs = this.getPotentialEvaluationArguments(potentialCallers, potentialMains);
                if (!this.canRunAleInterpreter(potentialCallers, modelFile, potentialMains, behaviorsPath, potentialArgs)) {
                    environment.close();
                    return;
                }
                Optional<EvaluationArguments> args = this.getDefinitiveEvaluationArguments(potentialArgs);
                if (!args.isPresent()) {
                    environment.close();
                    return;
                }
                EvaluationArguments arguments = args.get();
                this.persistConfiguration(configuration, arguments);
                AleEvaluationJob evaluation = new AleEvaluationJob((IAleEnvironment)environment, arguments.mainElement, arguments.main, modelFile);
                evaluation.schedule();
            }
            catch (Exception e) {
                Activator.error("An error occurred while launching ALE", e);
                UiUtils.getDisplay().asyncExec(() -> MessageDialog.openError((Shell)UiUtils.getShell(), (String)"An error occurred while launching ALE", (String)(String.valueOf(e.getMessage()) + "\n\nPlease check the Error Log view for more details.")));
                if (environment == null) break block4;
                environment.close();
            }
        }
    }

    private void persistConfiguration(ILaunchConfiguration configuration, EvaluationArguments args) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        workingCopy.setAttribute("MAIN_METHOD", MethodRepresentation.of(args.main, null).toString());
        workingCopy.setAttribute("MAIN_MODEL_ELEMENT", args.mainElement.eResource().getURIFragment(args.mainElement));
        workingCopy.doSave();
    }

    private List<EObject> getPotentialCallers(IAleEnvironment environment, IResource modelFile, String mainModelElementURI) {
        Resource resource = environment.loadResource(URI.createURI((String)modelFile.getLocationURI().toString()));
        if (!mainModelElementURI.isEmpty()) {
            EObject mainModelElement = resource.getEObject(mainModelElementURI);
            if (mainModelElement != null) {
                return Arrays.asList(mainModelElement);
            }
            Activator.warn("Unable to find main model element with URI: " + mainModelElementURI + " in resource " + modelFile + "\nWill attempt to infer an available model element", null);
        }
        Stream allElements = StreamSupport.stream(Spliterators.spliteratorUnknownSize(resource.getAllContents(), 0), false);
        return allElements.collect(Collectors.toList());
    }

    private List<Method> getPotentialMains(IBehaviors semantics, String mainMethodId) {
        List mains = semantics.getMainMethods();
        if (!mainMethodId.isEmpty()) {
            for (Method main : mains) {
                MethodRepresentation repr = MethodRepresentation.of(main, null);
                if (!repr.toString().equals(mainMethodId)) continue;
                return Arrays.asList(main);
            }
            Activator.warn("Unable to find @main method: " + mainMethodId + ". Will attempt to infer an available @main method.", null);
        }
        return mains;
    }

    private List<EvaluationArguments> getPotentialEvaluationArguments(List<EObject> callers, List<Method> mains) {
        ArrayList<EvaluationArguments> all = new ArrayList<EvaluationArguments>();
        for (EObject element : callers) {
            for (Method main : mains) {
                if (main.eContainer() instanceof ExtendedClass) {
                    ExtendedClass extendedClass = (ExtendedClass)main.eContainer();
                    if (!EcoreUtil.equals((EObject)element.eClass(), (EObject)extendedClass.getBaseClass())) continue;
                    all.add(new EvaluationArguments((BehavioredClass)extendedClass, main, element));
                    continue;
                }
                if (!(main.eContainer() instanceof RuntimeClass)) continue;
                RuntimeClass runtimeClass = (RuntimeClass)main.eContainer();
                if (!EcoreUtil.equals((EObject)element.eClass(), (EObject)runtimeClass.eClass())) continue;
                all.add(new EvaluationArguments((BehavioredClass)runtimeClass, main, element));
            }
        }
        return all;
    }

    private Optional<EvaluationArguments> getDefinitiveEvaluationArguments(List<EvaluationArguments> args) {
        if (args.size() == 1) {
            return Optional.of(args.get(0));
        }
        return this.askUserToChooseAmong(args);
    }

    private Optional<EvaluationArguments> askUserToChooseAmong(List<EvaluationArguments> args) {
        DumbHolder holder = new DumbHolder();
        UiUtils.getDisplay().syncExec(() -> {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(UiUtils.getShell(), (ILabelProvider)new EvaluationArgumentsLabelProvider());
            dialog.setElements(args.toArray());
            dialog.setTitle("Unable to determine the @main method to execute");
            dialog.setMessage("Select the @main method and the element on which it should be called:");
            if (dialog.open() == 0) {
                dumbHolder.args = (EvaluationArguments)dialog.getFirstResult();
            }
        });
        return Optional.ofNullable(holder.args);
    }

    private boolean canRunAleInterpreter(List<EObject> callers, IResource modelFile, List<Method> mains, List<String> behaviors, List<EvaluationArguments> args) {
        if (mains.isEmpty()) {
            UiUtils.getDisplay().asyncExec(() -> MessageDialog.openError((Shell)UiUtils.getShell(), (String)"Cannot run ALE", (String)("Unable to find any executable element in " + modelFile + ".\n\n" + "Make sure that:\n" + "    - the ALE source files open at least one of the EClass used in the model,\n" + "    - the method to execute is annotated with @main.")));
            return false;
        }
        if (behaviors.isEmpty()) {
            UiUtils.getDisplay().asyncExec(() -> MessageDialog.openError((Shell)UiUtils.getShell(), (String)"Cannot run ALE", (String)("Unable to find any @main method from " + behaviors + ".")));
            return false;
        }
        if (args.isEmpty()) {
            UiUtils.getDisplay().asyncExec(() -> MessageDialog.openError((Shell)UiUtils.getShell(), (String)"Cannot run ALE", (String)"No @main method found for model's elements.\n\nMake sure that:\n    - the ALE source files open at least one of the EClass used in the model,\n    - the method to execute is annotated with @main."));
            return false;
        }
        return true;
    }

    private static class DumbHolder {
        EvaluationArguments args;

        private DumbHolder() {
        }
    }

    private static class EvaluationArguments {
        Method main;
        BehavioredClass caller;
        EObject mainElement;

        public EvaluationArguments(BehavioredClass caller, Method call, EObject mainElement) {
            this.caller = caller;
            this.main = call;
            this.mainElement = mainElement;
        }
    }

    private static class EvaluationArgumentsLabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private EvaluationArgumentsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            EvaluationArguments args = (EvaluationArguments)element;
            return MethodRepresentation.of(args.main, (EObject)args.caller, args.mainElement).toString();
        }
    }
}

