/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.relations;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.SerializedConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.NoBooleanSolution;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.relations.AbstractRuntimeRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sf.javabdd.BuDDyFactory;

public class RuntimePrecedes
extends AbstractRuntimeRelation {
    private RuntimeClock leftClock;
    private RuntimeClock rightClock;
    private int delta;

    public RuntimePrecedes(RuntimeClock left, RuntimeClock right) {
        this.leftClock = left;
        this.rightClock = right;
        this.delta = 0;
    }

    @Override
    protected ICCSLConstraint[] getConstraints() {
        return new ICCSLConstraint[0];
    }

    @Override
    public List<RuntimeClock> getDiscreteClocks() {
        return Collections.emptyList();
    }

    @Override
    public Collection<? extends AbstractRuntimeRelation> getAllAssertions() {
        return Collections.emptyList();
    }

    @Override
    public void start(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallStart()) {
            return;
        }
        super.start(helper);
        this.delta = 0;
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.isAssertion()) {
            this.assertionSemantic(helper);
        } else {
            if (this.delta < 0) {
                throw new NoBooleanSolution("A precedence relation has been violated" + this.getQualifiedName());
            }
            if (this.delta == 0) {
                helper.inhibitClock(this.rightClock);
            }
        }
        helper.registerClockUse(new RuntimeClock[]{this.leftClock, this.rightClock});
    }

    @Override
    public void assertionSemantic(AbstractSemanticHelper helper) {
        if (this.delta < 0) {
            BuDDyFactory.BuDDyBDD assertion = helper.getAssertionVariable(this);
            helper.semanticBDDAnd(assertion.not());
            helper.registerAssertion(this);
        } else if (this.delta == 0) {
            BuDDyFactory.BuDDyBDD notRight = helper.createNot(this.rightClock);
            helper.assertionSemantic(this, notRight);
        } else if (this.delta > 0) {
            BuDDyFactory.BuDDyBDD assertion = helper.getAssertionVariable(this);
            helper.semanticBDDAnd(assertion);
            helper.registerAssertion(this);
        }
        helper.registerClockUse(new RuntimeClock[]{this.leftClock, this.rightClock});
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.delta == 0) {
            helper.registerDeathImplication(this.leftClock, this.rightClock);
        }
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        if (!this.canCallUpdate()) {
            return;
        }
        super.update(helper);
        if (helper.clockHasFired(this.leftClock)) {
            ++this.delta;
        }
        if (helper.clockHasFired(this.rightClock)) {
            --this.delta;
        }
    }

    @Override
    public SerializedConstraintState dumpState() {
        SerializedConstraintState currentState = super.dumpState();
        currentState.dump(this.delta);
        return currentState;
    }

    @Override
    public void restoreState(SerializedConstraintState state) {
        super.restoreState(state);
        this.delta = (Integer)state.restore(0);
    }
}

