/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.backend.codeexecution.manager;

import com.google.inject.Injector;
import fr.inria.aoste.timesquare.backend.codeexecution.CodeExecutionHelper;
import fr.inria.aoste.timesquare.backend.codeexecution.behaviors.CodeExecutionBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.behaviors.CodeExecutionClockBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.behaviors.CodeExecutionRelationBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.manager.CodeExecutorConfigurator;
import fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution.CodeExecAssertionBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution.CodeExecClockBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution.CodeExecRelationBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution.CodeExecutionModelBehavior;
import fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution.CodeExecutionSpecification;
import fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution.LiveStateKind;
import fr.inria.aoste.timesquare.backend.codeexecution.model.CodeExecution.ObjectVariable;
import fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions.CodeExecutionAssertPersistentOptions;
import fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions.CodeExecutionClockPersistentOptions;
import fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions.CodeExecutionRelationPersistentOptions;
import fr.inria.aoste.timesquare.backend.codeexecution.persistentoptions.Variable;
import fr.inria.aoste.timesquare.backend.codeexecution.ui.internal.CodeExecutionSpecActivator;
import fr.inria.aoste.timesquare.backend.manager.datastructure.assertion.AssertActivationState;
import fr.inria.aoste.timesquare.backend.manager.datastructure.clock.ClockActivationState;
import fr.inria.aoste.timesquare.backend.manager.datastructure.relation.RelationActivationState;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorConfigurator;
import fr.inria.aoste.timesquare.backend.manager.visible.BehaviorManager;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.ClockEntity;
import fr.inria.aoste.timesquare.backend.manager.visible.ConfigurationHelper;
import fr.inria.aoste.timesquare.backend.manager.visible.PersistentOptions;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationBehavior;
import fr.inria.aoste.timesquare.backend.manager.visible.RelationEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ConcreteEntity;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Relation;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Clock;
import fr.inria.aoste.timesquare.ccslkernel.model.utils.CCSLKernelUtils;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.trace.util.ReferenceNameBuilder;
import fr.inria.aoste.trace.EnableStateKind;
import fr.inria.aoste.trace.FiredStateKind;
import fr.inria.aoste.trace.ModelElementReference;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.resource.XtextResourceSetProvider;

public class CodeExecutionManager
extends BehaviorManager {
    private ArrayList<CodeExecutionBehavior> _behaviorList;
    private ArrayList<Variable> _listvariable = new ArrayList();
    private String codeExecModelFilename;
    protected CodeExecutionHelper ceh = new CodeExecutionHelper(null);
    public static boolean loadBehaviorsFromModel = true;
    private static String qualifiedNameSeparator = "::";

    public ArrayList<Variable> getListVariable() {
        return this._listvariable;
    }

    public String getCodeExecModelFilename() {
        return this.codeExecModelFilename;
    }

    public void setCodeExecModelFilename(String codeExecModelFilename) {
        this.codeExecModelFilename = codeExecModelFilename;
    }

    public void clear() {
        this._listvariable.clear();
        this._behaviorList.clear();
        super.clear();
    }

    public Variable createVariable(String name, IType type) {
        Variable v = new Variable(name, type);
        this.addVariable(v);
        return v;
    }

    public Variable createVariable(String name, String typeName) {
        Variable v = new Variable(name, typeName);
        this.addVariable(v);
        return v;
    }

    private void addVariable(Variable v) {
        v.setCodeExecutionHelper(this.ceh);
        this._listvariable.add(v);
    }

    private void addbehavior(CodeExecutionBehavior behavior) {
        this._behaviorList.add(behavior);
        Variable v = behavior.getVariable();
        if (v != null) {
            int i = this._listvariable.indexOf(v);
            if (i == -1) {
                v.setCodeExecutionHelper(this.ceh);
                this._listvariable.add(v);
            } else if (this._listvariable.get(i) != v) {
                behavior.setVariable(v);
            }
        }
        behavior.setCe(this.ceh);
    }

    public void beforeExecution(ConfigurationHelper helper, IPath folderin, String namefilein, ISolverForBackend solver) {
        this.ceh.setConfigurationHelper(helper, solver);
    }

    public void end(ConfigurationHelper helper) {
        for (CodeExecutionBehavior b : this._behaviorList) {
            b.finish();
        }
        this._behaviorList.clear();
        this.ceh.clear();
        this.ceh = null;
    }

    public String _getid() {
        return "codeexecution";
    }

    public String getPluginName() {
        return "Code Execution";
    }

    public void init(ConfigurationHelper helper) {
        super.init(helper);
        this._behaviorList = new ArrayList();
    }

    public void manageBehavior(ConfigurationHelper helper) {
    }

    public ClockBehavior redoClockBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        if (persistentOptions != null && persistentOptions instanceof CodeExecutionClockPersistentOptions) {
            CodeExecutionClockBehavior behavior = ((CodeExecutionClockPersistentOptions)persistentOptions).redoClockBehavior(helper);
            this.addbehavior(behavior);
            return behavior;
        }
        return null;
    }

    public RelationBehavior redoRelationBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        if (persistentOptions != null && persistentOptions instanceof CodeExecutionRelationPersistentOptions) {
            CodeExecutionRelationBehavior behavior = ((CodeExecutionRelationPersistentOptions)persistentOptions).redoRelationBehavior(helper);
            this.addbehavior(behavior);
            return behavior;
        }
        return null;
    }

    public ClockBehavior redoAssertBehavior(ConfigurationHelper helper, PersistentOptions persistentOptions) {
        if (persistentOptions != null && persistentOptions instanceof CodeExecutionAssertPersistentOptions) {
            CodeExecutionClockBehavior behavior = ((CodeExecutionAssertPersistentOptions)persistentOptions).redoAssertBehavior(helper);
            this.addbehavior(behavior);
            return behavior;
        }
        return null;
    }

    public void addBehavior(Variable v, IMethod method, ClockEntity ce, ClockActivationState clockState, ArrayList<ClockEntity> clockToForce) {
        if (this._helper != null && method != null && ce != null && this._behaviorList != null) {
            CodeExecutionClockBehavior behavior = new CodeExecutionClockBehavior(v, method, clockToForce, this._helper);
            CodeExecutionClockPersistentOptions options = new CodeExecutionClockPersistentOptions(behavior);
            options.setVariable(v);
            this.addbehavior(behavior);
            this._helper.addBehavior(ce, clockState, this.getPluginName(), (ClockBehavior)behavior, (PersistentOptions)options);
        }
    }

    public void addBehavior(Variable v, String methodName, ClockEntity ce, ClockActivationState clockState, ArrayList<ClockEntity> clockToForce) {
        if (this._helper != null && methodName != null && ce != null && this._behaviorList != null) {
            CodeExecutionClockBehavior behavior = new CodeExecutionClockBehavior(v, methodName, clockToForce, this._helper);
            CodeExecutionClockPersistentOptions options = new CodeExecutionClockPersistentOptions(behavior);
            options.setVariable(v);
            this.addbehavior(behavior);
            this._helper.addBehavior(ce, clockState, this.getPluginName(), (ClockBehavior)behavior, (PersistentOptions)options);
        }
    }

    public void addBehavior(Variable v, IMethod method, ClockEntity ce, boolean[] assertState) {
        if (this._helper != null && method != null && ce != null && this._behaviorList != null) {
            CodeExecutionClockBehavior behavior = new CodeExecutionClockBehavior(v, method, null, this._helper);
            CodeExecutionAssertPersistentOptions options = new CodeExecutionAssertPersistentOptions(behavior);
            options.setVariable(v);
            this.addbehavior(behavior);
            this._helper.addBehavior(ce, new AssertActivationState(assertState), this.getPluginName(), (ClockBehavior)behavior, (PersistentOptions)options);
        }
    }

    public void addBehavior(Variable v, String methodName, ClockEntity ce, boolean[] assertState) {
        if (this._helper != null && methodName != null && ce != null && this._behaviorList != null) {
            CodeExecutionClockBehavior behavior = new CodeExecutionClockBehavior(v, methodName, null, this._helper);
            CodeExecutionAssertPersistentOptions options = new CodeExecutionAssertPersistentOptions(behavior);
            options.setVariable(v);
            this.addbehavior(behavior);
            this._helper.addBehavior(ce, new AssertActivationState(assertState), this.getPluginName(), (ClockBehavior)behavior, (PersistentOptions)options);
        }
    }

    public void addBehavior(Variable v, IMethod method, RelationEntity re) {
        if (this._helper != null && method != null && this._behaviorList != null) {
            CodeExecutionRelationBehavior behavior = new CodeExecutionRelationBehavior(v, method, this._helper);
            CodeExecutionRelationPersistentOptions options = new CodeExecutionRelationPersistentOptions(behavior);
            options.setVariable(v);
            this.addbehavior(behavior);
            this._helper.addBehavior(new RelationActivationState(re), this.getPluginName(), (RelationBehavior)behavior, (PersistentOptions)options);
        }
    }

    public BehaviorConfigurator<?> getConfigurator(ConfigurationHelper configurationHelper) {
        return new CodeExecutorConfigurator(configurationHelper, this);
    }

    protected HashMap<String, Object> getData() {
        return this.ceh.getData();
    }

    public void addBehaviorsFromModel(String selectedFile) {
        CodeExecutionSpecification model = this.loadCodeExecutionSpecification(selectedFile);
        if (model != null) {
            for (CodeExecutionModelBehavior behavior : model.getBehaviors()) {
                if (behavior instanceof CodeExecClockBehavior) {
                    this.buildClockBehavior((CodeExecClockBehavior)behavior);
                    continue;
                }
                if (behavior instanceof CodeExecRelationBehavior) {
                    this.buildRelationBehavior((CodeExecRelationBehavior)behavior);
                    continue;
                }
                if (!(behavior instanceof CodeExecAssertionBehavior)) continue;
                this.buildAssertionBehavior((CodeExecAssertionBehavior)behavior);
            }
        }
    }

    private CodeExecutionSpecification loadCodeExecutionSpecification(String filename) {
        if (filename == null || filename.isEmpty()) {
            return null;
        }
        this.setCodeExecModelFilename(filename);
        String language = "fr.inria.aoste.timesquare.backend.codeexecution.CodeExecutionSpec";
        Injector injector = CodeExecutionSpecActivator.getInstance().getInjector(language);
        XtextResourceSetProvider provider = (XtextResourceSetProvider)injector.getInstance(XtextResourceSetProvider.class);
        XtextResourceSet resourceSet = (XtextResourceSet)provider.get(this.findContainingProject(filename));
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        URI uri = URI.createPlatformResourceURI((String)filename, (boolean)true);
        XtextResource resource = (XtextResource)resourceSet.getResource(uri, true);
        EList errors = resource.getErrors();
        if (!errors.isEmpty()) {
            return null;
        }
        return (CodeExecutionSpecification)resource.getContents().get(0);
    }

    private IProject findContainingProject(String filename) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IPath path = root.getLocation();
        path = path.append((IPath)new Path(filename));
        IFile file = (IFile)root.findMember(filename);
        return file != null ? file.getProject() : null;
    }

    private void buildClockBehavior(CodeExecClockBehavior behavior) {
        ClockEntity ce = this.findClockEntity((ConcreteEntity)behavior.getClock());
        ClockActivationState activationState = this.buildClockActivationState(behavior);
        Variable var = this.getOrCreateVariable(behavior.getObjectVariable());
        String methodName = behavior.getMethod().getSimpleName();
        ArrayList<ClockEntity> ceToForce = new ArrayList<ClockEntity>();
        for (Clock c : behavior.getClockToForce()) {
            ceToForce.add(this.findClockEntity((ConcreteEntity)c));
        }
        this.addBehavior(var, methodName, ce, activationState, ceToForce);
    }

    private void buildRelationBehavior(CodeExecRelationBehavior behavior) {
        Relation relation = behavior.getRelation();
        System.out.println("** Creation of behavior for a Relation: (Temporarily) Unsupported operation !!");
    }

    private void buildAssertionBehavior(CodeExecAssertionBehavior behavior) {
        Relation relation = behavior.getAssertion();
        String assertQualifiedName = CCSLKernelUtils.getQualifiedName((EObject)relation);
        ClockEntity assertClockEntity = null;
        for (ClockEntity ce : this._helper.getAssert()) {
            ModelElementReference mer = ce.getModelElementReference();
            String path = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)mer, (String)qualifiedNameSeparator);
            if (assertQualifiedName.compareTo(path) != 0) continue;
            assertClockEntity = ce;
            break;
        }
        if (assertClockEntity != null) {
            Variable var = this.getOrCreateVariable(behavior.getObjectVariable());
            String methodName = behavior.getMethod().getSimpleName();
            boolean[] assertState = new boolean[]{behavior.isSatisfied(), behavior.isFailed()};
            this.addBehavior(var, methodName, assertClockEntity, assertState);
        }
    }

    private Variable getOrCreateVariable(ObjectVariable var) {
        String name = var.getName();
        for (Variable variable : this._listvariable) {
            if (variable.name.compareTo(name) != 0) continue;
            return variable;
        }
        JvmTypeReference typeRef = var.getType();
        JvmType jtype = typeRef.getType();
        String typeName = jtype.getIdentifier();
        Variable variable = this.createVariable(name, typeName);
        return variable;
    }

    private ClockActivationState buildClockActivationState(CodeExecClockBehavior behavior) {
        ClockActivationState activationState = new ClockActivationState();
        for (FiredStateKind e : behavior.getFireState()) {
            if (e == FiredStateKind.TICK) {
                activationState.setState(ClockActivationState.State.ticks, true);
                continue;
            }
            if (e != FiredStateKind.NO_TICK) continue;
            activationState.setState(ClockActivationState.State.doesntTick, true);
        }
        for (FiredStateKind e : behavior.getEnableState()) {
            if (e == EnableStateKind.FREE) {
                activationState.setState(ClockActivationState.State.isFree, true);
                continue;
            }
            if (e == EnableStateKind.INDETERMINED) {
                activationState.setState(ClockActivationState.State.isUndetermined, true);
                continue;
            }
            if (e == EnableStateKind.NO_TICK) {
                activationState.setState(ClockActivationState.State.cannotTick, true);
                continue;
            }
            if (e != EnableStateKind.TICK) continue;
            activationState.setState(ClockActivationState.State.mustTick, true);
        }
        for (FiredStateKind e : behavior.getLiveState()) {
            if (e == LiveStateKind.IS_ALIVE) {
                activationState.setState(ClockActivationState.State.notIsDead, true);
                continue;
            }
            if (e != LiveStateKind.IS_DEAD) continue;
            activationState.setState(ClockActivationState.State.isDead, true);
        }
        return activationState;
    }

    private ClockEntity findClockEntity(ConcreteEntity clock) {
        String clockPath = CCSLKernelUtils.getQualifiedName((EObject)clock, (String)qualifiedNameSeparator);
        for (ClockEntity ce : this._helper.getClocks()) {
            ModelElementReference mer = ce.getModelElementReference();
            String path = ReferenceNameBuilder.buildQualifiedName((ModelElementReference)mer, (String)qualifiedNameSeparator);
            if (clockPath.compareTo(path) != 0) continue;
            return ce;
        }
        return null;
    }
}

