/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.explorer.ui;

import fr.inria.aoste.timesquare.ccslkernel.explorer.StateSpace;
import fr.inria.aoste.timesquare.explorer.ui.Activator;
import fr.inria.aoste.timesquare.explorer.ui.StateSpace4zest;
import fr.inria.aoste.timesquare.utils.console.ErrorConsole;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.zest.core.viewers.IZoomableWorkbenchPart;
import org.eclipse.zest.core.viewers.ZoomContributionViewItem;
import org.eclipse.zest.core.widgets.Graph;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.DirectedGraphLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.GridLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.HorizontalShift;
import org.eclipse.zest.layouts.algorithms.HorizontalTreeLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;

public class StateSpaceView
extends ViewPart {
    public static final String STATESPACE = "State space";
    public static final String RELOAD_LAYOUT = "Reload Layout";
    public static final String RELOAD_FILE = "Reload file";
    public static final String LAYOUT = "Layout";
    public static final String UPDATE_LAYOUT = "Update Layout";
    public static final String CHANGE_LAYOUT = "Change Layout";
    private static final String STRING_INTERNAL2 = "]";
    private static final String STRING_INTERNAL1 = "\n[";
    public static final String ID = "fr.inria.aoste.timesquare.explorer.ui.StateSpaceView";
    private static StateSpaceView courant = null;
    private ArrayList<SetAlgorithm> listsetAlgorithms = new ArrayList();
    private StateSpace4zest zestCreator = null;
    private Graph _g = null;
    private ChangeLayoutAction action1;
    private UpdateLayoutAction action2;
    private StateSpaceAction newAction;
    private String filename = "";
    private String algoname = "";
    private LayoutAlgorithm _layoutAlgorithm = new TreeLayoutAlgorithm(1);
    private Composite _parent;
    RectangleWithMessage tipRectangle = null;
    ZoomContributionViewItem zoomContributionViewItem;

    public static String getClassNameWithSpace(Object o) {
        if (o != null) {
            return o.getClass().getSimpleName().replaceAll("[A-Z]", " $0").trim();
        }
        return "";
    }

    public StateSpaceView() {
        StateSpaceView.setCourant(this);
    }

    public static synchronized StateSpaceView getCourant() {
        if (courant == null) {
            try {
                PluginHelpers.getShowView((String)ID);
                if (courant == null) {
                    PluginHelpers.getCreateView((String)ID);
                }
                PluginHelpers.getShowView((String)ID);
                if (courant != null) {
                    courant.setFocus();
                }
            }
            catch (Throwable ex) {
                ErrorConsole.printError((Throwable)ex, (String)STATESPACE);
            }
        }
        return courant;
    }

    public void dispose() {
        super.dispose();
        StateSpaceView.setCourant(null);
    }

    private static final synchronized void setCourant(StateSpaceView courant) {
        StateSpaceView.courant = courant;
    }

    public void createPartControl(Composite parent) {
        this._parent = parent;
        this.zestCreator = new StateSpace4zest(parent);
        this.initAlgorithm();
        this.makeActions();
        this.contributeToActionBars();
    }

    private void initAlgorithm() {
        this.addAlgorithms(this._layoutAlgorithm);
        this.addAlgorithms((LayoutAlgorithm)new HorizontalTreeLayoutAlgorithm(1));
        this.addAlgorithms((LayoutAlgorithm)new RadialLayoutAlgorithm(1));
        this.addAlgorithms((LayoutAlgorithm)new GridLayoutAlgorithm(1));
        this.addAlgorithms((LayoutAlgorithm)new HorizontalShift(1));
        this.addAlgorithms((LayoutAlgorithm)new SpringLayoutAlgorithm(1));
        this.addAlgorithms((LayoutAlgorithm)new DirectedGraphLayoutAlgorithm(1));
        for (SetAlgorithm sa : this.listsetAlgorithms) {
            sa.setChecked(sa.mylayoutAlgorithm == this._layoutAlgorithm);
        }
    }

    private void addAlgorithms(LayoutAlgorithm _layoutAlgorithm) {
        SetAlgorithm action = new SetAlgorithm(_layoutAlgorithm);
        this.listsetAlgorithms.add(action);
    }

    public ArrayList<String> getListAlgorithms() {
        ArrayList<String> ls = new ArrayList<String>();
        for (SetAlgorithm sa : this.listsetAlgorithms) {
            ls.add(sa.getText());
        }
        return ls;
    }

    public void setFocus() {
    }

    public void display(StateSpace g, String _filename) {
        if (this.zestCreator == null) {
            System.err.println("Error :zestCreator is null");
            return;
        }
        if (this.tipRectangle != null && this._g != null) {
            this._g.getContents().remove((IFigure)this.tipRectangle);
            this.tipRectangle = null;
        }
        this.filename = _filename;
        this.zestCreator.dispose();
        this.zestCreator.setGrph(g);
        this._g = this.zestCreator.getZestGraph();
        this.setContentDescription(String.valueOf(this.filename) + STRING_INTERNAL1 + this.algoname + STRING_INTERNAL2);
        this.runLayout();
    }

    public void cleanDiagram(String _filename, String message) {
        this.filename = _filename;
        this.zestCreator.setGrph(null);
        this._g = this.zestCreator.getZestGraph();
        int x = this._parent.getSize().x;
        int y = this._parent.getSize().y;
        if (this.tipRectangle != null) {
            this._g.getContents().remove((IFigure)this.tipRectangle);
        }
        String text = String.valueOf(_filename) + "\n\n\n" + message;
        this.tipRectangle = new RectangleWithMessage(text, x, y);
        this._g.getContents().add((IFigure)this.tipRectangle);
    }

    private void runLayout() {
        if (this._g != null) {
            this._g.setLayoutAlgorithm(this._layoutAlgorithm, true);
        }
    }

    public void setLayoutAlgorithm(LayoutAlgorithm layoutAlgorithm) {
        this._layoutAlgorithm = layoutAlgorithm;
        this.algoname = StateSpaceView.getClassNameWithSpace(this._layoutAlgorithm);
        if (this._g != null) {
            this._g.setLayoutAlgorithm(layoutAlgorithm, true);
        }
        this.setContentDescription(String.valueOf(this.filename) + STRING_INTERNAL1 + this.algoname + STRING_INTERNAL2);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action2);
        manager.add((IAction)this.newAction);
        MenuManager manager2 = new MenuManager(LAYOUT, "fr.inria.aoste.timesquare.explorer.ui.StateSpaceView.menu.layout");
        manager.add((IContributionItem)manager2);
        for (SetAlgorithm action : this.listsetAlgorithms) {
            manager2.add((IAction)action);
        }
    }

    private void makeActions() {
        this.action1 = new ChangeLayoutAction();
        this.action2 = new UpdateLayoutAction();
        this.newAction = new StateSpaceAction(RELOAD_FILE, PluginHelpers.getImageDescriptor((String)"org.eclipse.ui.ide", (String)"/icons/full/elcl16/refresh_nav.gif"));
        this.newAction.setToolTipText(RELOAD_LAYOUT);
        this.zoomContributionViewItem = new ZoomContributionViewItem((IZoomableWorkbenchPart)this.zestCreator);
    }

    private void fillLocalToolBar(IToolBarManager mgr) {
        mgr.add((IAction)this.action2);
        mgr.add((IAction)this.newAction);
        mgr.add((IAction)this.action1);
        mgr.add((IContributionItem)this.zoomContributionViewItem);
        if (mgr instanceof ToolBarManager) {
            ToolBarManager tbm = (ToolBarManager)mgr;
            final ToolBar tb = tbm.getControl();
            tb.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    ActionContributionItem actionContributionItem;
                    IAction action;
                    ToolItem ti = tb.getItem(new org.eclipse.swt.graphics.Point(e.x, e.y));
                    if (ti != null && ti.getData() instanceof ActionContributionItem && (action = (actionContributionItem = (ActionContributionItem)ti.getData()).getAction()) == StateSpaceView.this.action1) {
                        Event event = new Event();
                        event.widget = ti;
                        event.x = e.x;
                        event.y = e.y;
                        action.runWithEvent(event);
                    }
                }
            });
        }
    }

    public final class ChangeLayoutAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;

        public ChangeLayoutAction() {
            this.setImageDescriptor(PluginHelpers.getImageDescriptor((String)"org.eclipse.zest.core", (String)"/icons/tree_normal.gif"));
            this.setToolTipText(StateSpaceView.CHANGE_LAYOUT);
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            for (SetAlgorithm la : StateSpaceView.this.listsetAlgorithms) {
                ActionContributionItem item = new ActionContributionItem((IAction)la);
                item.fill(this.fMenu, -1);
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        public void runWithEvent(Event event) {
            if (event.widget instanceof ToolItem) {
                ToolItem toolItem = (ToolItem)event.widget;
                ToolBar control = toolItem.getParent();
                Menu menu = this.getMenu((Control)control);
                org.eclipse.swt.graphics.Rectangle bounds = toolItem.getBounds();
                org.eclipse.swt.graphics.Point topLeft = new org.eclipse.swt.graphics.Point(bounds.x, bounds.y + bounds.height);
                menu.setLocation(control.toDisplay(topLeft));
                menu.setVisible(true);
            }
        }
    }

    private static final class RectangleWithMessage
    extends RectangleFigure {
        private Label l = null;

        public RectangleWithMessage(String texte, int x, int y) {
            this.setVisible(true);
            this.setOpaque(false);
            this.setLineStyle(3);
            this.setForegroundColor(ColorConstants.yellow);
            this.setBackgroundColor(ColorConstants.yellow);
            this.setBounds(new Rectangle(0, 0, x, y));
            this.l = new Label();
            this.l.setText(texte);
            this.l.setLocation(new Point(5, 5));
            this.l.setForegroundColor(ColorConstants.black);
            this.l.setOpaque(true);
            this.l.setVisible(true);
            this.l.setSize(x, y);
            this.add((IFigure)this.l);
        }

        public void repaint() {
            if (this.l != null) {
                this.l.repaint();
            }
            super.repaint();
        }
    }

    public final class SetAlgorithm
    extends Action {
        private LayoutAlgorithm mylayoutAlgorithm;

        public void run() {
            StateSpaceView.this.setLayoutAlgorithm(this.mylayoutAlgorithm);
            Iterator iterator = StateSpaceView.this.listsetAlgorithms.iterator();
            while (iterator.hasNext()) {
                SetAlgorithm sa;
                sa.setChecked((sa = (SetAlgorithm)((Object)iterator.next())) == this);
            }
        }

        public SetAlgorithm(String text, LayoutAlgorithm layoutAlgorithm) {
            super(text);
            this.mylayoutAlgorithm = layoutAlgorithm;
        }

        public SetAlgorithm(LayoutAlgorithm layoutAlgorithm) {
            super(StateSpaceView.getClassNameWithSpace(layoutAlgorithm));
            this.mylayoutAlgorithm = layoutAlgorithm;
        }
    }

    public class StateSpaceAction
    extends Action
    implements IObjectActionDelegate,
    Runnable {
        public StateSpace statespace;

        public StateSpaceAction(String text, ImageDescriptor image) {
            super(text, image);
            this.statespace = null;
        }

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        }

        public void run(IAction action) {
            this.run();
        }

        @Override
        public void run() {
            try {
                if (this.statespace != null) {
                    StateSpaceView.getCourant().display(this.statespace, StateSpaceView.this.filename);
                }
            }
            catch (Throwable e) {
                String message = "Clock Graph : [" + e.getMessage() + StateSpaceView.STRING_INTERNAL2;
                Activator.getDefault().getLog().log((IStatus)new Status(4, "fr.inria.aoste.timesquare.explorer.ui", message, e));
                e.printStackTrace();
                StateSpaceView.getCourant().cleanDiagram(StateSpaceView.this.filename, message);
            }
        }

        public void selectionChanged(IAction action, ISelection selection) {
        }

        public String getFilename() {
            return StateSpaceView.this.filename;
        }

        public void setStateSpace(StateSpace s) {
            this.statespace = s;
        }

        public void runInDisplay() {
            Display.getDefault().syncExec((Runnable)this);
        }
    }

    public final class UpdateLayoutAction
    extends Action {
        public UpdateLayoutAction() {
            this.setText(StateSpaceView.LAYOUT);
            this.setToolTipText(StateSpaceView.UPDATE_LAYOUT);
            this.setImageDescriptor(PluginHelpers.getImageDescriptor((String)"org.eclipse.jdt.ui", (String)"/icons/full/elcl16/refresh.gif"));
        }

        public void run() {
            StateSpaceView.this.runLayout();
        }
    }
}

