/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.typesystem;

import com.google.inject.Inject;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import fr.inria.diverse.melange.typesystem.MelangeTypesRegistry;
import java.util.function.Consumer;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;

/**
 * Extends Xbase with modeltype-specific type synonyms.
 * <br>
 * For any type mm referring to a concrete metamodel, with
 * its implemented types mt_0..mt_n:
 *     - announce a synonym from mm to mt_i
 * <br>
 * For any type mt subtype of mt':
 *     - announce a synonym from mt to mt'
 * 
 * @see MelangeTypesRegistry
 */
@SuppressWarnings("all")
public class MelangeSynonymTypesProvider extends SynonymTypesProvider {
  @Inject
  @Extension
  private IQualifiedNameProvider _iQualifiedNameProvider;
  
  @Inject
  private MelangeTypesRegistry typesRegistry;
  
  @Override
  public boolean collectCustomSynonymTypes(final LightweightTypeReference type, final SynonymTypesProvider.Acceptor acceptor) {
    final Consumer<ModelType> _function = new Consumer<ModelType>() {
      @Override
      public void accept(final ModelType mt) {
        MelangeSynonymTypesProvider.this.announceModelType(
          type.getOwner(), 
          MelangeSynonymTypesProvider.this._iQualifiedNameProvider.getFullyQualifiedName(mt).toString(), acceptor);
      }
    };
    this.typesRegistry.getImplementations(type.getIdentifier()).forEach(_function);
    final Consumer<ModelType> _function_1 = new Consumer<ModelType>() {
      @Override
      public void accept(final ModelType mt) {
        MelangeSynonymTypesProvider.this.announceModelType(
          type.getOwner(), 
          MelangeSynonymTypesProvider.this._iQualifiedNameProvider.getFullyQualifiedName(mt).toString(), acceptor);
      }
    };
    this.typesRegistry.getSubtypings(type.getIdentifier()).forEach(_function_1);
    return super.collectCustomSynonymTypes(type, acceptor);
  }
  
  protected boolean announceModelType(final ITypeReferenceOwner owner, final String targetName, final SynonymTypesProvider.Acceptor acceptor) {
    final TypeReferences typeRefs = owner.getServices().getTypeReferences();
    final JvmType synonym = typeRefs.findDeclaredType(targetName, owner.getContextResourceSet());
    boolean _xifexpression = false;
    if ((synonym != null)) {
      ParameterizedTypeReference _parameterizedTypeReference = new ParameterizedTypeReference(owner, synonym);
      _xifexpression = this.announceSynonym(_parameterizedTypeReference, 
        ConformanceHint.CHECKED, acceptor);
    } else {
      _xifexpression = true;
    }
    return _xifexpression;
  }
}
