/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.builder;

import fr.inria.diverse.melange.builder.Builder;
import fr.inria.diverse.melange.builder.BuilderError;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

/**
 * Default implementation of {@link Builder}. An {@link EPackage} {@code model}
 * is attached to the builder that correspond to what has been built.
 * <br>
 * Implementors must later implement the {@link Builder#make} method.
 */
@SuppressWarnings("all")
public abstract class AbstractBuilder implements Builder {
  /**
   * A set of {@link EPackage} containing the chunk of syntax generated
   * from this builder. Each {@link EPackage} is a root of the chunk.
   */
  protected Set<EPackage> model = CollectionLiterals.<EPackage>newHashSet();
  
  /**
   * {@link BuilderError} collected during the build.
   */
  protected List<BuilderError> errors = CollectionLiterals.<BuilderError>newArrayList();
  
  @Override
  public void preBuild() {
    this.model = CollectionLiterals.<EPackage>newHashSet();
    this.errors = CollectionLiterals.<BuilderError>newArrayList();
  }
  
  @Override
  public void postBuild() {
  }
  
  public Set<EPackage> getModel() {
    return this.model;
  }
  
  @Override
  public List<BuilderError> getErrors() {
    return this.errors;
  }
  
  public final void build() {
    this.preBuild();
    this.make();
    this.postBuild();
  }
}
