/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.internal.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.aspectj.internal.lang.annotation.ajcDeclareAnnotation;
import org.aspectj.internal.lang.annotation.ajcDeclareEoW;
import org.aspectj.internal.lang.annotation.ajcDeclareParents;
import org.aspectj.internal.lang.annotation.ajcDeclarePrecedence;
import org.aspectj.internal.lang.annotation.ajcDeclareSoft;
import org.aspectj.internal.lang.annotation.ajcITD;
import org.aspectj.internal.lang.annotation.ajcPrivileged;
import org.aspectj.internal.lang.reflect.AdviceImpl;
import org.aspectj.internal.lang.reflect.DeclareAnnotationImpl;
import org.aspectj.internal.lang.reflect.DeclareErrorOrWarningImpl;
import org.aspectj.internal.lang.reflect.DeclareParentsImpl;
import org.aspectj.internal.lang.reflect.DeclarePrecedenceImpl;
import org.aspectj.internal.lang.reflect.DeclareSoftImpl;
import org.aspectj.internal.lang.reflect.InterTypeConstructorDeclarationImpl;
import org.aspectj.internal.lang.reflect.InterTypeFieldDeclarationImpl;
import org.aspectj.internal.lang.reflect.InterTypeMethodDeclarationImpl;
import org.aspectj.internal.lang.reflect.PerClauseImpl;
import org.aspectj.internal.lang.reflect.PointcutBasedPerClauseImpl;
import org.aspectj.internal.lang.reflect.PointcutImpl;
import org.aspectj.internal.lang.reflect.TypePatternBasedPerClauseImpl;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.DeclareError;
import org.aspectj.lang.annotation.DeclareParents;
import org.aspectj.lang.annotation.DeclareWarning;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.Advice;
import org.aspectj.lang.reflect.AdviceKind;
import org.aspectj.lang.reflect.AjType;
import org.aspectj.lang.reflect.AjTypeSystem;
import org.aspectj.lang.reflect.DeclareAnnotation;
import org.aspectj.lang.reflect.DeclareErrorOrWarning;
import org.aspectj.lang.reflect.DeclarePrecedence;
import org.aspectj.lang.reflect.DeclareSoft;
import org.aspectj.lang.reflect.InterTypeConstructorDeclaration;
import org.aspectj.lang.reflect.InterTypeFieldDeclaration;
import org.aspectj.lang.reflect.InterTypeMethodDeclaration;
import org.aspectj.lang.reflect.NoSuchAdviceException;
import org.aspectj.lang.reflect.NoSuchPointcutException;
import org.aspectj.lang.reflect.PerClause;
import org.aspectj.lang.reflect.PerClauseKind;

public class AjTypeImpl<T>
implements AjType<T> {
    private static final String ajcMagic = "ajc$";
    private Class<T> clazz;
    private org.aspectj.lang.reflect.Pointcut[] declaredPointcuts = null;
    private org.aspectj.lang.reflect.Pointcut[] pointcuts = null;
    private Advice[] declaredAdvice = null;
    private Advice[] advice = null;
    private InterTypeMethodDeclaration[] declaredITDMethods = null;
    private InterTypeMethodDeclaration[] itdMethods = null;
    private InterTypeFieldDeclaration[] declaredITDFields = null;
    private InterTypeFieldDeclaration[] itdFields = null;
    private InterTypeConstructorDeclaration[] itdCons = null;
    private InterTypeConstructorDeclaration[] declaredITDCons = null;

    public AjTypeImpl(Class<T> fromClass) {
        this.clazz = fromClass;
    }

    @Override
    public String getName() {
        return this.clazz.getName();
    }

    @Override
    public Package getPackage() {
        return this.clazz.getPackage();
    }

    @Override
    public AjType<?>[] getInterfaces() {
        Class<?>[] baseInterfaces = this.clazz.getInterfaces();
        return this.toAjTypeArray(baseInterfaces);
    }

    @Override
    public int getModifiers() {
        return this.clazz.getModifiers();
    }

    @Override
    public Class<T> getJavaClass() {
        return this.clazz;
    }

    @Override
    public AjType<? super T> getSupertype() {
        Class<T> superclass = this.clazz.getSuperclass();
        return superclass == null ? null : new AjTypeImpl<T>(superclass);
    }

    @Override
    public Type getGenericSupertype() {
        return this.clazz.getGenericSuperclass();
    }

    @Override
    public Method getEnclosingMethod() {
        return this.clazz.getEnclosingMethod();
    }

    @Override
    public Constructor getEnclosingConstructor() {
        return this.clazz.getEnclosingConstructor();
    }

    @Override
    public AjType<?> getEnclosingType() {
        Class<?> enc = this.clazz.getEnclosingClass();
        return enc != null ? new AjTypeImpl(enc) : null;
    }

    @Override
    public AjType<?> getDeclaringType() {
        Class<?> dec = this.clazz.getDeclaringClass();
        return dec != null ? new AjTypeImpl(dec) : null;
    }

    @Override
    public PerClause getPerClause() {
        if (this.isAspect()) {
            Aspect aspectAnn = this.clazz.getAnnotation(Aspect.class);
            String perClause = aspectAnn.value();
            if (perClause.equals("")) {
                if (this.getSupertype().isAspect()) {
                    return this.getSupertype().getPerClause();
                }
                return new PerClauseImpl(PerClauseKind.SINGLETON);
            }
            if (perClause.startsWith("perthis(")) {
                return new PointcutBasedPerClauseImpl(PerClauseKind.PERTHIS, perClause.substring("perthis(".length(), perClause.length() - 1));
            }
            if (perClause.startsWith("pertarget(")) {
                return new PointcutBasedPerClauseImpl(PerClauseKind.PERTARGET, perClause.substring("pertarget(".length(), perClause.length() - 1));
            }
            if (perClause.startsWith("percflow(")) {
                return new PointcutBasedPerClauseImpl(PerClauseKind.PERCFLOW, perClause.substring("percflow(".length(), perClause.length() - 1));
            }
            if (perClause.startsWith("percflowbelow(")) {
                return new PointcutBasedPerClauseImpl(PerClauseKind.PERCFLOWBELOW, perClause.substring("percflowbelow(".length(), perClause.length() - 1));
            }
            if (perClause.startsWith("pertypewithin")) {
                return new TypePatternBasedPerClauseImpl(PerClauseKind.PERTYPEWITHIN, perClause.substring("pertypewithin(".length(), perClause.length() - 1));
            }
            throw new IllegalStateException("Per-clause not recognized: " + perClause);
        }
        return null;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.clazz.isAnnotationPresent(annotationType);
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        return this.clazz.getAnnotation(annotationType);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.clazz.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.clazz.getDeclaredAnnotations();
    }

    @Override
    public AjType<?>[] getAjTypes() {
        Class<?>[] classes = this.clazz.getClasses();
        return this.toAjTypeArray(classes);
    }

    @Override
    public AjType<?>[] getDeclaredAjTypes() {
        Class<?>[] classes = this.clazz.getDeclaredClasses();
        return this.toAjTypeArray(classes);
    }

    @Override
    public Constructor getConstructor(AjType<?> ... parameterTypes) throws NoSuchMethodException {
        return this.clazz.getConstructor(this.toClassArray(parameterTypes));
    }

    @Override
    public Constructor[] getConstructors() {
        return this.clazz.getConstructors();
    }

    @Override
    public Constructor getDeclaredConstructor(AjType<?> ... parameterTypes) throws NoSuchMethodException {
        return this.clazz.getDeclaredConstructor(this.toClassArray(parameterTypes));
    }

    @Override
    public Constructor[] getDeclaredConstructors() {
        return this.clazz.getDeclaredConstructors();
    }

    @Override
    public Field getDeclaredField(String name) throws NoSuchFieldException {
        Field f = this.clazz.getDeclaredField(name);
        if (f.getName().startsWith(ajcMagic)) {
            throw new NoSuchFieldException(name);
        }
        return f;
    }

    @Override
    public Field[] getDeclaredFields() {
        Field[] fields = this.clazz.getDeclaredFields();
        ArrayList<Field> filteredFields = new ArrayList<Field>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!(field.getName().startsWith(ajcMagic) || field.isAnnotationPresent(DeclareWarning.class) || field.isAnnotationPresent(DeclareError.class))) {
                filteredFields.add(field);
            }
            ++n2;
        }
        Field[] ret = new Field[filteredFields.size()];
        filteredFields.toArray(ret);
        return ret;
    }

    @Override
    public Field getField(String name) throws NoSuchFieldException {
        Field f = this.clazz.getField(name);
        if (f.getName().startsWith(ajcMagic)) {
            throw new NoSuchFieldException(name);
        }
        return f;
    }

    @Override
    public Field[] getFields() {
        Field[] fields = this.clazz.getFields();
        ArrayList<Field> filteredFields = new ArrayList<Field>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!(field.getName().startsWith(ajcMagic) || field.isAnnotationPresent(DeclareWarning.class) || field.isAnnotationPresent(DeclareError.class))) {
                filteredFields.add(field);
            }
            ++n2;
        }
        Field[] ret = new Field[filteredFields.size()];
        filteredFields.toArray(ret);
        return ret;
    }

    @Override
    public Method getDeclaredMethod(String name, AjType<?> ... parameterTypes) throws NoSuchMethodException {
        Method m = this.clazz.getDeclaredMethod(name, this.toClassArray(parameterTypes));
        if (!this.isReallyAMethod(m)) {
            throw new NoSuchMethodException(name);
        }
        return m;
    }

    @Override
    public Method getMethod(String name, AjType<?> ... parameterTypes) throws NoSuchMethodException {
        Method m = this.clazz.getMethod(name, this.toClassArray(parameterTypes));
        if (!this.isReallyAMethod(m)) {
            throw new NoSuchMethodException(name);
        }
        return m;
    }

    @Override
    public Method[] getDeclaredMethods() {
        Method[] methods = this.clazz.getDeclaredMethods();
        ArrayList<Method> filteredMethods = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.isReallyAMethod(method)) {
                filteredMethods.add(method);
            }
            ++n2;
        }
        Method[] ret = new Method[filteredMethods.size()];
        filteredMethods.toArray(ret);
        return ret;
    }

    @Override
    public Method[] getMethods() {
        Method[] methods = this.clazz.getMethods();
        ArrayList<Method> filteredMethods = new ArrayList<Method>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (this.isReallyAMethod(method)) {
                filteredMethods.add(method);
            }
            ++n2;
        }
        Method[] ret = new Method[filteredMethods.size()];
        filteredMethods.toArray(ret);
        return ret;
    }

    private boolean isReallyAMethod(Method method) {
        if (method.getName().startsWith(ajcMagic)) {
            return false;
        }
        if (method.getAnnotations().length == 0) {
            return true;
        }
        if (method.isAnnotationPresent(Pointcut.class)) {
            return false;
        }
        if (method.isAnnotationPresent(Before.class)) {
            return false;
        }
        if (method.isAnnotationPresent(After.class)) {
            return false;
        }
        if (method.isAnnotationPresent(AfterReturning.class)) {
            return false;
        }
        if (method.isAnnotationPresent(AfterThrowing.class)) {
            return false;
        }
        return !method.isAnnotationPresent(Around.class);
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut getDeclaredPointcut(String name) throws NoSuchPointcutException {
        org.aspectj.lang.reflect.Pointcut[] pcs;
        org.aspectj.lang.reflect.Pointcut[] pointcutArray = pcs = this.getDeclaredPointcuts();
        int n = pcs.length;
        int n2 = 0;
        while (n2 < n) {
            org.aspectj.lang.reflect.Pointcut pc = pointcutArray[n2];
            if (pc.getName().equals(name)) {
                return pc;
            }
            ++n2;
        }
        throw new NoSuchPointcutException(name);
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut getPointcut(String name) throws NoSuchPointcutException {
        org.aspectj.lang.reflect.Pointcut[] pcs;
        org.aspectj.lang.reflect.Pointcut[] pointcutArray = pcs = this.getPointcuts();
        int n = pcs.length;
        int n2 = 0;
        while (n2 < n) {
            org.aspectj.lang.reflect.Pointcut pc = pointcutArray[n2];
            if (pc.getName().equals(name)) {
                return pc;
            }
            ++n2;
        }
        throw new NoSuchPointcutException(name);
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut[] getDeclaredPointcuts() {
        Method[] methods;
        if (this.declaredPointcuts != null) {
            return this.declaredPointcuts;
        }
        ArrayList<org.aspectj.lang.reflect.Pointcut> pointcuts = new ArrayList<org.aspectj.lang.reflect.Pointcut>();
        Method[] methodArray = methods = this.clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            org.aspectj.lang.reflect.Pointcut pc = this.asPointcut(method);
            if (pc != null) {
                pointcuts.add(pc);
            }
            ++n2;
        }
        org.aspectj.lang.reflect.Pointcut[] ret = new org.aspectj.lang.reflect.Pointcut[pointcuts.size()];
        pointcuts.toArray(ret);
        this.declaredPointcuts = ret;
        return ret;
    }

    @Override
    public org.aspectj.lang.reflect.Pointcut[] getPointcuts() {
        Method[] methods;
        if (this.pointcuts != null) {
            return this.pointcuts;
        }
        ArrayList<org.aspectj.lang.reflect.Pointcut> pcuts = new ArrayList<org.aspectj.lang.reflect.Pointcut>();
        Method[] methodArray = methods = this.clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            org.aspectj.lang.reflect.Pointcut pc = this.asPointcut(method);
            if (pc != null) {
                pcuts.add(pc);
            }
            ++n2;
        }
        org.aspectj.lang.reflect.Pointcut[] ret = new org.aspectj.lang.reflect.Pointcut[pcuts.size()];
        pcuts.toArray(ret);
        this.pointcuts = ret;
        return ret;
    }

    private org.aspectj.lang.reflect.Pointcut asPointcut(Method method) {
        Pointcut pcAnn = method.getAnnotation(Pointcut.class);
        if (pcAnn != null) {
            int nameStart;
            int nextDollar;
            String name = method.getName();
            if (name.startsWith(ajcMagic) && (nextDollar = (name = name.substring((nameStart = name.indexOf("$$")) + 2, name.length())).indexOf("$")) != -1) {
                name = name.substring(0, nextDollar);
            }
            return new PointcutImpl(name, pcAnn.value(), method, AjTypeSystem.getAjType(method.getDeclaringClass()), pcAnn.argNames());
        }
        return null;
    }

    @Override
    public Advice[] getDeclaredAdvice(AdviceKind ... ofType) {
        EnumSet<AdviceKind> types;
        if (ofType.length == 0) {
            types = EnumSet.allOf(AdviceKind.class);
        } else {
            types = EnumSet.noneOf(AdviceKind.class);
            types.addAll(Arrays.asList(ofType));
        }
        return this.getDeclaredAdvice(types);
    }

    @Override
    public Advice[] getAdvice(AdviceKind ... ofType) {
        EnumSet<AdviceKind> types;
        if (ofType.length == 0) {
            types = EnumSet.allOf(AdviceKind.class);
        } else {
            types = EnumSet.noneOf(AdviceKind.class);
            types.addAll(Arrays.asList(ofType));
        }
        return this.getAdvice(types);
    }

    private Advice[] getDeclaredAdvice(Set ofAdviceTypes) {
        if (this.declaredAdvice == null) {
            this.initDeclaredAdvice();
        }
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        Advice[] adviceArray = this.declaredAdvice;
        int n = this.declaredAdvice.length;
        int n2 = 0;
        while (n2 < n) {
            Advice a = adviceArray[n2];
            if (ofAdviceTypes.contains((Object)a.getKind())) {
                adviceList.add(a);
            }
            ++n2;
        }
        Advice[] ret = new Advice[adviceList.size()];
        adviceList.toArray(ret);
        return ret;
    }

    private void initDeclaredAdvice() {
        Method[] methods = this.clazz.getDeclaredMethods();
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Advice advice = this.asAdvice(method);
            if (advice != null) {
                adviceList.add(advice);
            }
            ++n2;
        }
        this.declaredAdvice = new Advice[adviceList.size()];
        adviceList.toArray(this.declaredAdvice);
    }

    private Advice[] getAdvice(Set ofAdviceTypes) {
        if (this.advice == null) {
            this.initAdvice();
        }
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        Advice[] adviceArray = this.advice;
        int n = this.advice.length;
        int n2 = 0;
        while (n2 < n) {
            Advice a = adviceArray[n2];
            if (ofAdviceTypes.contains((Object)a.getKind())) {
                adviceList.add(a);
            }
            ++n2;
        }
        Advice[] ret = new Advice[adviceList.size()];
        adviceList.toArray(ret);
        return ret;
    }

    private void initAdvice() {
        Method[] methods = this.clazz.getMethods();
        ArrayList<Advice> adviceList = new ArrayList<Advice>();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Advice advice = this.asAdvice(method);
            if (advice != null) {
                adviceList.add(advice);
            }
            ++n2;
        }
        this.advice = new Advice[adviceList.size()];
        adviceList.toArray(this.advice);
    }

    @Override
    public Advice getAdvice(String name) throws NoSuchAdviceException {
        if (name.equals("")) {
            throw new IllegalArgumentException("use getAdvice(AdviceType...) instead for un-named advice");
        }
        if (this.advice == null) {
            this.initAdvice();
        }
        Advice[] adviceArray = this.advice;
        int n = this.advice.length;
        int n2 = 0;
        while (n2 < n) {
            Advice a = adviceArray[n2];
            if (a.getName().equals(name)) {
                return a;
            }
            ++n2;
        }
        throw new NoSuchAdviceException(name);
    }

    @Override
    public Advice getDeclaredAdvice(String name) throws NoSuchAdviceException {
        if (name.equals("")) {
            throw new IllegalArgumentException("use getAdvice(AdviceType...) instead for un-named advice");
        }
        if (this.declaredAdvice == null) {
            this.initDeclaredAdvice();
        }
        Advice[] adviceArray = this.declaredAdvice;
        int n = this.declaredAdvice.length;
        int n2 = 0;
        while (n2 < n) {
            Advice a = adviceArray[n2];
            if (a.getName().equals(name)) {
                return a;
            }
            ++n2;
        }
        throw new NoSuchAdviceException(name);
    }

    private Advice asAdvice(Method method) {
        if (method.getAnnotations().length == 0) {
            return null;
        }
        Before beforeAnn = method.getAnnotation(Before.class);
        if (beforeAnn != null) {
            return new AdviceImpl(method, beforeAnn.value(), AdviceKind.BEFORE);
        }
        After afterAnn = method.getAnnotation(After.class);
        if (afterAnn != null) {
            return new AdviceImpl(method, afterAnn.value(), AdviceKind.AFTER);
        }
        AfterReturning afterReturningAnn = method.getAnnotation(AfterReturning.class);
        if (afterReturningAnn != null) {
            String pcExpr = afterReturningAnn.pointcut();
            if (pcExpr.equals("")) {
                pcExpr = afterReturningAnn.value();
            }
            return new AdviceImpl(method, pcExpr, AdviceKind.AFTER_RETURNING, afterReturningAnn.returning());
        }
        AfterThrowing afterThrowingAnn = method.getAnnotation(AfterThrowing.class);
        if (afterThrowingAnn != null) {
            String pcExpr = afterThrowingAnn.pointcut();
            if (pcExpr == null) {
                pcExpr = afterThrowingAnn.value();
            }
            return new AdviceImpl(method, pcExpr, AdviceKind.AFTER_THROWING, afterThrowingAnn.throwing());
        }
        Around aroundAnn = method.getAnnotation(Around.class);
        if (aroundAnn != null) {
            return new AdviceImpl(method, aroundAnn.value(), AdviceKind.AROUND);
        }
        return null;
    }

    @Override
    public InterTypeMethodDeclaration getDeclaredITDMethod(String name, AjType<?> target, AjType<?> ... parameterTypes) throws NoSuchMethodException {
        InterTypeMethodDeclaration[] itdms;
        InterTypeMethodDeclaration[] interTypeMethodDeclarationArray = itdms = this.getDeclaredITDMethods();
        int n = itdms.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                InterTypeMethodDeclaration itdm = interTypeMethodDeclarationArray[n2];
                try {
                    AjType<?>[] ptypes;
                    AjType<?> itdTarget;
                    if (!itdm.getName().equals(name) || !(itdTarget = itdm.getTargetType()).equals(target) || (ptypes = itdm.getParameterTypes()).length != parameterTypes.length) break block5;
                    int i = 0;
                    while (i < ptypes.length) {
                        if (ptypes[i].equals(parameterTypes[i])) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    return itdm;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        throw new NoSuchMethodException(name);
    }

    @Override
    public InterTypeMethodDeclaration[] getDeclaredITDMethods() {
        if (this.declaredITDMethods == null) {
            Method[] baseMethods;
            ArrayList<InterTypeMethodDeclaration> itdms = new ArrayList<InterTypeMethodDeclaration>();
            Method[] methodArray = baseMethods = this.clazz.getDeclaredMethods();
            int n = baseMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().contains("ajc$interMethodDispatch1$") && m.isAnnotationPresent(ajcITD.class)) {
                    ajcITD ann = m.getAnnotation(ajcITD.class);
                    InterTypeMethodDeclarationImpl itdm = new InterTypeMethodDeclarationImpl(this, ann.targetType(), ann.modifiers(), ann.name(), m);
                    itdms.add(itdm);
                }
                ++n2;
            }
            this.addAnnotationStyleITDMethods(itdms, false);
            this.declaredITDMethods = new InterTypeMethodDeclaration[itdms.size()];
            itdms.toArray(this.declaredITDMethods);
        }
        return this.declaredITDMethods;
    }

    @Override
    public InterTypeMethodDeclaration getITDMethod(String name, AjType<?> target, AjType<?> ... parameterTypes) throws NoSuchMethodException {
        InterTypeMethodDeclaration[] itdms;
        InterTypeMethodDeclaration[] interTypeMethodDeclarationArray = itdms = this.getITDMethods();
        int n = itdms.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                InterTypeMethodDeclaration itdm = interTypeMethodDeclarationArray[n2];
                try {
                    AjType<?>[] ptypes;
                    AjType<?> itdTarget;
                    if (!itdm.getName().equals(name) || !(itdTarget = itdm.getTargetType()).equals(target) || (ptypes = itdm.getParameterTypes()).length != parameterTypes.length) break block5;
                    int i = 0;
                    while (i < ptypes.length) {
                        if (ptypes[i].equals(parameterTypes[i])) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    return itdm;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        throw new NoSuchMethodException(name);
    }

    @Override
    public InterTypeMethodDeclaration[] getITDMethods() {
        if (this.itdMethods == null) {
            Method[] baseMethods;
            ArrayList<InterTypeMethodDeclaration> itdms = new ArrayList<InterTypeMethodDeclaration>();
            Method[] methodArray = baseMethods = this.clazz.getDeclaredMethods();
            int n = baseMethods.length;
            int n2 = 0;
            while (n2 < n) {
                ajcITD ann;
                Method m = methodArray[n2];
                if (m.getName().contains("ajc$interMethod$") && m.isAnnotationPresent(ajcITD.class) && Modifier.isPublic((ann = m.getAnnotation(ajcITD.class)).modifiers())) {
                    InterTypeMethodDeclarationImpl itdm = new InterTypeMethodDeclarationImpl(this, ann.targetType(), ann.modifiers(), ann.name(), m);
                    itdms.add(itdm);
                }
                ++n2;
            }
            this.addAnnotationStyleITDMethods(itdms, true);
            this.itdMethods = new InterTypeMethodDeclaration[itdms.size()];
            itdms.toArray(this.itdMethods);
        }
        return this.itdMethods;
    }

    private void addAnnotationStyleITDMethods(List<InterTypeMethodDeclaration> toList, boolean publicOnly) {
        if (this.isAspect()) {
            Field[] fieldArray = this.clazz.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<DeclareParents> decPAnnClass;
                DeclareParents decPAnn;
                Field f = fieldArray[n2];
                if (f.getType().isInterface() && f.isAnnotationPresent(DeclareParents.class) && (decPAnn = f.getAnnotation(decPAnnClass = DeclareParents.class)).defaultImpl() != decPAnnClass) {
                    Method[] methodArray = f.getType().getDeclaredMethods();
                    int n3 = methodArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Method itdM = methodArray[n4];
                        if (Modifier.isPublic(itdM.getModifiers()) || !publicOnly) {
                            InterTypeMethodDeclarationImpl itdm = new InterTypeMethodDeclarationImpl(this, AjTypeSystem.getAjType(f.getType()), itdM, 1);
                            toList.add(itdm);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    private void addAnnotationStyleITDFields(List<InterTypeFieldDeclaration> toList, boolean publicOnly) {
    }

    @Override
    public InterTypeConstructorDeclaration getDeclaredITDConstructor(AjType<?> target, AjType<?> ... parameterTypes) throws NoSuchMethodException {
        InterTypeConstructorDeclaration[] itdcs;
        InterTypeConstructorDeclaration[] interTypeConstructorDeclarationArray = itdcs = this.getDeclaredITDConstructors();
        int n = itdcs.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                InterTypeConstructorDeclaration itdc = interTypeConstructorDeclarationArray[n2];
                try {
                    AjType<?>[] ptypes;
                    AjType<?> itdTarget = itdc.getTargetType();
                    if (!itdTarget.equals(target) || (ptypes = itdc.getParameterTypes()).length != parameterTypes.length) break block5;
                    int i = 0;
                    while (i < ptypes.length) {
                        if (ptypes[i].equals(parameterTypes[i])) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    return itdc;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        throw new NoSuchMethodException();
    }

    @Override
    public InterTypeConstructorDeclaration[] getDeclaredITDConstructors() {
        if (this.declaredITDCons == null) {
            Method[] baseMethods;
            ArrayList<InterTypeConstructorDeclarationImpl> itdcs = new ArrayList<InterTypeConstructorDeclarationImpl>();
            Method[] methodArray = baseMethods = this.clazz.getDeclaredMethods();
            int n = baseMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.getName().contains("ajc$postInterConstructor") && m.isAnnotationPresent(ajcITD.class)) {
                    ajcITD ann = m.getAnnotation(ajcITD.class);
                    InterTypeConstructorDeclarationImpl itdc = new InterTypeConstructorDeclarationImpl(this, ann.targetType(), ann.modifiers(), m);
                    itdcs.add(itdc);
                }
                ++n2;
            }
            this.declaredITDCons = new InterTypeConstructorDeclaration[itdcs.size()];
            itdcs.toArray(this.declaredITDCons);
        }
        return this.declaredITDCons;
    }

    @Override
    public InterTypeConstructorDeclaration getITDConstructor(AjType<?> target, AjType<?> ... parameterTypes) throws NoSuchMethodException {
        InterTypeConstructorDeclaration[] itdcs;
        InterTypeConstructorDeclaration[] interTypeConstructorDeclarationArray = itdcs = this.getITDConstructors();
        int n = itdcs.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                InterTypeConstructorDeclaration itdc = interTypeConstructorDeclarationArray[n2];
                try {
                    AjType<?>[] ptypes;
                    AjType<?> itdTarget = itdc.getTargetType();
                    if (!itdTarget.equals(target) || (ptypes = itdc.getParameterTypes()).length != parameterTypes.length) break block5;
                    int i = 0;
                    while (i < ptypes.length) {
                        if (ptypes[i].equals(parameterTypes[i])) {
                            ++i;
                            continue;
                        }
                        break block5;
                    }
                    return itdc;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        throw new NoSuchMethodException();
    }

    @Override
    public InterTypeConstructorDeclaration[] getITDConstructors() {
        if (this.itdCons == null) {
            Method[] baseMethods;
            ArrayList<InterTypeConstructorDeclarationImpl> itdcs = new ArrayList<InterTypeConstructorDeclarationImpl>();
            Method[] methodArray = baseMethods = this.clazz.getMethods();
            int n = baseMethods.length;
            int n2 = 0;
            while (n2 < n) {
                ajcITD ann;
                Method m = methodArray[n2];
                if (m.getName().contains("ajc$postInterConstructor") && m.isAnnotationPresent(ajcITD.class) && Modifier.isPublic((ann = m.getAnnotation(ajcITD.class)).modifiers())) {
                    InterTypeConstructorDeclarationImpl itdc = new InterTypeConstructorDeclarationImpl(this, ann.targetType(), ann.modifiers(), m);
                    itdcs.add(itdc);
                }
                ++n2;
            }
            this.itdCons = new InterTypeConstructorDeclaration[itdcs.size()];
            itdcs.toArray(this.itdCons);
        }
        return this.itdCons;
    }

    @Override
    public InterTypeFieldDeclaration getDeclaredITDField(String name, AjType<?> target) throws NoSuchFieldException {
        InterTypeFieldDeclaration[] itdfs;
        InterTypeFieldDeclaration[] interTypeFieldDeclarationArray = itdfs = this.getDeclaredITDFields();
        int n = itdfs.length;
        int n2 = 0;
        while (n2 < n) {
            InterTypeFieldDeclaration itdf = interTypeFieldDeclarationArray[n2];
            if (itdf.getName().equals(name)) {
                try {
                    AjType<?> itdTarget = itdf.getTargetType();
                    if (itdTarget.equals(target)) {
                        return itdf;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        throw new NoSuchFieldException(name);
    }

    @Override
    public InterTypeFieldDeclaration[] getDeclaredITDFields() {
        ArrayList<InterTypeFieldDeclaration> itdfs = new ArrayList<InterTypeFieldDeclaration>();
        if (this.declaredITDFields == null) {
            Method[] baseMethods;
            Method[] methodArray = baseMethods = this.clazz.getDeclaredMethods();
            int n = baseMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.isAnnotationPresent(ajcITD.class) && m.getName().contains("ajc$interFieldInit")) {
                    ajcITD ann = m.getAnnotation(ajcITD.class);
                    String interFieldInitMethodName = m.getName();
                    String interFieldGetDispatchMethodName = interFieldInitMethodName.replace("FieldInit", "FieldGetDispatch");
                    try {
                        Method dispatch = this.clazz.getDeclaredMethod(interFieldGetDispatchMethodName, m.getParameterTypes());
                        InterTypeFieldDeclarationImpl itdf = new InterTypeFieldDeclarationImpl(this, ann.targetType(), ann.modifiers(), ann.name(), AjTypeSystem.getAjType(dispatch.getReturnType()), dispatch.getGenericReturnType());
                        itdfs.add(itdf);
                    }
                    catch (NoSuchMethodException nsmEx) {
                        throw new IllegalStateException("Can't find field get dispatch method for " + m.getName());
                    }
                }
                ++n2;
            }
            this.addAnnotationStyleITDFields(itdfs, false);
            this.declaredITDFields = new InterTypeFieldDeclaration[itdfs.size()];
            itdfs.toArray(this.declaredITDFields);
        }
        return this.declaredITDFields;
    }

    @Override
    public InterTypeFieldDeclaration getITDField(String name, AjType<?> target) throws NoSuchFieldException {
        InterTypeFieldDeclaration[] itdfs;
        InterTypeFieldDeclaration[] interTypeFieldDeclarationArray = itdfs = this.getITDFields();
        int n = itdfs.length;
        int n2 = 0;
        while (n2 < n) {
            InterTypeFieldDeclaration itdf = interTypeFieldDeclarationArray[n2];
            if (itdf.getName().equals(name)) {
                try {
                    AjType<?> itdTarget = itdf.getTargetType();
                    if (itdTarget.equals(target)) {
                        return itdf;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        throw new NoSuchFieldException(name);
    }

    @Override
    public InterTypeFieldDeclaration[] getITDFields() {
        ArrayList<InterTypeFieldDeclaration> itdfs = new ArrayList<InterTypeFieldDeclaration>();
        if (this.itdFields == null) {
            Method[] baseMethods;
            Method[] methodArray = baseMethods = this.clazz.getMethods();
            int n = baseMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method m = methodArray[n2];
                if (m.isAnnotationPresent(ajcITD.class)) {
                    ajcITD ann = m.getAnnotation(ajcITD.class);
                    if (m.getName().contains("ajc$interFieldInit") && Modifier.isPublic(ann.modifiers())) {
                        String interFieldInitMethodName = m.getName();
                        String interFieldGetDispatchMethodName = interFieldInitMethodName.replace("FieldInit", "FieldGetDispatch");
                        try {
                            Method dispatch = m.getDeclaringClass().getDeclaredMethod(interFieldGetDispatchMethodName, m.getParameterTypes());
                            InterTypeFieldDeclarationImpl itdf = new InterTypeFieldDeclarationImpl(this, ann.targetType(), ann.modifiers(), ann.name(), AjTypeSystem.getAjType(dispatch.getReturnType()), dispatch.getGenericReturnType());
                            itdfs.add(itdf);
                        }
                        catch (NoSuchMethodException nsmEx) {
                            throw new IllegalStateException("Can't find field get dispatch method for " + m.getName());
                        }
                    }
                }
                ++n2;
            }
            this.addAnnotationStyleITDFields(itdfs, true);
            this.itdFields = new InterTypeFieldDeclaration[itdfs.size()];
            itdfs.toArray(this.itdFields);
        }
        return this.itdFields;
    }

    @Override
    public DeclareErrorOrWarning[] getDeclareErrorOrWarnings() {
        ArrayList<DeclareErrorOrWarningImpl> deows = new ArrayList<DeclareErrorOrWarningImpl>();
        AccessibleObject[] accessibleObjectArray = this.clazz.getDeclaredFields();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            try {
                DeclareErrorOrWarningImpl deow;
                String message;
                if (field.isAnnotationPresent(DeclareWarning.class)) {
                    DeclareWarning dw = field.getAnnotation(DeclareWarning.class);
                    if (Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers())) {
                        message = (String)field.get(null);
                        deow = new DeclareErrorOrWarningImpl(dw.value(), message, false, this);
                        deows.add(deow);
                    }
                } else if (field.isAnnotationPresent(DeclareError.class)) {
                    DeclareError de = field.getAnnotation(DeclareError.class);
                    if (Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers())) {
                        message = (String)field.get(null);
                        deow = new DeclareErrorOrWarningImpl(de.value(), message, true, this);
                        deows.add(deow);
                    }
                }
            }
            catch (IllegalArgumentException de) {
            }
            catch (IllegalAccessException de) {
                // empty catch block
            }
            ++n2;
        }
        accessibleObjectArray = this.clazz.getDeclaredMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            if (method.isAnnotationPresent(ajcDeclareEoW.class)) {
                ajcDeclareEoW deowAnn = ((Method)method).getAnnotation(ajcDeclareEoW.class);
                DeclareErrorOrWarningImpl deow = new DeclareErrorOrWarningImpl(deowAnn.pointcut(), deowAnn.message(), deowAnn.isError(), this);
                deows.add(deow);
            }
            ++n2;
        }
        DeclareErrorOrWarning[] ret = new DeclareErrorOrWarning[deows.size()];
        deows.toArray(ret);
        return ret;
    }

    @Override
    public org.aspectj.lang.reflect.DeclareParents[] getDeclareParents() {
        ArrayList<org.aspectj.lang.reflect.DeclareParents> decps = new ArrayList<org.aspectj.lang.reflect.DeclareParents>();
        Method[] methodArray = this.clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(ajcDeclareParents.class)) {
                ajcDeclareParents decPAnn = method.getAnnotation(ajcDeclareParents.class);
                DeclareParentsImpl decp = new DeclareParentsImpl(decPAnn.targetTypePattern(), decPAnn.parentTypes(), decPAnn.isExtends(), this);
                decps.add(decp);
            }
            ++n2;
        }
        this.addAnnotationStyleDeclareParents(decps);
        if (this.getSupertype().isAspect()) {
            decps.addAll(Arrays.asList(this.getSupertype().getDeclareParents()));
        }
        org.aspectj.lang.reflect.DeclareParents[] ret = new org.aspectj.lang.reflect.DeclareParents[decps.size()];
        decps.toArray(ret);
        return ret;
    }

    private void addAnnotationStyleDeclareParents(List<org.aspectj.lang.reflect.DeclareParents> toList) {
        Field[] fieldArray = this.clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.isAnnotationPresent(DeclareParents.class) && f.getType().isInterface()) {
                DeclareParents ann = f.getAnnotation(DeclareParents.class);
                String parentType = f.getType().getName();
                DeclareParentsImpl decp = new DeclareParentsImpl(ann.value(), parentType, false, this);
                toList.add(decp);
            }
            ++n2;
        }
    }

    @Override
    public DeclareSoft[] getDeclareSofts() {
        ArrayList<DeclareSoft> decs = new ArrayList<DeclareSoft>();
        Method[] methodArray = this.clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(ajcDeclareSoft.class)) {
                ajcDeclareSoft decSAnn = method.getAnnotation(ajcDeclareSoft.class);
                DeclareSoftImpl ds = new DeclareSoftImpl(this, decSAnn.pointcut(), decSAnn.exceptionType());
                decs.add(ds);
            }
            ++n2;
        }
        if (this.getSupertype().isAspect()) {
            decs.addAll(Arrays.asList(this.getSupertype().getDeclareSofts()));
        }
        DeclareSoft[] ret = new DeclareSoft[decs.size()];
        decs.toArray(ret);
        return ret;
    }

    @Override
    public DeclareAnnotation[] getDeclareAnnotations() {
        ArrayList<DeclareAnnotation> decAs = new ArrayList<DeclareAnnotation>();
        Method[] methodArray = this.clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(ajcDeclareAnnotation.class)) {
                Annotation[] anns;
                ajcDeclareAnnotation decAnn = method.getAnnotation(ajcDeclareAnnotation.class);
                Annotation targetAnnotation = null;
                Annotation[] annotationArray = anns = method.getAnnotations();
                int n3 = anns.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation ann = annotationArray[n4];
                    if (ann.annotationType() != ajcDeclareAnnotation.class) {
                        targetAnnotation = ann;
                        break;
                    }
                    ++n4;
                }
                DeclareAnnotationImpl da = new DeclareAnnotationImpl(this, decAnn.kind(), decAnn.pattern(), targetAnnotation, decAnn.annotation());
                decAs.add(da);
            }
            ++n2;
        }
        if (this.getSupertype().isAspect()) {
            decAs.addAll(Arrays.asList(this.getSupertype().getDeclareAnnotations()));
        }
        DeclareAnnotation[] ret = new DeclareAnnotation[decAs.size()];
        decAs.toArray(ret);
        return ret;
    }

    @Override
    public DeclarePrecedence[] getDeclarePrecedence() {
        ArrayList<DeclarePrecedence> decps = new ArrayList<DeclarePrecedence>();
        if (this.clazz.isAnnotationPresent(org.aspectj.lang.annotation.DeclarePrecedence.class)) {
            org.aspectj.lang.annotation.DeclarePrecedence ann = this.clazz.getAnnotation(org.aspectj.lang.annotation.DeclarePrecedence.class);
            DeclarePrecedenceImpl decp = new DeclarePrecedenceImpl(ann.value(), this);
            decps.add(decp);
        }
        Method[] methodArray = this.clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(ajcDeclarePrecedence.class)) {
                ajcDeclarePrecedence decPAnn = method.getAnnotation(ajcDeclarePrecedence.class);
                DeclarePrecedenceImpl decp = new DeclarePrecedenceImpl(decPAnn.value(), this);
                decps.add(decp);
            }
            ++n2;
        }
        if (this.getSupertype().isAspect()) {
            decps.addAll(Arrays.asList(this.getSupertype().getDeclarePrecedence()));
        }
        DeclarePrecedence[] ret = new DeclarePrecedence[decps.size()];
        decps.toArray(ret);
        return ret;
    }

    @Override
    public T[] getEnumConstants() {
        return this.clazz.getEnumConstants();
    }

    @Override
    public TypeVariable<Class<T>>[] getTypeParameters() {
        return this.clazz.getTypeParameters();
    }

    @Override
    public boolean isEnum() {
        return this.clazz.isEnum();
    }

    @Override
    public boolean isInstance(Object o) {
        return this.clazz.isInstance(o);
    }

    @Override
    public boolean isInterface() {
        return this.clazz.isInterface();
    }

    @Override
    public boolean isLocalClass() {
        return this.clazz.isLocalClass() && !this.isAspect();
    }

    @Override
    public boolean isMemberClass() {
        return this.clazz.isMemberClass() && !this.isAspect();
    }

    @Override
    public boolean isArray() {
        return this.clazz.isArray();
    }

    @Override
    public boolean isPrimitive() {
        return this.clazz.isPrimitive();
    }

    @Override
    public boolean isAspect() {
        return this.clazz.getAnnotation(Aspect.class) != null;
    }

    @Override
    public boolean isMemberAspect() {
        return this.clazz.isMemberClass() && this.isAspect();
    }

    @Override
    public boolean isPrivileged() {
        return this.isAspect() && this.clazz.isAnnotationPresent(ajcPrivileged.class);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AjTypeImpl)) {
            return false;
        }
        AjTypeImpl other = (AjTypeImpl)obj;
        return other.clazz.equals(this.clazz);
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    private AjType<?>[] toAjTypeArray(Class<?>[] classes) {
        AjType[] ajtypes = new AjType[classes.length];
        int i = 0;
        while (i < ajtypes.length) {
            ajtypes[i] = AjTypeSystem.getAjType(classes[i]);
            ++i;
        }
        return ajtypes;
    }

    private Class<?>[] toClassArray(AjType<?>[] ajTypes) {
        Class[] classes = new Class[ajTypes.length];
        int i = 0;
        while (i < classes.length) {
            classes[i] = ajTypes[i].getJavaClass();
            ++i;
        }
        return classes;
    }

    public String toString() {
        return this.getName();
    }
}

