/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.debug.model;

import fr.inria.aoste.timesquare.launcher.core.OutputManager;
import fr.inria.aoste.timesquare.launcher.core.PESolverManager;
import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import fr.inria.aoste.timesquare.launcher.core.errorhandler.ErrorHandler;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolver;
import fr.inria.aoste.timesquare.launcher.core.inter.ISolverForBackend;
import fr.inria.aoste.timesquare.launcher.debug.model.AbortException;
import fr.inria.aoste.timesquare.launcher.debug.model.CCSLProcess;
import fr.inria.aoste.timesquare.launcher.debug.model.ISimulationInterface;
import fr.inria.aoste.timesquare.launcher.debug.model.StateEngine;
import fr.inria.aoste.timesquare.launcher.debug.model.output.OutputTraceList;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.CCSLSimulationConfigurationHelper;
import fr.inria.aoste.timesquare.launcher.debug.model.proxy.InitOutputData;
import fr.inria.aoste.timesquare.launcher.extensionpoint.IOutputOption;
import fr.inria.aoste.timesquare.launcher.extensionpoint.IOutputTrace;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyManager;
import fr.inria.aoste.timesquare.trace.util.HelperFactory;
import fr.inria.aoste.timesquare.trace.util.HelperPhysicalBase;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.timesquare.utils.pluginhelpers.PluginHelpers;
import fr.inria.aoste.timesquare.utils.timedsystem.TimedSystem;
import fr.inria.aoste.trace.AssertionState;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.PhysicalBase;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.Trace;
import fr.inria.aoste.trace.TraceFactory;
import fr.inria.aoste.trace.relation.IOutputTraceList;
import fr.inria.aoste.trace.relation.IRelation;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;

public class MySimulationEngine
implements ISimulationInterface {
    private static PESolverManager peSolverManager;
    private ErrorHandler errorHandler = new ErrorHandler(){};
    private Trace aCCSL_Trace;
    private boolean showtime = false;
    private CCSLSimulationConfigurationHelper ccslHelper = null;
    private HashMap<EObject, PhysicalBase> clkdiscretize = new HashMap();
    private List<ModelElementReference> clocklist = null;
    private ISolver commonSolver;
    private ConsoleSimulation cs = null;
    private boolean finish = false;
    private IPath local = null;
    private IPath local2 = null;
    private int maxStep;
    private String namefile = null;
    private LogicalStep oldstep;
    private OutputTraceList outputlist = null;
    private int pos = 0;
    private IRelation relationModelSolver;
    private Resource resource;
    private ThreadSolveCCSLModel runsolve = null;
    private StateEngine stateEngine = StateEngine.init;
    private LogicalStep step;
    private LogicalStep stepview;
    private volatile boolean stopstep = false;
    private Throwable unthrow = null;
    private int viewStep = 0;
    private ResourceSet resourceSet = null;
    private List<PhysicalBase> lstdst = null;
    private HashMap<Resource, URI> hrs = new HashMap();
    private ArrayList<HelperPhysicalBase> listPhysicalBases = new ArrayList();
    private boolean valide = false;
    protected Throwable throwablerelation = null;

    static {
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)new CCSLProcessLaunchListener());
        peSolverManager = PESolverManager.getDefault();
    }

    public MySimulationEngine(CCSLSimulationConfigurationHelper _ccslHelper) {
        this.ccslHelper = _ccslHelper;
        this.maxStep = this.ccslHelper.getStepNbr();
        this.cs = this.ccslHelper.getConsole();
        this.showtime = this.ccslHelper.getTime();
        if (this.maxStep <= 0) {
            this.maxStep = peSolverManager.getDefaultStep(this.ccslHelper);
        }
    }

    @Override
    public Trace getTrace() {
        return this.aCCSL_Trace;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public int getCurrentStepIndice() {
        return this.pos;
    }

    @Override
    public String getSourceFile() throws CoreException {
        return this.ccslHelper.getSource();
    }

    public String getPrioritySourceFile() throws CoreException {
        return this.ccslHelper.getPrioritySource();
    }

    @Override
    public StateEngine getStateEngine() {
        return this.stateEngine;
    }

    @Override
    public LogicalStep getStep() {
        return this.step;
    }

    @Override
    public LogicalStep getStepview() {
        return this.stepview;
    }

    @Override
    public int getViewStepIndice() {
        return this.viewStep;
    }

    public void failedInit() throws CoreException {
        Throwable t = peSolverManager.getThrowable();
        if (t == null) {
            t = this.unthrow;
        }
        this.stateEngine = StateEngine.errorInitModel;
        IStatus status = this.errorHandler.createStatusError("Error init " + this.ccslHelper.getSource(), t, true);
        try {
            this.errorHandler.notifyError("Error init :" + this.ccslHelper.getSource(), "Exception  :" + t, status);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        throw new CoreException(status);
    }

    public boolean isAbortException(Throwable th) {
        block3: {
            block4: {
                if (th == null) break block3;
                if (!(th instanceof AbortException)) break block4;
                return true;
            }
            try {
                return this.isAbortException(th.getCause());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isTerminated() {
        return this.stateEngine.isTerminate() || this.finish;
    }

    @Override
    public void stopstep() {
        this.stopstep = true;
    }

    @Override
    public int viewStep(int n) {
        try {
            this.viewStep = n;
            if (this.stateEngine == StateEngine.terminate) {
                this.stateEngine = StateEngine.ter_back;
            }
            ThreadSelectViewStepPapyrus t = new ThreadSelectViewStepPapyrus();
            t.start();
            t.join();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return 0;
    }

    @Override
    public void init() throws CoreException {
        peSolverManager.clearCache(1);
        if (this.cs == null) {
            this.cs = this.ccslHelper.getConsole();
        }
        this.cs.printSimulationMessageln("Initialisation....");
        this.valide = false;
        try {
            this._init_Validation();
            this._init_Relationmodel();
            this._init_Workspace();
            this._init_Model();
            if (this.commonSolver == null) {
                this.failedInit();
            }
            this._init_Trace();
            this._init_Policy();
            this._init_Discretize();
            this._init_Output();
        }
        catch (Throwable t) {
            throw this._init_Throwable2CoreException(t);
        }
        this.stateEngine = StateEngine.pause;
    }

    private CoreException _init_Throwable2CoreException(Throwable t) throws CoreException {
        t.printStackTrace();
        if (this.commonSolver != null) {
            this.commonSolver.endSimulation();
        }
        IStatus status = null;
        status = this.valide ? this.errorHandler.createStatusError("Error init ( Validation Phase )", t.getCause(), true) : this.errorHandler.createStatusError("Error init ", t, true);
        if (!this.stateEngine.isError()) {
            this.stateEngine = StateEngine.errorInitModel;
        }
        try {
            this.errorHandler.notifyError("Error init", t.getMessage(), status);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new CoreException(status);
    }

    private void _init_Validation() throws Exception {
        this.cs.printSimulationMessageln("Validation Model....");
        boolean b = peSolverManager.validate(this.ccslHelper);
        if (!b) {
            this.cs.printErrMessageln("Failed !!");
            Throwable th = peSolverManager.getThrowable();
            this.valide = true;
            this.cs.printErrMessageln(th.getMessage());
            throw new Exception(" Error In validation phase  ", th);
        }
    }

    private void _init_Relationmodel() {
        this.relationModelSolver = this.ccslHelper.getRelation();
        if (this.relationModelSolver != null) {
            this.relationModelSolver.setIOutputTraceList((IOutputTraceList)this.outputlist);
            this.cs.printSimulationMessageln("Relation model is created");
        } else {
            this.cs.printErrMessageln("Erreur Relation Model (Not Found)");
        }
    }

    private void _init_Workspace() throws Exception {
        IFile ccslFile = this.ccslHelper.get_SourceIFile();
        IPath folder = ccslFile.getParent().getLocation();
        IPath tmp = PluginHelpers.createdir((IPath)folder, (String)"trace");
        String foldername = "Simulation" + this.ccslHelper.getDatestr();
        this.local = PluginHelpers.createdir((IPath)tmp, (String)foldername);
        ccslFile.getParent().refreshLocal(2, null);
        this.local2 = ((IContainer)ccslFile.getParent().findMember("trace")).findMember(foldername).getFullPath();
        this.namefile = this.ccslHelper.get_NameFile(true);
    }

    private void _init_Policy() {
        this.cs.printSimulationMessage("Policy  : ");
        int n = this.ccslHelper.getPolicyId();
        if (n < 0) {
            throw new RuntimeException("Unknown Simulation Policy :\n");
        }
        this.cs.printStdMessageln(SimulationPolicyManager.getDefault().getName(n));
    }

    private void _init_Discretize() {
        System.out.print("Discretize Checking:\n");
        this.cs.printSimulationMessageln("Discretize Checking:");
        int n = 0;
        for (ModelElementReference mer : this.clocklist) {
            String name = AdapterRegistry.getAdapter((EObject)mer).getReferenceName((EObject)mer);
            EObject eo = HelperFactory.getLastReference((ModelElementReference)mer);
            boolean b = AdapterRegistry.getAdapter((EObject)eo).isDiscrete(eo);
            if (!b) continue;
            this.cs.printStdMessageln(String.valueOf(name) + " is  discretize  ");
            HashMap map = AdapterRegistry.getDiscrete((ModelElementReference)mer);
            PhysicalBase pb = HelperFactory.createPhysicalBase((EObject)mer);
            this.aCCSL_Trace.getPhysicalBases().add((Object)pb);
            this.listPhysicalBases.add(new HelperPhysicalBase(pb));
            this.clkdiscretize.put((EObject)mer, pb);
            for (Map.Entry e : map.entrySet()) {
                this.cs.printStdMessageln("\t\t" + AdapterRegistry.getAdapter((EObject)((EObject)e.getKey())).getReferenceName((EObject)e.getKey()) + " / " + AdapterRegistry.getAdapter((EObject)((EObject)e.getValue())).getReferenceName((EObject)e.getValue()));
            }
            ++n;
        }
        if (n == 0) {
            this.cs.printStdMessageln("\t\t0 discretized clock found  ");
        }
        this.lstdst = Collections.unmodifiableList(this.aCCSL_Trace.getPhysicalBases());
        this.cs.printSimulationMessageln("Discretize Checking End:");
    }

    private void _init_Model() throws Exception {
        this.cs.printSimulationMessageln("Solver....");
        ThreadInitCCSLModel d = null;
        this.commonSolver = null;
        d = new ThreadInitCCSLModel();
        d.start();
        d.join();
        this.unthrow = d.getException();
    }

    private void _init_Output() throws Throwable {
        this.outputlist.setCs(this.cs);
        OutputManager outputManager = OutputManager.getDefault();
        for (String key : outputManager.getListkey()) {
            IOutputOption ioo = this.ccslHelper.getTable(key);
            if (ioo == null) continue;
            if (ioo.isActivable() && ioo.isActive()) {
                String errorMessage = ioo.validate();
                if (errorMessage == null) {
                    this.cs.printSimulationMessageln(String.valueOf(ioo.getName()) + " :  active ");
                    IOutputTrace iot = outputManager.getTraceforKey(key);
                    if (iot == null) continue;
                    iot.setOption(ioo);
                    this.outputlist.add(iot);
                    continue;
                }
                this.cs.printErrMessageln(String.valueOf(ioo.getName()) + " : bad configuration ( deactive ) :" + errorMessage);
                continue;
            }
            this.cs.printSimulationMessageln(String.valueOf(ioo.getName()) + " :  inactive ");
        }
        this.outputlist.init(new InitOutputData(this.local, this.namefile, true, this.lstdst));
    }

    private void _init_Trace() {
        this.aCCSL_Trace = TraceFactory.eINSTANCE.createTrace();
        this.aCCSL_Trace.setName(this.namefile);
        this.commonSolver.setListReference((List<Reference>)this.aCCSL_Trace.getReferences());
        this.cs.printSimulationMessageln("Trace....");
        String nametrace = this.local2.append(String.valueOf(this.namefile) + ".trace").toOSString();
        this.resourceSet = this.commonSolver.getResourceSet();
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
        }
        ArrayList<Resource> lr = new ArrayList<Resource>();
        if (this.ccslHelper.getCopy()) {
            for (Resource r : this.resourceSet.getResources()) {
                URI uri = r.getURI();
                if (!uri.isPlatformResource()) continue;
                lr.add(0, r);
                List s = uri.segmentsList();
                String tmpfile = this.local2.append((String)s.get(s.size() - 1)).toOSString();
                URI tmpuri = URI.createPlatformResourceURI((String)tmpfile, (boolean)false);
                r.setURI(tmpuri);
                this.hrs.put(r, tmpuri);
                r.setModified(true);
                r.setTrackingModification(true);
            }
        }
        XMLResourceFactoryImpl xmiresource = new XMLResourceFactoryImpl();
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", xmiresource);
        URI fileURI = URI.createPlatformResourceURI((String)nametrace, (boolean)false);
        this.resource = this.resourceSet.createResource(fileURI);
        this.resource.setTrackingModification(true);
        this.resource.getContents().add((Object)this.aCCSL_Trace);
        try {
            this.resource.save(PluginHelpers.getEcoreSaveOption());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        for (Resource r : lr) {
            try {
                r.save(PluginHelpers.getEcoreSaveOption());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        try {
            this.ccslHelper.get_SourceIFile().getParent().refreshLocal(1, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void step(boolean timed) throws Exception {
        this._oneStep(timed);
        this.updateStatus();
        System.out.flush();
    }

    @Override
    public void step(int nb) throws Exception {
        this.stopstep = false;
        int i = 0;
        while (i < nb && this.viewStep + 1 < this.maxStep) {
            if (this.stopstep || this.stateEngine.isTerminate()) break;
            this._oneStep(true);
            ++i;
        }
        this.stopstep = false;
        this.updateStatus();
        System.out.flush();
    }

    @Override
    public void steprun() throws Exception {
        this.stopstep = false;
        while (!this.stopstep && !this.stateEngine.isTerminate()) {
            this._oneStep(true);
        }
        this.stopstep = false;
        this.updateStatus();
        System.out.flush();
    }

    protected void _oneStep(boolean timed) throws Exception {
        this._oneStep_StateEngineIn();
        if (this.pos != 0 && this.pos > this.viewStep + 1) {
            this._oneStep_Replay();
            return;
        }
        Throwable th = null;
        try {
            this.viewStep = this.pos;
            if (this.commonSolver != null) {
                this.cs.printStepSimulation(this.pos);
                if (this.stopstep) {
                    return;
                }
                this.runsolve = new ThreadSolveCCSLModel();
                this.runsolve.start();
                this.runsolve.join();
                th = this.runsolve.getException();
                if (th == null) {
                    th = this.runsolve.getKillexception();
                }
                this.runsolve = null;
            }
            if (this.isAbortException(th)) {
                this.stateEngine = StateEngine.terminate;
                return;
            }
        }
        catch (Throwable e) {
            th = e;
        }
        if (this.step == null) {
            this._oneStep_registryError(th);
            return;
        }
        this._oneStep_updateTrace();
        try {
            this.throwablerelation = null;
            this._oneStep_step(timed);
            if (this.throwablerelation != null) {
                this.errorHandler.createStatusError(this.throwablerelation.getMessage(), this.throwablerelation, true);
                throw this.throwablerelation;
            }
        }
        catch (Throwable e) {
            this._oneStep_registryError(e);
            return;
        }
        this.stepview = this.step;
        ++this.pos;
        if (this.pos >= this.maxStep) {
            this.stateEngine = StateEngine.terminate;
        }
    }

    private void _oneStep_step(boolean timed) {
        try {
            if (this.relationModelSolver != null) {
                this.relationModelSolver.resolve(this.step);
            }
        }
        catch (Throwable e) {
            this.cs.printErrMessage("****************\nErreur Relation Model\n*****************\n");
            this.throwablerelation = e;
        }
        this.outputlist.aNewStep(this.step, timed);
        this.outputlist.clearRelation();
    }

    private void _oneStep_updateTrace() {
        this.aCCSL_Trace.getLogicalSteps().add((Object)this.step);
        for (HelperPhysicalBase pb : this.listPhysicalBases) {
            pb.createPhysicalSteps(this.step);
        }
        if (this.oldstep != null) {
            this.oldstep.setNextStep(this.step);
        }
        this.step.setPreviousStep(this.oldstep);
        this.oldstep = this.step;
        this.stepview = this.step;
    }

    private void _oneStep_StateEngineIn() {
        this.stateEngine = this.stateEngine == StateEngine.ter_back ? StateEngine.ter_replay : StateEngine.run;
    }

    private void _oneStep_Replay() {
        this.cs.printStep(this.viewStep, true);
        this.viewStep(this.viewStep + 1);
        if (this.stateEngine == StateEngine.ter_replay) {
            this.stateEngine = this.pos == this.viewStep + 1 ? StateEngine.terminate : StateEngine.ter_back;
        }
    }

    private void _oneStep_registryError(Throwable th) throws Exception {
        if (th == null) {
            th = new Exception("Unknow Error : Error not specified (step" + this.pos + ")");
        } else {
            th.printStackTrace();
        }
        IStatus status = this.errorHandler.createStatusError(th.getMessage(), th, true);
        this.stateEngine = StateEngine.error;
        String message = "in step " + this.pos + " : \n" + th.getMessage();
        ++this.pos;
        this.errorHandler.notifyError("Error during simulation", message, status);
    }

    private void updateStatus() {
        if (this.stateEngine == StateEngine.run) {
            this.stateEngine = this.pos == this.maxStep ? StateEngine.terminate : StateEngine.pause;
        }
    }

    @Override
    public void finish() {
        this.stopstep = true;
        if (this.finish) {
            return;
        }
        this.finish = true;
        try {
            if (this.runsolve != null) {
                try {
                    this.runsolve.setKillexception(new AbortException());
                    this.runsolve.interrupt();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (this.commonSolver != null) {
                this.commonSolver.endSimulation();
            }
            System.out.println();
            this.writeTrace();
            try {
                this.ccslHelper.get_SourceIFile().getProject().refreshLocal(2, null);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                if (this.relationModelSolver != null) {
                    this.relationModelSolver.saveRelationModel(this.resourceSet, this.local2, this.namefile);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            this.outputlist.aFinalStep(this.pos);
            this.cs.printSimulationMessageln("<<Simulation: finish>>");
            if (this.relationModelSolver != null) {
                this.relationModelSolver.unload();
            }
        }
        catch (Throwable t) {
            System.out.println(t);
            t.printStackTrace();
        }
        System.out.println("\nNormal ending");
    }

    @Override
    public void disconnect() {
        this.finish();
        this.outputlist = null;
        this.relationModelSolver = null;
        this.ccslHelper = null;
    }

    private void writeTrace() throws Exception {
        if (this.resource != null) {
            try {
                this.resource.save(PluginHelpers.getEcoreSaveOption());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static final class CCSLProcessLaunchListener
    implements ILaunchListener {
        public void launchRemoved(ILaunch launch) {
            if (launch.getProcesses() != null) {
                IProcess[] iProcessArray = launch.getProcesses();
                int n = iProcessArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProcess process = iProcessArray[n2];
                    if (process instanceof CCSLProcess) {
                        try {
                            if (((IDisconnect)process).canDisconnect()) {
                                ((IDisconnect)process).disconnect();
                            }
                        }
                        catch (DebugException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n2;
                }
            }
            System.gc();
        }

        public void launchChanged(ILaunch launch) {
        }

        public void launchAdded(ILaunch launch) {
        }
    }

    private class ThreadInitCCSLModel
    extends Thread {
        Throwable t;

        public ThreadInitCCSLModel() {
            super("Init Model for Simulator");
            this.t = null;
        }

        public final Throwable getException() {
            return this.t;
        }

        @Override
        public void run() {
            try {
                peSolverManager.clearCache(0);
                MySimulationEngine.this.commonSolver = MySimulationEngine.this.ccslHelper.getSolver();
                MySimulationEngine.this.outputlist = new OutputTraceList((ISolverForBackend)((Object)MySimulationEngine.this.commonSolver));
                if (MySimulationEngine.this.commonSolver == null) {
                    this.t = peSolverManager.getThrowable();
                } else {
                    MySimulationEngine.this.commonSolver.start();
                    MySimulationEngine.this.clocklist = MySimulationEngine.this.commonSolver.getClockList();
                }
            }
            catch (Throwable e) {
                this.t = e;
                System.err.println("test");
                e.printStackTrace();
                MySimulationEngine.this.commonSolver = null;
            }
        }
    }

    private class ThreadSelectViewStepPapyrus
    extends Thread {
        ThreadSelectViewStepPapyrus() {
            super("Viev Old Step");
        }

        @Override
        public void run() {
            super.run();
            if (MySimulationEngine.this.viewStep >= MySimulationEngine.this.aCCSL_Trace.getLogicalSteps().size()) {
                return;
            }
            LogicalStep step = (LogicalStep)MySimulationEngine.this.aCCSL_Trace.getLogicalSteps().get(MySimulationEngine.this.viewStep);
            MySimulationEngine.this.stepview = step;
            if (MySimulationEngine.this.outputlist != null) {
                MySimulationEngine.this.outputlist.killTimer();
                MySimulationEngine.this.outputlist.aStep(step, false);
            }
        }
    }

    private class ThreadSolveCCSLModel
    extends Thread {
        private Throwable exception;
        private Throwable killexception;

        public ThreadSolveCCSLModel() {
            super("Solve  CCSLModel [step  " + MySimulationEngine.this.pos + " ] ");
            this.exception = null;
            this.killexception = null;
            this.setDaemon(true);
            this.setPriority(10);
        }

        public final Throwable getException() {
            return this.exception;
        }

        @Override
        public void run() {
            if (MySimulationEngine.this.finish) {
                return;
            }
            MySimulationEngine.this.step = null;
            try {
                try {
                    final TimedSystem ts = new TimedSystem();
                    MySimulationEngine.this.step = AccessController.doPrivileged(new PrivilegedExceptionAction<LogicalStep>(){

                        @Override
                        public LogicalStep run() throws Exception {
                            return MySimulationEngine.this.commonSolver.solveNextSimulationStep(ts);
                        }
                    });
                    if (MySimulationEngine.this.commonSolver.getException() != null) {
                        throw MySimulationEngine.this.commonSolver.getException();
                    }
                    if (MySimulationEngine.this.step == null) {
                        throw new NullPointerException("You experienced a deadlock in your specification...");
                    }
                    MySimulationEngine.this.step.setStepNumber(MySimulationEngine.this.pos);
                    for (AssertionState as : MySimulationEngine.this.step.getAssertionStates()) {
                        if (!as.isIsViolated()) continue;
                        String feedback = "violation of :";
                        for (EObject eo : ((ModelElementReference)as.getReferedElement()).getElementRef()) {
                            EClass ec = eo.eClass();
                            EStructuralFeature nameFeature = null;
                            nameFeature = ec.getEStructuralFeature("name");
                            Object name = null;
                            if (nameFeature == null || !((name = eo.eGet(nameFeature)) instanceof String)) continue;
                            feedback = String.valueOf(feedback) + name.toString() + "::";
                        }
                        MySimulationEngine.this.cs.printErrMessageln(feedback);
                    }
                    ts.finish();
                    if (MySimulationEngine.this.showtime) {
                        MySimulationEngine.this.cs.printSimulationMessageln("Timing :");
                        MySimulationEngine.this.cs.printStdMessageln(ts.toStringEvent());
                    }
                }
                catch (Throwable e) {
                    System.err.println("Exception step :" + e);
                    this.exception = e;
                    MySimulationEngine.this.step = null;
                    MySimulationEngine.this.commonSolver.endSimulationStep();
                    return;
                }
            }
            finally {
                MySimulationEngine.this.commonSolver.endSimulationStep();
            }
            if (MySimulationEngine.this.step == null) {
                this.exception = MySimulationEngine.this.commonSolver.getException();
            }
        }

        protected final Throwable getKillexception() {
            return this.killexception;
        }

        protected final void setKillexception(Throwable killexception) {
            this.killexception = killexception;
        }
    }
}

