/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.launcher.core.console;

import fr.inria.aoste.timesquare.launcher.core.console.ConsoleSimulation;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleView;

public class ConsoleRemoveLaunchAction
extends Action
implements IViewActionDelegate,
IConsoleListener,
ILaunchesListener2 {
    private ILaunch fLaunch;
    private IConsoleView fConsoleView;

    public ConsoleRemoveLaunchAction() {
        super("&Remove Launch");
        this.setToolTipText("Remove Launch");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.console_remove_launch_context");
        this.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_LCL_REMOVE"));
        this.setDisabledImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_DLCL_REMOVE"));
        this.setHoverImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_ELCL_REMOVE"));
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this);
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener((IConsoleListener)this);
    }

    public ConsoleRemoveLaunchAction(ILaunch launch) {
        this();
        this.fLaunch = launch;
        this.update();
    }

    public void dispose() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this);
        ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
    }

    public synchronized void update() {
        ILaunch launch = this.getLaunch();
        if (launch != null) {
            this.setEnabled(launch.isTerminated());
        } else {
            this.setEnabled(false);
        }
    }

    public synchronized void run() {
        ILaunch launch = this.getLaunch();
        if (launch != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(launch);
        }
    }

    public void init(IViewPart view) {
        if (view instanceof IConsoleView) {
            this.fConsoleView = (IConsoleView)view;
        }
        this.update();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void consolesAdded(IConsole[] consoles) {
    }

    public void consolesRemoved(IConsole[] consoles) {
        this.update();
    }

    public void launchesTerminated(ILaunch[] launches) {
        this.update();
    }

    public void launchesRemoved(ILaunch[] launches) {
    }

    public void launchesAdded(ILaunch[] launches) {
    }

    public void launchesChanged(ILaunch[] launches) {
    }

    protected ILaunch getLaunch() {
        if (this.fConsoleView == null) {
            return this.fLaunch;
        }
        IConsole console = this.fConsoleView.getConsole();
        if (console instanceof ConsoleSimulation) {
            ConsoleSimulation pconsole = (ConsoleSimulation)console;
            return pconsole.getiProcess().getLaunch();
        }
        return null;
    }
}

