/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.util;

import de.cau.cs.kieler.core.kgraph.KEdge;
import de.cau.cs.kieler.core.kgraph.KGraphData;
import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KGraphFactory;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.core.kgraph.PersistentEntry;
import de.cau.cs.kieler.core.math.KVector;
import de.cau.cs.kieler.core.properties.IProperty;
import de.cau.cs.kieler.core.properties.Property;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.klayoutdata.KEdgeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.KIdentifier;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KLayoutDataFactory;
import de.cau.cs.kieler.kiml.klayoutdata.KPoint;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.options.PortConstraints;
import de.cau.cs.kieler.kiml.options.PortSide;
import de.cau.cs.kieler.kiml.options.SizeConstraint;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public final class KimlUtil {
    private static final float MIN_NODE_SIZE = 20.0f;

    private KimlUtil() {
    }

    public static KNode createInitializedNode() {
        KNode layoutNode = KGraphFactory.eINSTANCE.createKNode();
        KShapeLayout layout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        layout.setInsets(KLayoutDataFactory.eINSTANCE.createKInsets());
        layoutNode.getData().add((Object)layout);
        return layoutNode;
    }

    public static KEdge createInitializedEdge() {
        KEdge edge = KGraphFactory.eINSTANCE.createKEdge();
        KEdgeLayout edgeLayout = KLayoutDataFactory.eINSTANCE.createKEdgeLayout();
        edgeLayout.setSourcePoint(KLayoutDataFactory.eINSTANCE.createKPoint());
        edgeLayout.setTargetPoint(KLayoutDataFactory.eINSTANCE.createKPoint());
        edge.getData().add((Object)edgeLayout);
        return edge;
    }

    public static KPort createInitializedPort() {
        KPort port = KGraphFactory.eINSTANCE.createKPort();
        KShapeLayout labelLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        port.getData().add((Object)labelLayout);
        return port;
    }

    public static KLabel createInitializedLabel(KLabeledGraphElement element) {
        KLabel label = KGraphFactory.eINSTANCE.createKLabel();
        KShapeLayout labelLayout = KLayoutDataFactory.eINSTANCE.createKShapeLayout();
        label.getData().add((Object)labelLayout);
        label.setText("");
        label.setParent(element);
        return label;
    }

    public static void createIdentifier(KGraphElement element) {
        KIdentifier identifier = (KIdentifier)element.getData(KIdentifier.class);
        if (identifier == null) {
            identifier = KLayoutDataFactory.eINSTANCE.createKIdentifier();
            element.getData().add((Object)identifier);
        }
        identifier.setId(Integer.toString(element.hashCode()));
    }

    public static PortSide calcPortSide(KPort port, Direction direction) {
        KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        KShapeLayout nodeLayout = (KShapeLayout)port.getNode().getData(KShapeLayout.class);
        float nodeWidth = nodeLayout.getWidth();
        float nodeHeight = nodeLayout.getHeight();
        if (nodeWidth <= 0.0f && nodeHeight <= 0.0f) {
            return PortSide.UNDEFINED;
        }
        float xpos = portLayout.getXpos();
        float ypos = portLayout.getYpos();
        switch (direction) {
            case RIGHT: 
            case LEFT: {
                if (xpos < 0.0f) {
                    return PortSide.WEST;
                }
                if (!(xpos + portLayout.getWidth() > nodeWidth)) break;
                return PortSide.EAST;
            }
            case DOWN: 
            case UP: {
                if (ypos < 0.0f) {
                    return PortSide.NORTH;
                }
                if (!(ypos + portLayout.getHeight() > nodeHeight)) break;
                return PortSide.SOUTH;
            }
        }
        float widthPercent = (xpos + portLayout.getWidth() / 2.0f) / nodeWidth;
        float heightPercent = (ypos + portLayout.getHeight() / 2.0f) / nodeHeight;
        if (widthPercent + heightPercent <= 1.0f && widthPercent - heightPercent <= 0.0f) {
            return PortSide.WEST;
        }
        if (widthPercent + heightPercent >= 1.0f && widthPercent - heightPercent >= 0.0f) {
            return PortSide.EAST;
        }
        if (heightPercent < 0.5f) {
            return PortSide.NORTH;
        }
        return PortSide.SOUTH;
    }

    public static float calcPortOffset(KPort port, PortSide side) {
        KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
        KShapeLayout nodeLayout = (KShapeLayout)port.getNode().getData(KShapeLayout.class);
        switch (side) {
            case NORTH: {
                return -(portLayout.getYpos() + portLayout.getHeight());
            }
            case EAST: {
                return portLayout.getXpos() - nodeLayout.getWidth();
            }
            case SOUTH: {
                return portLayout.getYpos() - nodeLayout.getHeight();
            }
            case WEST: {
                return -(portLayout.getXpos() + portLayout.getWidth());
            }
        }
        return 0.0f;
    }

    public static KVector resizeNode(KNode node) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        SizeConstraint sizeConstraint = (SizeConstraint)((Object)nodeLayout.getProperty(LayoutOptions.SIZE_CONSTRAINT));
        if (sizeConstraint == SizeConstraint.FIXED) {
            return null;
        }
        float newWidth = 0.0f;
        float newHeight = 0.0f;
        if (sizeConstraint.arePortsConsidered()) {
            PortConstraints portConstraints = (PortConstraints)((Object)nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS));
            float minNorth = 2.0f;
            float minEast = 2.0f;
            float minSouth = 2.0f;
            float minWest = 2.0f;
            Direction direction = node.getParent() == null ? (Direction)((Object)nodeLayout.getProperty(LayoutOptions.DIRECTION)) : (Direction)((Object)((KShapeLayout)node.getParent().getData(KShapeLayout.class)).getProperty(LayoutOptions.DIRECTION));
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                PortSide portSide = (PortSide)((Object)portLayout.getProperty(LayoutOptions.PORT_SIDE));
                if (portSide == PortSide.UNDEFINED) {
                    portSide = KimlUtil.calcPortSide(port, direction);
                    portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
                }
                if (portConstraints == PortConstraints.FIXED_POS) {
                    switch (portSide) {
                        case NORTH: {
                            minNorth = Math.max(minNorth, portLayout.getXpos() + portLayout.getWidth());
                            break;
                        }
                        case EAST: {
                            minEast = Math.max(minEast, portLayout.getYpos() + portLayout.getHeight());
                            break;
                        }
                        case SOUTH: {
                            minSouth = Math.max(minSouth, portLayout.getXpos() + portLayout.getWidth());
                            break;
                        }
                        case WEST: {
                            minWest = Math.max(minWest, portLayout.getYpos() + portLayout.getHeight());
                        }
                    }
                    continue;
                }
                switch (portSide) {
                    case NORTH: {
                        minNorth += portLayout.getWidth() + 2.0f;
                        break;
                    }
                    case EAST: {
                        minEast += portLayout.getHeight() + 2.0f;
                        break;
                    }
                    case SOUTH: {
                        minSouth += portLayout.getWidth() + 2.0f;
                        break;
                    }
                    case WEST: {
                        minWest += portLayout.getHeight() + 2.0f;
                    }
                }
            }
            newWidth = Math.max(minNorth, minSouth);
            newHeight = Math.max(minEast, minWest);
        }
        if (sizeConstraint.isDefSizeConsidered()) {
            newWidth = Math.max(newWidth, 20.0f);
            newHeight = Math.max(newHeight, 20.0f);
        }
        return KimlUtil.resizeNode(node, newWidth, newHeight, true);
    }

    public static KVector resizeNode(KNode node, float newWidth, float newHeight, boolean movePorts) {
        KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
        if (((Boolean)nodeLayout.getProperty(LayoutOptions.NO_LAYOUT)).booleanValue()) {
            return null;
        }
        KVector oldSize = new KVector((double)nodeLayout.getWidth(), (double)nodeLayout.getHeight());
        KVector newSize = new KVector((double)Math.max(newWidth, ((Float)nodeLayout.getProperty(LayoutOptions.MIN_WIDTH)).floatValue()), (double)Math.max(newHeight, ((Float)nodeLayout.getProperty(LayoutOptions.MIN_HEIGHT)).floatValue()));
        float widthRatio = (float)(newSize.x / oldSize.x);
        float heightRatio = (float)(newSize.y / oldSize.y);
        float widthDiff = (float)(newSize.x - oldSize.x);
        float heightDiff = (float)(newSize.y - oldSize.y);
        if (movePorts) {
            Direction direction = node.getParent() == null ? (Direction)((Object)nodeLayout.getProperty(LayoutOptions.DIRECTION)) : (Direction)((Object)((KShapeLayout)node.getParent().getData(KShapeLayout.class)).getProperty(LayoutOptions.DIRECTION));
            boolean fixedPorts = nodeLayout.getProperty(LayoutOptions.PORT_CONSTRAINTS) == PortConstraints.FIXED_POS;
            for (KPort port : node.getPorts()) {
                KShapeLayout portLayout = (KShapeLayout)port.getData(KShapeLayout.class);
                PortSide portSide = (PortSide)((Object)portLayout.getProperty(LayoutOptions.PORT_SIDE));
                if (portSide == PortSide.UNDEFINED) {
                    portSide = KimlUtil.calcPortSide(port, direction);
                    portLayout.setProperty(LayoutOptions.PORT_SIDE, (Object)portSide);
                }
                switch (portSide) {
                    case NORTH: {
                        if (fixedPorts) break;
                        portLayout.setXpos(portLayout.getXpos() * widthRatio);
                        break;
                    }
                    case EAST: {
                        portLayout.setXpos(portLayout.getXpos() + widthDiff);
                        if (fixedPorts) break;
                        portLayout.setYpos(portLayout.getYpos() * heightRatio);
                        break;
                    }
                    case SOUTH: {
                        if (!fixedPorts) {
                            portLayout.setXpos(portLayout.getXpos() * widthRatio);
                        }
                        portLayout.setYpos(portLayout.getYpos() + heightDiff);
                        break;
                    }
                    case WEST: {
                        if (fixedPorts) break;
                        portLayout.setYpos(portLayout.getYpos() * heightRatio);
                    }
                }
            }
        }
        nodeLayout.setSize((float)newSize.x, (float)newSize.y);
        for (KLabel label : node.getLabels()) {
            float midy;
            float heightPercent;
            KShapeLayout labelLayout = (KShapeLayout)label.getData(KShapeLayout.class);
            float midx = labelLayout.getXpos() + labelLayout.getWidth() / 2.0f;
            float widthPercent = midx / (float)oldSize.x;
            if (!(widthPercent + (heightPercent = (midy = labelLayout.getYpos() + labelLayout.getHeight() / 2.0f) / (float)oldSize.y) >= 1.0f)) continue;
            if (widthPercent - heightPercent > 0.0f && midy >= 0.0f) {
                labelLayout.setXpos(labelLayout.getXpos() + widthDiff);
                labelLayout.setYpos(labelLayout.getYpos() + heightDiff * heightPercent);
                continue;
            }
            if (!(widthPercent - heightPercent < 0.0f) || !(midx >= 0.0f)) continue;
            labelLayout.setXpos(labelLayout.getXpos() + widthDiff * widthPercent);
            labelLayout.setYpos(labelLayout.getYpos() + heightDiff);
        }
        nodeLayout.setProperty(LayoutOptions.SIZE_CONSTRAINT, (Object)SizeConstraint.FIXED);
        return new KVector((double)widthRatio, (double)heightRatio);
    }

    public static boolean isDescendant(KNode child, KNode parent) {
        KNode current = child;
        while (current.getParent() != null) {
            if ((current = current.getParent()) != parent) continue;
            return true;
        }
        return false;
    }

    public static void toAbsolute(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            point.translate((double)(nodeLayout.getXpos() + insets.getLeft()), (double)(nodeLayout.getYpos() + insets.getTop()));
            node = node.getParent();
        }
    }

    public static void toRelative(KVector point, KNode parent) {
        KNode node = parent;
        while (node != null) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            KInsets insets = nodeLayout.getInsets();
            point.translate((double)(-nodeLayout.getXpos() - insets.getLeft()), (double)(-nodeLayout.getYpos() - insets.getTop()));
            node = node.getParent();
        }
    }

    public static void translate(KNode parent, float xoffset, float yoffset) {
        for (KNode node : parent.getChildren()) {
            KShapeLayout nodeLayout = (KShapeLayout)node.getData(KShapeLayout.class);
            nodeLayout.setXpos(nodeLayout.getXpos() + xoffset);
            nodeLayout.setYpos(nodeLayout.getYpos() + yoffset);
            for (KEdge edge : node.getOutgoingEdges()) {
                KEdgeLayout edgeLayout = (KEdgeLayout)edge.getData(KEdgeLayout.class);
                KimlUtil.translate(edgeLayout.getSourcePoint(), xoffset, yoffset);
                for (KPoint bendPoint : edgeLayout.getBendPoints()) {
                    KimlUtil.translate(bendPoint, xoffset, yoffset);
                }
                KimlUtil.translate(edgeLayout.getTargetPoint(), xoffset, yoffset);
                for (KLabel edgeLabel : edge.getLabels()) {
                    KShapeLayout labelLayout = (KShapeLayout)edgeLabel.getData(KShapeLayout.class);
                    labelLayout.setXpos(labelLayout.getXpos() + xoffset);
                    labelLayout.setYpos(labelLayout.getYpos() + yoffset);
                }
            }
        }
    }

    public static void translate(KPoint point, float xoffset, float yoffset) {
        point.setX(point.getX() + xoffset);
        point.setY(point.getY() + yoffset);
    }

    public static void setOption(KGraphData graphData, String id, String value) {
        Object obj;
        LayoutDataService dataService = LayoutDataService.getInstance();
        LayoutOptionData<?> optionData = dataService.getOptionData(id);
        if (optionData != null && (obj = optionData.parseValue(value)) != null) {
            graphData.setProperty(optionData, obj);
        }
    }

    public static void persistDataElements(KNode graph) {
        TreeIterator iterator = graph.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof KGraphData)) continue;
            ((KGraphData)eObject).makePersistent();
        }
    }

    public static void loadDataElements(KNode graph) {
        LayoutDataService dataService = LayoutDataService.getInstance();
        TreeIterator iterator = graph.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof KGraphData)) continue;
            KGraphData kgraphData = (KGraphData)eObject;
            for (PersistentEntry persistentEntry : kgraphData.getPersistentEntries()) {
                String key = persistentEntry.getKey();
                String value = persistentEntry.getValue();
                if (key == null || value == null) continue;
                LayoutOptionData<?> layoutOptionData = null;
                if (dataService != null) {
                    layoutOptionData = dataService.getOptionData(key);
                }
                if (layoutOptionData != null) {
                    Object layoutOptionValue = layoutOptionData.parseValue(persistentEntry.getValue());
                    if (layoutOptionValue == null) continue;
                    kgraphData.setProperty(layoutOptionData, layoutOptionValue);
                    continue;
                }
                Property property = new Property(key);
                kgraphData.setProperty((IProperty)property, (Object)value);
            }
        }
    }
}

