/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.preferences;

import org.eclipse.etrice.ui.common.base.UIBaseActivator;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ETricePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor snap;
    private StringFieldEditor hor;
    private StringFieldEditor ver;
    private Button useGridCheck;
    private StringFieldEditor maxLineLength;
    private StringFieldEditor maxLines;

    public ETricePreferencePage() {
        super(1);
        this.setPreferenceStore(UIBaseActivator.getDefault().getPreferenceStore());
        this.setDescription("eTrice Preferences");
    }

    public void createFieldEditors() {
        this.addLabel("");
        this.addLabel("Textual Model Editor");
        BooleanFieldEditor autoSaveText = new BooleanFieldEditor("SaveTextOnFocusLost", "Auto-save textual model when focus changes", this.getFieldEditorParent());
        this.addField((FieldEditor)autoSaveText);
        BooleanFieldEditor autoFormatOnSave = new BooleanFieldEditor("AutoFormatOnSave", "Auto-format on save", this.getFieldEditorParent());
        this.addField((FieldEditor)autoFormatOnSave);
        BooleanFieldEditor foldImportsText = new BooleanFieldEditor("AUTO_FOLD_IMPORTS", "Auto-fold imports", this.getFieldEditorParent());
        this.addField((FieldEditor)foldImportsText);
        this.addLabel("");
        this.addLabel("Diagram Editors");
        this.addField((FieldEditor)new BooleanFieldEditor("ConfirmDelete", "&Confirm diagram element deletion", this.getFieldEditorParent()));
        BooleanFieldEditor autoSave = new BooleanFieldEditor("SaveDiagOnFocusLost", "Auto-save diagram when focus changes", this.getFieldEditorParent());
        this.addField((FieldEditor)autoSave);
        this.maxLineLength = new StringFieldEditor("MaxLabelLineLength", "Max Transition Lable Line Length::", this.getFieldEditorParent());
        this.addField((FieldEditor)this.maxLineLength);
        this.maxLines = new StringFieldEditor("MaxLabelLines", "Max Transition Lable Lines::", this.getFieldEditorParent());
        this.addField((FieldEditor)this.maxLines);
        StringFieldEditor exportPath = new StringFieldEditor("ExportDiagramPath", "&Export Diagram Path:", this.getFieldEditorParent());
        this.addField((FieldEditor)exportPath);
        RadioGroupFieldEditor exportRelTo = new RadioGroupFieldEditor("ExportDiagramPathRelativeTo", "Export Path Relative to", 2, (String[][])new String[][]{{"Project", "project"}, {"Model", "model"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)exportRelTo);
        RadioGroupFieldEditor imgFormat = new RadioGroupFieldEditor("ExportDiagramFormat", "Image Format for Export:", 4, (String[][])new String[][]{{"BMP", "bmp"}, {"GIF", "gif"}, {"JPG", "jpg"}, {"PNG", "png"}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)imgFormat);
        BooleanFieldEditor useGrid = new BooleanFieldEditor("UseGrid", "Use &Grid (grid settings apply to new diagrams only)", this.getFieldEditorParent());
        this.addField((FieldEditor)useGrid);
        this.snap = new BooleanFieldEditor("SnapToGrid", "&Snap to Grid", this.getFieldEditorParent());
        this.addField((FieldEditor)this.snap);
        this.hor = new StringFieldEditor("HorGridUnit", "&Horizontal Grid Unit [px]:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.hor);
        this.ver = new StringFieldEditor("VerGridUnit", "&Vertical Grid Unit [px]:", this.getFieldEditorParent());
        this.addField((FieldEditor)this.ver);
        this.useGridCheck = (Button)useGrid.getDescriptionControl(this.getFieldEditorParent());
        this.useGridCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ETricePreferencePage.this.updateGridFields();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ETricePreferencePage.this.updateGridFields();
            }
        });
    }

    protected void initialize() {
        super.initialize();
        this.updateGridFields();
    }

    private void updateGridFields() {
        boolean enabled = this.useGridCheck.getSelection();
        this.snap.setEnabled(enabled, this.getFieldEditorParent());
        this.hor.setEnabled(enabled, this.getFieldEditorParent());
        this.ver.setEnabled(enabled, this.getFieldEditorParent());
    }

    public void init(IWorkbench workbench) {
    }

    private void addLabel(String message) {
        Label label = new Label(this.getFieldEditorParent(), 0);
        GridData data = new GridData(1, 1, true, false, 2, 1);
        label.setLayoutData((Object)data);
        if (message != null) {
            label.setText(message);
        }
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        return ok;
    }
}

