/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.documentation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocumentationMarkup {
    public static final String MARKUP_ASCIIDOC = "asciidoc";
    public static final String MARKUP_COMMONMARK = "commonmark";
    private static final Pattern MARKUP_PATTERN = Pattern.compile("\\A\\s*\\<\\!\\-\\-\\s*(\\w+)\\s*\\-\\-\\>\\s*");

    public static String getMarkupType(String text) {
        String markup;
        Matcher markupMatcher = MARKUP_PATTERN.matcher(text);
        String string = markup = markupMatcher.find() ? markupMatcher.group(1) : null;
        if (markup != null && markup.matches("(?i)adoc|asciidoc|asciidoctor")) {
            return MARKUP_ASCIIDOC;
        }
        return MARKUP_COMMONMARK;
    }

    public static String trimMarkupTag(String text) {
        Matcher markupMatcher = MARKUP_PATTERN.matcher(text);
        return markupMatcher.replaceFirst("");
    }
}

