/*******************************************************************************
 * Copyright (c) 2011 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * CONTRIBUTORS:
 * 		Henrik Rentz-Reichert (initial contribution)
 * 
 *******************************************************************************/

package org.eclipse.etrice.generator.java.gen

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.etrice.core.genmodel.etricegen.Root
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance
import org.eclipse.etrice.core.genmodel.etricegen.SystemInstance
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO
import org.eclipse.etrice.generator.generic.RoomExtensions
import org.eclipse.etrice.core.etmap.util.ETMapUtil

@Singleton
class NodeRunnerGen {

	@Inject extension RoomExtensions roomExt
	@Inject extension JavaExtensions
	
	@Inject IGeneratorFileIO fileIO
	
	def doGenerate(Root root) {
		for (nr : ETMapUtil::getNodeRefs()) {
			for (instpath : ETMapUtil::getSubSystemInstancePaths(nr)) {
				val ssi = root.getInstance(instpath) as SubSystemInstance
				if (ssi!==null) {
					val file = nr.getJavaClassName(ssi)+"Runner.java"
					val filepath = ssi.subSystemClass.getPath
					fileIO.generateFile("generating SubSystemRunner implementation", filepath + file, root.generate(ssi))
				}
			}
		}
	}
	
	def generate(Root root, SubSystemInstance ssc) {
	val cc = ssc.subSystemClass
	val nr = ETMapUtil::getNodeRef(ssc)
	val clsname = nr.getJavaClassName(ssc)
	'''
		/**
		 * @author generated by eTrice
		 *
		 * this class contains the main function running component ssc.name
		 * it instantiates ssc.name and starts and ends the lifecycle
		 */
		
		package cc.getPackage();
		
		import org.eclipse.etrice.runtime.java.modelbase.RTSystem;
		import org.eclipse.etrice.runtime.java.modelbase.SubSystemRunnerBase;
		
		public class clsname+"Runner" extends SubSystemRunnerBase {
		
			/**
		     * main function
		     * creates the main component and starts and stops the lifecycle
		     */
			public static void main(String[] args) {
				// instantiate the main component
				RTSystem sys = IF ssc.eContainer instanceof SystemInstancenew RTSystem("(ssc.eContainer as SystemInstance).name")ELSEnullENDIF;
				clsname main_component = new clsname(sys, "ssc.name");
				
				run(main_component, args);
			}
		};
	'''
	}
}