/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.handlers;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Iterator;
import java.util.function.Consumer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MigrateActionCodes
extends AbstractHandler {
    @Inject
    private IWhitespaceInformationProvider whitespaceProvider;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        XtextEditor editor;
        boolean proceed = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Migrate action codes to smart strings", (String)"This migration will convert all action codes to smart strings.\n\nProceed?");
        if (proceed && (editor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event)) != null) {
            IXtextDocument iXtextDocument = editor.getDocument();
            MigrateContext ctx = (MigrateContext)iXtextDocument.modify((IUnitOfWork)new IUnitOfWork<MigrateContext, XtextResource>(){

                public MigrateContext exec(final XtextResource state) throws Exception {
                    MigrateContext migrateContext = new MigrateContext();
                    Procedures.Procedure1<MigrateContext> procedure1 = new Procedures.Procedure1<MigrateContext>(){

                        public void apply(MigrateContext it) {
                            it.lineSep = (this).MigrateActionCodes.this.whitespaceProvider.getLineSeparatorInformation(state.getURI()).getLineSeparator();
                        }
                    };
                    MigrateContext ctx = (MigrateContext)ObjectExtensions.operator_doubleArrow((Object)migrateContext, (Procedures.Procedure1)procedure1);
                    EList eList = state.getContents();
                    for (EObject model : eList) {
                        MigrateActionCodes.this.migrateModel(model, ctx);
                    }
                    return ctx;
                }
            });
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Migrate action codes to smart strings", (String)("Changed " + Integer.valueOf(ctx.actionCodesChanged) + " action codes to smart strings.\n\n" + "It might be necessary to format (ctrl+shift+F) the model."));
        }
        return null;
    }

    private void migrateModel(EObject model, final MigrateContext ctx) {
        Functions.Function1<DetailCode, Boolean> function1 = new Functions.Function1<DetailCode, Boolean>(){

            public Boolean apply(DetailCode it) {
                return it.isUsed();
            }
        };
        Consumer<DetailCode> consumer = new Consumer<DetailCode>(){

            @Override
            public void accept(DetailCode it) {
                String ccString = IterableExtensions.join((Iterable)it.getLines(), (CharSequence)ctx.lineSep);
                it.setUsed(false);
                it.getLines().clear();
                EList eList = it.getLines();
                eList.add((Object)ccString);
                ++ctx.actionCodesChanged;
            }
        };
        IterableExtensions.filter((Iterable)Iterables.filter((Iterable)IteratorExtensions.toIterable((Iterator)model.eAllContents()), DetailCode.class), (Functions.Function1)function1).forEach(consumer);
    }

    public static class MigrateContext {
        private String lineSep;
        private int actionCodesChanged = 0;
    }
}

