/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.util.List;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class FilesOption
extends Option<List<String>> {
    public FilesOption() {
        super("Input files", "The absolute or relative local file system paths to the input files.", null, "*", "FILES", true);
    }

    public static List<String> getPaths() {
        return (List)Options.get(FilesOption.class);
    }

    @Override
    public List<String> getDefault() {
        return Lists.list();
    }

    @Override
    public List<String> parseValue(String optName, String value) {
        return Lists.list((Object)value);
    }

    @Override
    public void verifyValue(List<String> value) {
        if (value.size() < 1) {
            String msg = Strings.fmt((String)"At least one input file expected, but none provided.", (Object[])new Object[]{value.size()});
            throw new InvalidOptionException(msg);
        }
    }

    @Override
    public String[] getCmdLine(Object value) {
        List files = (List)value;
        return files.toArray(new String[0]);
    }

    @Override
    public OptionGroup<List<String>> createOptionGroup(Composite page) {
        return new OptionGroup<List<String>>(page, Options.getInstance(FilesOption.class)){
            Text filesText;

            @Override
            protected void addComponents(Group group) {
                this.filesText = new Text((Composite)group, 2818);
                FormData grpData = new FormData();
                grpData.left = new FormAttachment(0, 0);
                grpData.right = new FormAttachment(100, 0);
                grpData.top = new FormAttachment((Control)this.descrLabel, 0);
                grpData.bottom = new FormAttachment((Control)this.filesText, 100);
                this.filesText.setLayoutData((Object)grpData);
            }

            @Override
            public String getDescription() {
                return "The input file paths, one per line.";
            }

            @Override
            public void setToValue(List<String> value) {
                CharSequence[] files = value.toArray(new String[0]);
                this.filesText.setText(String.join((CharSequence)Strings.NL, files));
            }

            @Override
            public String[] getCmdLine() {
                String txt = this.filesText.getText().replace("\r", "");
                List files = Lists.list();
                String[] stringArray = txt.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String file = stringArray[n2];
                    if (!file.isEmpty()) {
                        files.add(file);
                    }
                    ++n2;
                }
                return files.toArray(new String[0]);
            }
        };
    }
}

