/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.typecheck.symbols;

import java.util.List;
import org.eclipse.escet.chi.metamodel.chi.BehaviourDeclaration;
import org.eclipse.escet.chi.metamodel.chi.FunctionDeclaration;
import org.eclipse.escet.chi.metamodel.chi.Type;
import org.eclipse.escet.chi.metamodel.chi.VariableDeclaration;
import org.eclipse.escet.chi.metamodel.java.ChiConstructors;
import org.eclipse.escet.chi.typecheck.CheckContext;
import org.eclipse.escet.chi.typecheck.CheckType;
import org.eclipse.escet.chi.typecheck.Message;
import org.eclipse.escet.chi.typecheck.symbols.DeclarationSymbolEntry;
import org.eclipse.escet.chi.typecheck.symbols.SymbolEntry;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.common.PositionUtils;
import org.eclipse.escet.common.position.metamodel.position.Position;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;
import org.eclipse.escet.common.typechecker.SemanticException;

public class FunctionDefSymbolEntry
extends DeclarationSymbolEntry {
    private FunctionDeclaration oldFuncDef;
    private FunctionDeclaration useFuncDef;
    private FunctionDeclaration fullFuncDef;

    public FunctionDefSymbolEntry(FunctionDeclaration funcDef, CheckContext ctxt) {
        super(true, ctxt);
        this.oldFuncDef = funcDef;
        this.useFuncDef = null;
        this.fullFuncDef = null;
    }

    @Override
    protected BehaviourDeclaration getOriginalDecl() {
        return this.oldFuncDef;
    }

    public FunctionDeclaration getNewDecl() {
        Assert.check((boolean)this.useCheckDone());
        if (this.useFuncDef == null) {
            throw new SemanticException();
        }
        return this.useFuncDef;
    }

    @Override
    public String getName() {
        return this.oldFuncDef.getName();
    }

    @Override
    public Position getPosition() {
        return this.oldFuncDef.getPosition();
    }

    @Override
    public void typeCheckForUse() {
        if (this.useCheckDone()) {
            return;
        }
        this.checkState = SymbolEntry.TypeCheckState.USE_CHECK_DONE;
        List<VariableDeclaration> newParms = this.checkParameters(false);
        Type rType = CheckType.transNonvoidType(this.oldFuncDef.getReturnType(), this.ctxt);
        this.useFuncDef = ChiConstructors.newFunctionDeclaration((String)this.oldFuncDef.getName(), (Position)PositionUtils.copyPosition((PositionObject)this.oldFuncDef), (Type)rType, null, newParms);
    }

    @Override
    public void fullTypeCheck() {
        if (this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE) {
            return;
        }
        try {
            this.typeCheckForUse();
        }
        finally {
            this.checkState = SymbolEntry.TypeCheckState.FULL_CHECK_DONE;
        }
        if (this.useFuncDef == null) {
            return;
        }
        Type rType = this.useFuncDef.getReturnType();
        CheckContext retCtxt = this.parameterCtxt.newFunctionContext(rType);
        retCtxt = retCtxt.add(CheckContext.ContextItem.NO_DELAY, CheckContext.ContextItem.NO_SELECT, CheckContext.ContextItem.NO_RUN, CheckContext.ContextItem.NO_EXIT, CheckContext.ContextItem.NO_COMM, CheckContext.ContextItem.NO_TIME, CheckContext.ContextItem.NO_SAMPLE, CheckContext.ContextItem.NO_PROCESSES, CheckContext.ContextItem.NO_MODELS);
        Assert.check((retCtxt.exitType == null ? 1 : 0) != 0);
        this.checkBody((BehaviourDeclaration)this.useFuncDef, retCtxt);
        this.fullFuncDef = this.useFuncDef;
    }

    @Override
    public void checkUsage(CheckContext ctxt) {
        if (this.isUsed) {
            return;
        }
        ctxt.addWarning(Message.UNUSED_FUNCTION, this.getPosition(), this.getName());
    }

    public FunctionDeclaration getFunction() {
        Assert.check((this.checkState == SymbolEntry.TypeCheckState.FULL_CHECK_DONE ? 1 : 0) != 0);
        if (this.fullFuncDef == null) {
            throw new SemanticException();
        }
        return this.fullFuncDef;
    }
}

