/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.javacompiler;

import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.JavaInputFileObject;
import org.eclipse.escet.common.app.framework.javacompiler.RuntimeJavaCompiler;
import org.eclipse.escet.common.java.Strings;

public class RuntimeJavaCompilerException
extends Exception {
    public final RuntimeJavaCompiler compiler;
    public final Map<String, JavaInputFileObject> sources;

    public RuntimeJavaCompilerException(RuntimeJavaCompiler compiler, Map<String, JavaInputFileObject> sources) {
        this.compiler = compiler;
        this.sources = sources;
    }

    @Override
    public String getMessage() {
        StringBuilder b = new StringBuilder();
        b.append(Strings.fmt((String)"Run-time Java code compilation failed (with %d source files):\n", (Object[])new Object[]{this.sources.size()}));
        String output = this.compiler.getOutput().toString();
        b.append(Strings.fmt((String)"with output (%d):\n", (Object[])new Object[]{output.length()}));
        if (output.length() > 0) {
            String[] stringArray = output.split("\\r?\\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                b.append("    " + line + "\n");
                ++n2;
            }
        }
        List<Diagnostic<JavaFileObject>> diags = this.compiler.getDiagnostics().getDiagnostics();
        b.append(Strings.fmt((String)"with diagnostics (%d):\n", (Object[])new Object[]{diags.size()}));
        for (Diagnostic<JavaFileObject> diag : diags) {
            b.append("    " + RuntimeJavaCompilerException.diagnosticToString(diag) + "\n");
        }
        return b.toString();
    }

    public static String diagnosticToString(Diagnostic<?> diagnostic) {
        return "line " + diagnostic.getLineNumber() + ", column " + diagnostic.getColumnNumber() + ": " + String.valueOf((Object)diagnostic.getKind()) + ": " + diagnostic.getMessage(null);
    }
}

