/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.useradmin;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.equinox.internal.useradmin.Role;
import org.eclipse.equinox.internal.useradmin.UserAdmin;
import org.eclipse.equinox.internal.useradmin.UserAdminMsg;
import org.eclipse.equinox.internal.useradmin.UserAdminStore;
import org.osgi.service.prefs.BackingStoreException;

public class UserAdminHashtable
extends Hashtable<String, Object> {
    private static final long serialVersionUID = -397030865421289240L;
    protected Role role;
    protected int propertyType;
    protected UserAdmin userAdmin;
    protected UserAdminStore userAdminStore;
    protected static final int CREDENTIALS = 0;
    protected static final int PROPERTIES = 1;

    protected UserAdminHashtable(Role role, UserAdmin userAdmin, int propertyType) {
        this.role = role;
        this.propertyType = propertyType;
        this.userAdmin = userAdmin;
        this.userAdminStore = userAdmin.userAdminStore;
    }

    protected synchronized Object put(String key, Object value, boolean generateEvent) {
        if (generateEvent) {
            if (this.propertyType == 1) {
                try {
                    this.userAdminStore.addProperty(this.role, key, value);
                }
                catch (BackingStoreException ex) {
                    return null;
                }
                this.userAdmin.eventProducer.generateEvent(2, this.role);
            } else if (this.propertyType == 0) {
                try {
                    this.userAdminStore.addCredential(this.role, key, value);
                }
                catch (BackingStoreException ex) {
                    return null;
                }
                this.userAdmin.eventProducer.generateEvent(2, this.role);
            }
        }
        Object retVal = super.put(key, value);
        return retVal;
    }

    @Override
    public Object put(String name, Object value) {
        if (!(value instanceof String) && !(value instanceof byte[])) {
            throw new IllegalArgumentException(UserAdminMsg.INVALID_VALUE_EXCEPTION);
        }
        switch (this.propertyType) {
            case 1: {
                this.userAdmin.checkChangePropertyPermission(name);
                break;
            }
            case 0: {
                this.userAdmin.checkChangeCredentialPermission(name);
            }
        }
        return this.put(name, value, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized Object remove(Object key) {
        void name;
        if (!(key instanceof String)) {
            throw new IllegalArgumentException(UserAdminMsg.INVALID_KEY_EXCEPTION);
        }
        String string = (String)key;
        switch (this.propertyType) {
            case 1: {
                this.userAdmin.checkChangePropertyPermission((String)name);
                try {
                    this.userAdminStore.removeProperty(this.role, (String)name);
                }
                catch (BackingStoreException ex) {
                    return null;
                }
                this.userAdmin.eventProducer.generateEvent(2, this.role);
                break;
            }
            case 0: {
                this.userAdmin.checkChangeCredentialPermission((String)name);
                try {
                    this.userAdminStore.removeCredential(this.role, (String)name);
                }
                catch (BackingStoreException ex) {
                    return null;
                }
                this.userAdmin.eventProducer.generateEvent(2, this.role);
            }
        }
        return super.remove(name);
    }

    @Override
    public synchronized void clear() {
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            switch (this.propertyType) {
                case 1: {
                    this.userAdmin.checkChangePropertyPermission(name);
                    break;
                }
                case 0: {
                    this.userAdmin.checkChangeCredentialPermission(name);
                }
            }
        }
        switch (this.propertyType) {
            case 1: {
                try {
                    this.userAdminStore.clearProperties(this.role);
                }
                catch (BackingStoreException ex) {
                    return;
                }
                this.userAdmin.eventProducer.generateEvent(2, this.role);
                break;
            }
            case 0: {
                try {
                    this.userAdminStore.clearCredentials(this.role);
                }
                catch (BackingStoreException ex) {
                    return;
                }
                this.userAdmin.eventProducer.generateEvent(2, this.role);
            }
        }
        super.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object get(Object key) {
        void name;
        if (!(key instanceof String)) {
            throw new IllegalArgumentException(UserAdminMsg.INVALID_KEY_EXCEPTION);
        }
        String string = (String)key;
        if (this.propertyType == 0) {
            this.userAdmin.checkGetCredentialPermission((String)name);
        }
        return super.get(name);
    }
}

