/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.eclipse.ecf.core.util.Proxy;

public abstract class HttpClientProxyCredentialProvider
implements CredentialsProvider {
    private Collection provided = new HashSet();

    protected abstract Proxy getECFProxy();

    protected abstract Credentials getNTLMCredentials(Proxy var1);

    private Object makeProvidedKey(AuthScheme scheme, String host, int port, boolean isProxyAuthenticating) {
        ArrayList<Object> list = new ArrayList<Object>(3);
        list.add(host);
        list.add(new Integer(port));
        list.add(isProxyAuthenticating);
        return list;
    }

    public Credentials getCredentials(AuthScheme scheme, String host, int port, boolean isProxyAuthenticating) throws CredentialsNotAvailableException {
        if (!isProxyAuthenticating) {
            return null;
        }
        Proxy proxy = this.getECFProxy();
        if (proxy == null) {
            return null;
        }
        Object provideKey = this.makeProvidedKey(scheme, host, port, isProxyAuthenticating);
        if (this.provided.contains(provideKey)) {
            return null;
        }
        this.provided.add(provideKey);
        if ("ntlm".equalsIgnoreCase(scheme.getSchemeName())) {
            return this.getNTLMCredentials(proxy);
        }
        if ("basic".equalsIgnoreCase(scheme.getSchemeName()) || "digest".equalsIgnoreCase(scheme.getSchemeName())) {
            String proxyUsername = proxy.getUsername();
            String proxyPassword = proxy.getPassword();
            if (proxyUsername != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                return credentials;
            }
        }
        return null;
    }
}

