/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.jdt;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.emc.jdt.ReflectiveASTVisitor;
import org.eclipse.epsilon.eol.dom.EqualsOperatorExpression;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.execute.operations.AbstractOperation;
import org.eclipse.epsilon.eol.execute.operations.declarative.IAbstractOperationContributor;
import org.eclipse.epsilon.eol.execute.operations.declarative.SelectOperation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;

public class SearchableTypeCollection
extends AbstractCollection<Object>
implements IAbstractOperationContributor {
    protected IJavaProject[] javaProjects = null;
    protected ReflectiveASTVisitor visitor;

    protected boolean isSearchByName(String iteratorName, Expression condition) {
        NameExpression nameExpression;
        PropertyCallExpression propertyCallExpression;
        EqualsOperatorExpression equalsOperatorExpression;
        return condition instanceof EqualsOperatorExpression && (equalsOperatorExpression = (EqualsOperatorExpression)condition).getFirstOperand() instanceof PropertyCallExpression && (propertyCallExpression = (PropertyCallExpression)equalsOperatorExpression.getFirstOperand()).getTargetExpression() instanceof NameExpression && (nameExpression = (NameExpression)propertyCallExpression.getTargetExpression()).getName().equals(iteratorName) && propertyCallExpression.getNameExpression().getName().equals("name");
    }

    protected Object performSearch(IEolContext context, Expression nameExpression, List<Object> results, SearchRequestor requestor) throws EolRuntimeException {
        SearchPattern pattern = SearchPattern.createPattern((String)("" + context.getExecutorFactory().execute((ModuleElement)nameExpression, context)), (int)0, (int)0, (int)10);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])this.javaProjects, (int)1);
        SearchEngine engine = new SearchEngine();
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
            return results;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public SearchableTypeCollection(IJavaProject[] javaProjects, ReflectiveASTVisitor visitor) {
        this.javaProjects = javaProjects;
        this.visitor = visitor;
    }

    public AbstractOperation getAbstractOperation(String name) {
        if ("select".equals(name)) {
            return new SelectSearchParticipant();
        }
        if ("search".equals(name)) {
            return new SearchOperation();
        }
        return null;
    }

    @Override
    public Iterator<Object> iterator() {
        try {
            return this.getAllTypes().iterator();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private Collection<?> getAllTypes() throws JavaModelException {
        return this.visitor.getAllOfType(org.eclipse.jdt.internal.compiler.ast.TypeDeclaration.class.getSimpleName());
    }

    @Override
    public int size() {
        try {
            return this.getAllTypes().size();
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private final class SearchOperation
    extends AbstractOperation {
        private SearchOperation() {
        }

        public Object execute(Object target, NameExpression operationNameExpression, List<Parameter> iterators, List<Expression> expressions, IEolContext context) throws EolRuntimeException {
            if (!SearchableTypeCollection.this.isSearchByName(iterators.get(0).getName(), expressions.get(0))) {
                return new SelectOperation().execute(target, operationNameExpression, iterators, expressions, context);
            }
            EqualsOperatorExpression equalsOperatorExpression = (EqualsOperatorExpression)expressions.get(0);
            Expression nameExpression = equalsOperatorExpression.getSecondOperand();
            final ArrayList<Object> results = new ArrayList<Object>();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    results.add(match.getElement());
                }
            };
            return SearchableTypeCollection.this.performSearch(context, nameExpression, results, requestor);
        }
    }

    private final class SelectSearchParticipant
    extends SelectOperation {
        private SelectSearchParticipant() {
        }

        public Object execute(Object target, Variable iterator, Expression expression, IEolContext context, boolean returnOnFirstMatch) throws EolRuntimeException {
            if (!SearchableTypeCollection.this.isSearchByName(iterator.getName(), expression)) {
                return new SelectOperation().execute(target, iterator, expression, context, returnOnFirstMatch);
            }
            EqualsOperatorExpression equalsOperatorExpression = (EqualsOperatorExpression)expression;
            Expression nameExpression = equalsOperatorExpression.getSecondOperand();
            final ArrayList<Object> results = new ArrayList<Object>();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    if (match.getElement() instanceof SourceType) {
                        SourceType srcType = (SourceType)match.getElement();
                        ASTParser parser = ASTParser.newParser((int)8);
                        parser.setKind(8);
                        parser.setResolveBindings(true);
                        parser.setSource(srcType.getCompilationUnit());
                        CompilationUnit domAST = (CompilationUnit)parser.createAST(null);
                        ASTNode astNode = ASTNodeSearchUtil.getAstNode((SearchMatch)match, (CompilationUnit)domAST);
                        TypeDeclaration td = (TypeDeclaration)astNode.getParent();
                        results.add(td);
                    } else {
                        results.add(match.getElement());
                    }
                }
            };
            return SearchableTypeCollection.this.performSearch(context, nameExpression, results, requestor);
        }
    }
}

