/*******************************************************************************
 * Copyright (c) 2008 The University of York.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     Louis Rose - initial API and implementation
 ******************************************************************************/
package org.eclipse.epsilon.egl.parse;

public class EglRecognitionException extends Exception {

	// Generated by Eclipse
	private static final long serialVersionUID = -5527569663197109413L;
	
	private final int line;
	private final int col;
	
	public EglRecognitionException(String message, int line, int col) {
		super(message);
		this.line    = line;
		this.col     = col;
	}

	public int getColumnNumber() {
		return col;
	}

	public int getLineNumber() {
		return line;
	}
	
	@Override
	public String toString() {
		return getMessage() + " at line "+line + " col "+col;
	}
}
