/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.lang.sparql_10;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Add;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Datatype;
import org.apache.jena.sparql.expr.E_Divide;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.E_GreaterThan;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_IsBlank;
import org.apache.jena.sparql.expr.E_IsIRI;
import org.apache.jena.sparql.expr.E_IsLiteral;
import org.apache.jena.sparql.expr.E_IsURI;
import org.apache.jena.sparql.expr.E_Lang;
import org.apache.jena.sparql.expr.E_LangMatches;
import org.apache.jena.sparql.expr.E_LessThan;
import org.apache.jena.sparql.expr.E_LessThanOrEqual;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.E_Multiply;
import org.apache.jena.sparql.expr.E_NotEquals;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.E_SameTerm;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.E_Subtract;
import org.apache.jena.sparql.expr.E_UnaryMinus;
import org.apache.jena.sparql.expr.E_UnaryPlus;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.lang.sparql_10.JavaCharStream;
import org.apache.jena.sparql.lang.sparql_10.ParseException;
import org.apache.jena.sparql.lang.sparql_10.SPARQLParser10Base;
import org.apache.jena.sparql.lang.sparql_10.SPARQLParser10Constants;
import org.apache.jena.sparql.lang.sparql_10.SPARQLParser10TokenManager;
import org.apache.jena.sparql.lang.sparql_10.Token;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.syntax.TripleCollectorBGP;
import org.apache.jena.sparql.syntax.TripleCollectorMark;

public class SPARQLParser10
extends SPARQLParser10Base
implements SPARQLParser10Constants {
    boolean allowAggregatesInExpressions = false;
    public SPARQLParser10TokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[81];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public final void QueryUnit() throws ParseException {
        this.Query();
        this.jj_consume_token(0);
    }

    public final void Query() throws ParseException {
        this.Prologue();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                this.SelectQuery();
                break;
            }
            case 24: {
                this.ConstructQuery();
                break;
            }
            case 23: {
                this.DescribeQuery();
                break;
            }
            case 25: {
                this.AskQuery();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Prologue() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                this.BaseDecl();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
            }
        }
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 19: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block6;
                }
            }
            this.PrefixDecl();
        }
    }

    public final void BaseDecl() throws ParseException {
        this.jj_consume_token(18);
        String iri = this.IRI_REF();
        this.getPrologue().setBaseURI(iri);
    }

    public final void PrefixDecl() throws ParseException {
        this.jj_consume_token(19);
        Token t = this.jj_consume_token(9);
        String iri = this.IRI_REF();
        String s = this.fixupPrefix(t.image, t.beginLine, t.beginColumn);
        this.getPrologue().setPrefix(s, iri);
    }

    public final void SelectQuery() throws ParseException {
        this.Project();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
        this.SolutionModifier();
    }

    public final void SubSelect() throws ParseException {
        this.Project();
        this.WhereClause();
        this.SolutionModifier();
    }

    public final void Project() throws ParseException {
        this.jj_consume_token(20);
        this.getQuery().setQuerySelectType();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 21: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        this.getQuery().setDistinct(true);
                        break block0;
                    }
                    case 22: {
                        this.jj_consume_token(22);
                        this.getQuery().setReduced(true);
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        this.allowAggregatesInExpressions = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                block14: while (true) {
                    Var v = this.Var();
                    this.getQuery().addResultVar(v);
                    this.getQuery().setQueryResultStar(false);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: 
                        case 13: {
                            continue block14;
                        }
                    }
                    break;
                }
                this.jj_la1[6] = this.jj_gen;
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                this.getQuery().setQueryResultStar(true);
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.allowAggregatesInExpressions = false;
    }

    public final void ConstructQuery() throws ParseException {
        this.jj_consume_token(24);
        this.getQuery().setQueryConstructType();
        Template t = this.ConstructTemplate();
        this.getQuery().setConstructTemplate(t);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
        this.SolutionModifier();
    }

    public final void DescribeQuery() throws ParseException {
        this.jj_consume_token(23);
        this.getQuery().setQueryDescribeType();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                block13: while (true) {
                    Node n = this.VarOrIRIref();
                    this.getQuery().addDescribeNode(n);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: {
                            continue block13;
                        }
                    }
                    break;
                }
                this.jj_la1[9] = this.jj_gen;
                this.getQuery().setQueryResultStar(false);
                break;
            }
            case 97: {
                this.jj_consume_token(97);
                this.getQuery().setQueryResultStar(true);
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        block14: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    break block14;
                }
            }
            this.DatasetClause();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: 
            case 76: {
                this.WhereClause();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.SolutionModifier();
    }

    public final void AskQuery() throws ParseException {
        this.jj_consume_token(25);
        this.getQuery().setQueryAskType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 33: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            this.DatasetClause();
        }
        this.WhereClause();
    }

    public final void DatasetClause() throws ParseException {
        this.jj_consume_token(33);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: {
                this.DefaultGraphClause();
                break;
            }
            case 32: {
                this.NamedGraphClause();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void DefaultGraphClause() throws ParseException {
        String iri = this.SourceSelector();
        this.getQuery().addGraphURI(iri);
    }

    public final void NamedGraphClause() throws ParseException {
        this.jj_consume_token(32);
        String iri = this.SourceSelector();
        this.getQuery().addNamedGraphURI(iri);
    }

    public final String SourceSelector() throws ParseException {
        String iri = this.IRIref();
        return iri;
    }

    public final void WhereClause() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        Element el = this.GroupGraphPattern();
        this.getQuery().setQueryPattern(el);
    }

    public final void SolutionModifier() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.OrderClause();
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: 
            case 27: {
                this.LimitOffsetClauses();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
    }

    public final void OrderClause() throws ParseException {
        this.jj_consume_token(28);
        this.jj_consume_token(29);
        block3: while (true) {
            this.OrderCondition();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 30: 
                case 31: 
                case 40: 
                case 41: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 73: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[18] = this.jj_gen;
    }

    public final void OrderCondition() throws ParseException {
        int direction = 0;
        Expr expr = null;
        Var v = null;
        direction = -2;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 31: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        this.jj_consume_token(30);
                        direction = 1;
                        break;
                    }
                    case 31: {
                        this.jj_consume_token(31);
                        direction = -1;
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expr = this.BrackettedExpression();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 73: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 40: 
                    case 41: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 73: {
                        expr = this.Constraint();
                        break block0;
                    }
                    case 12: 
                    case 13: {
                        v = this.Var();
                        break block0;
                    }
                }
                this.jj_la1[20] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (v == null) {
            this.getQuery().addOrderBy(expr, direction);
        } else {
            this.getQuery().addOrderBy(v, direction);
        }
    }

    public final void LimitOffsetClauses() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.LimitClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        this.OffsetClause();
                        break block0;
                    }
                }
                this.jj_la1[22] = this.jj_gen;
                break;
            }
            case 27: {
                this.OffsetClause();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 26: {
                        this.LimitClause();
                        break block0;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LimitClause() throws ParseException {
        this.jj_consume_token(26);
        Token t = this.jj_consume_token(56);
        this.getQuery().setLimit(this.integerValue(t.image));
    }

    public final void OffsetClause() throws ParseException {
        this.jj_consume_token(27);
        Token t = this.jj_consume_token(56);
        this.getQuery().setOffset(this.integerValue(t.image));
    }

    public final Element GroupGraphPattern() throws ParseException {
        Element el = null;
        Token t = this.jj_consume_token(76);
        el = this.GroupGraphPatternSub();
        this.jj_consume_token(77);
        return el;
    }

    public final Element GroupGraphPatternSub() throws ParseException {
        Element el = null;
        ElementGroup elg = new ElementGroup();
        this.startGroup(elg);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 78: 
            case 80: {
                this.startTriplesBlock();
                el = this.TriplesBlock(null);
                this.endTriplesBlock();
                elg.addElement(el);
                break;
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
            }
        }
        block16: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 37: 
                case 39: 
                case 76: {
                    break;
                }
                default: {
                    this.jj_la1[26] = this.jj_gen;
                    break block16;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 36: 
                case 37: 
                case 76: {
                    el = this.GraphPatternNotTriples();
                    break;
                }
                case 39: {
                    el = this.Filter();
                    break;
                }
                default: {
                    this.jj_la1[27] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            elg.addElement(el);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 83: {
                    this.jj_consume_token(83);
                    break;
                }
                default: {
                    this.jj_la1[28] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 53: 
                case 54: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 75: 
                case 78: 
                case 80: {
                    this.startTriplesBlock();
                    el = this.TriplesBlock(null);
                    this.endTriplesBlock();
                    elg.addElement(el);
                    continue block16;
                }
            }
            this.jj_la1[29] = this.jj_gen;
        }
        this.endGroup(elg);
        return elg;
    }

    public final Element TriplesBlock(ElementTriplesBlock acc) throws ParseException {
        if (acc == null) {
            acc = new ElementTriplesBlock();
        }
        this.TriplesSameSubject(acc);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 83: {
                this.jj_consume_token(83);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 75: 
                    case 78: 
                    case 80: {
                        this.TriplesBlock(acc);
                        break block0;
                    }
                }
                this.jj_la1[30] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        return acc;
    }

    public final Element GraphPatternNotTriples() throws ParseException {
        Element el = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 37: {
                el = this.OptionalGraphPattern();
                break;
            }
            case 76: {
                el = this.GroupOrUnionGraphPattern();
                break;
            }
            case 36: {
                el = this.GraphGraphPattern();
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return el;
    }

    public final Element OptionalGraphPattern() throws ParseException {
        this.jj_consume_token(37);
        Element el = this.GroupGraphPattern();
        return new ElementOptional(el);
    }

    public final Element GraphGraphPattern() throws ParseException {
        this.jj_consume_token(36);
        Node n = this.VarOrIRIref();
        Element el = this.GroupGraphPattern();
        return new ElementNamedGraph(n, el);
    }

    public final Element GroupOrUnionGraphPattern() throws ParseException {
        Element el = null;
        ElementUnion el2 = null;
        el = this.GroupGraphPattern();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 38: {
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(38);
            if (el2 == null) {
                el2 = new ElementUnion();
                el2.addElement(el);
            }
            el = this.GroupGraphPattern();
            el2.addElement(el);
        }
        return el2 == null ? el : el2;
    }

    public final Element Filter() throws ParseException {
        this.jj_consume_token(39);
        Expr c = this.Constraint();
        return new ElementFilter(c);
    }

    public final Expr Constraint() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73 -> this.BrackettedExpression();
            case 40, 41, 44, 45, 46, 47, 48, 49, 50, 51, 52 -> this.BuiltInCall();
            case 8, 9, 10 -> this.FunctionCall();
            default -> {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Expr FunctionCall() throws ParseException {
        Object aParam = null;
        boolean distinct = false;
        String fname = this.IRIref();
        ExprList a = this.ArgList();
        return new E_Function(fname, a);
    }

    public final ExprList ArgList() throws ParseException {
        ExprList args = new ExprList();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            case 73: {
                this.jj_consume_token(73);
                Expr expr = this.Expression();
                args.add(expr);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 82: {
                            break;
                        }
                        default: {
                            this.jj_la1[35] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(82);
                    expr = this.Expression();
                    args.add(expr);
                }
                this.jj_consume_token(74);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return args;
    }

    public final ExprList ParamList() throws ParseException {
        ExprList args = new ExprList();
        this.jj_consume_token(78);
        Expr expr = this.Expression();
        args.add(expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(82);
            expr = this.Expression();
            args.add(expr);
        }
        this.jj_consume_token(79);
        return args;
    }

    public final Template ConstructTemplate() throws ParseException {
        TripleCollectorBGP acc = new TripleCollectorBGP();
        Template t = new Template(acc.getBGP());
        this.setInConstructTemplate(true);
        this.jj_consume_token(76);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 78: 
            case 80: {
                this.ConstructTriples(acc);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
            }
        }
        this.jj_consume_token(77);
        this.setInConstructTemplate(false);
        return t;
    }

    public final void ConstructTriples(TripleCollectorMark acc) throws ParseException {
        this.TriplesSameSubject(acc);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 83: {
                this.jj_consume_token(83);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 53: 
                    case 54: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 75: 
                    case 78: 
                    case 80: {
                        this.ConstructTriples(acc);
                        break block0;
                    }
                }
                this.jj_la1[39] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
            }
        }
    }

    public final void TriplesSameSubject(TripleCollectorMark acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 80: {
                Node s = this.VarOrTerm();
                this.PropertyListNotEmpty(s, acc);
                break;
            }
            case 73: 
            case 78: {
                Node s = this.TriplesNode(acc);
                this.PropertyList(s, acc);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PropertyListNotEmpty(Node s, TripleCollectorMark acc) throws ParseException {
        Node p = null;
        p = this.Verb();
        this.ObjectList(s, p, null, acc);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(81);
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 17: {
                    p = this.Verb();
                    this.ObjectList(s, p, null, acc);
                    continue block6;
                }
            }
            this.jj_la1[43] = this.jj_gen;
        }
    }

    public final void PropertyList(Node s, TripleCollectorMark acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: {
                this.PropertyListNotEmpty(s, acc);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
    }

    public final void ObjectList(Node s, Node p, Path path, TripleCollectorMark acc) throws ParseException {
        this.Object(s, p, path, acc);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 82: {
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(82);
            this.Object(s, p, path, acc);
        }
    }

    public final void Object(Node s, Node p, Path path, TripleCollectorMark acc) throws ParseException {
        int mark = acc.mark();
        Node o = this.GraphNode(acc);
        this.insert(acc, mark, s, p, path, o);
    }

    public final Node Verb() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8, 9, 10, 12, 13 -> this.VarOrIRIref();
            case 17 -> {
                this.jj_consume_token(17);
                yield this.nRDFtype;
            }
            default -> {
                this.jj_la1[46] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Node TriplesNode(TripleCollectorMark acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                Node n = this.Collection(acc);
                return n;
            }
            case 78: {
                Node n = this.BlankNodePropertyList(acc);
                return n;
            }
        }
        this.jj_la1[47] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNodePropertyList(TripleCollectorMark acc) throws ParseException {
        Token t = this.jj_consume_token(78);
        Node n = this.createBNode(t.beginLine, t.beginColumn);
        this.PropertyListNotEmpty(n, acc);
        this.jj_consume_token(79);
        return n;
    }

    public final Node Collection(TripleCollectorMark acc) throws ParseException {
        Node listHead = this.nRDFnil;
        Node lastCell = null;
        Token t = this.jj_consume_token(73);
        block3: while (true) {
            Node cell = this.createListNode(t.beginLine, t.beginColumn);
            if (listHead == this.nRDFnil) {
                listHead = cell;
            }
            if (lastCell != null) {
                this.insert(acc, lastCell, this.nRDFrest, cell);
            }
            int mark = acc.mark();
            Node n = this.GraphNode(acc);
            this.insert(acc, mark, cell, this.nRDFfirst, n);
            lastCell = cell;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 53: 
                case 54: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 75: 
                case 78: 
                case 80: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[48] = this.jj_gen;
        this.jj_consume_token(74);
        if (lastCell != null) {
            this.insert(acc, lastCell, this.nRDFrest, this.nRDFnil);
        }
        return listHead;
    }

    public final Node GraphNode(TripleCollectorMark acc) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 80: {
                Node n = this.VarOrTerm();
                return n;
            }
            case 73: 
            case 78: {
                Node n = this.TriplesNode(acc);
                return n;
            }
        }
        this.jj_la1[49] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node VarOrTerm() throws ParseException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                n = this.Var();
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 75: 
            case 80: {
                n = this.GraphTerm();
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Node VarOrIRIref() throws ParseException {
        Node n = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: 
            case 13: {
                n = this.Var();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                String iri = this.IRIref();
                n = this.createNode(iri);
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final Var Var() throws ParseException {
        Token t = switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12 -> this.jj_consume_token(12);
            case 13 -> this.jj_consume_token(13);
            default -> {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return this.createVariable(t.image, t.beginLine, t.beginColumn);
    }

    public final Node GraphTerm() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: 
            case 9: 
            case 10: {
                String iri = this.IRIref();
                return this.createNode(iri);
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                Node n = this.RDFLiteral();
                return n;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                Node n = this.NumericLiteral();
                return n;
            }
            case 53: 
            case 54: {
                Node n = this.BooleanLiteral();
                return n;
            }
            case 11: 
            case 80: {
                Node n = this.BlankNode();
                return n;
            }
            case 75: {
                this.jj_consume_token(75);
                return this.nRDFnil;
            }
        }
        this.jj_la1[53] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr Expression() throws ParseException {
        Expr expr = this.ConditionalOrExpression();
        return expr;
    }

    public final Expr ConditionalOrExpression() throws ParseException {
        Expr expr1 = this.ConditionalAndExpression();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 93: {
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(93);
            Expr expr2 = this.ConditionalAndExpression();
            expr1 = new E_LogicalOr(expr1, expr2);
        }
        return expr1;
    }

    public final Expr ConditionalAndExpression() throws ParseException {
        Expr expr1 = this.ValueLogical();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 94: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(94);
            Expr expr2 = this.ValueLogical();
            expr1 = new E_LogicalAnd(expr1, expr2);
        }
        return expr1;
    }

    public final Expr ValueLogical() throws ParseException {
        Expr expr = this.RelationalExpression();
        return expr;
    }

    public final Expr RelationalExpression() throws ParseException {
        Expr expr1 = this.NumericExpression();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 84: {
                        this.jj_consume_token(84);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_Equals(expr1, expr2);
                        break block0;
                    }
                    case 85: {
                        this.jj_consume_token(85);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_NotEquals(expr1, expr2);
                        break block0;
                    }
                    case 87: {
                        this.jj_consume_token(87);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_LessThan(expr1, expr2);
                        break block0;
                    }
                    case 86: {
                        this.jj_consume_token(86);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_GreaterThan(expr1, expr2);
                        break block0;
                    }
                    case 88: {
                        this.jj_consume_token(88);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_LessThanOrEqual(expr1, expr2);
                        break block0;
                    }
                    case 89: {
                        this.jj_consume_token(89);
                        Expr expr2 = this.NumericExpression();
                        expr1 = new E_GreaterThanOrEqual(expr1, expr2);
                        break block0;
                    }
                }
                this.jj_la1[56] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        return expr1;
    }

    public final Expr NumericExpression() throws ParseException {
        Expr expr = this.AdditiveExpression();
        return expr;
    }

    public final Expr AdditiveExpression() throws ParseException {
        Expr expr1;
        block21: {
            expr1 = this.MultiplicativeExpression();
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 95: 
                    case 96: {
                        break;
                    }
                    default: {
                        this.jj_la1[58] = this.jj_gen;
                        break block21;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 95: {
                        this.jj_consume_token(95);
                        Expr expr2 = this.MultiplicativeExpression();
                        expr1 = new E_Add(expr1, expr2);
                        continue block19;
                    }
                    case 96: {
                        this.jj_consume_token(96);
                        Expr expr2 = this.MultiplicativeExpression();
                        expr1 = new E_Subtract(expr1, expr2);
                        continue block19;
                    }
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: {
                        Expr expr2;
                        boolean addition = switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 59, 60, 61 -> {
                                Node n = this.NumericLiteralPositive();
                                n = this.stripSign(n);
                                expr2 = this.asExpr(n);
                                yield true;
                            }
                            case 62, 63, 64 -> {
                                Node n = this.NumericLiteralNegative();
                                n = this.stripSign(n);
                                expr2 = this.asExpr(n);
                                yield false;
                            }
                            default -> {
                                this.jj_la1[59] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        };
                        block12 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 97: 
                            case 98: {
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 97: {
                                        this.jj_consume_token(97);
                                        Expr expr3 = this.UnaryExpression();
                                        expr2 = new E_Multiply(expr2, expr3);
                                        break block12;
                                    }
                                    case 98: {
                                        this.jj_consume_token(98);
                                        Expr expr3 = this.UnaryExpression();
                                        expr2 = new E_Divide(expr2, expr3);
                                        break block12;
                                    }
                                }
                                this.jj_la1[60] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            default: {
                                this.jj_la1[61] = this.jj_gen;
                            }
                        }
                        if (addition) {
                            expr1 = new E_Add(expr1, expr2);
                            continue block19;
                        }
                        expr1 = new E_Subtract(expr1, expr2);
                        continue block19;
                    }
                }
                break;
            }
            this.jj_la1[62] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr1;
    }

    public final Expr MultiplicativeExpression() throws ParseException {
        Expr expr1;
        block8: {
            expr1 = this.UnaryExpression();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 97: 
                    case 98: {
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 97: {
                        this.jj_consume_token(97);
                        Expr expr2 = this.UnaryExpression();
                        expr1 = new E_Multiply(expr1, expr2);
                        continue block7;
                    }
                    case 98: {
                        this.jj_consume_token(98);
                        Expr expr2 = this.UnaryExpression();
                        expr1 = new E_Divide(expr1, expr2);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[64] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr1;
    }

    public final Expr UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                this.jj_consume_token(90);
                Expr expr = this.PrimaryExpression();
                return new E_LogicalNot(expr);
            }
            case 95: {
                this.jj_consume_token(95);
                Expr expr = this.PrimaryExpression();
                return new E_UnaryPlus(expr);
            }
            case 96: {
                this.jj_consume_token(96);
                Expr expr = this.PrimaryExpression();
                return new E_UnaryMinus(expr);
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                Expr expr = this.PrimaryExpression();
                return expr;
            }
        }
        this.jj_la1[65] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr PrimaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: {
                Expr expr = this.BrackettedExpression();
                return expr;
            }
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                Expr expr = this.BuiltInCall();
                return expr;
            }
            case 8: 
            case 9: 
            case 10: {
                Expr expr = this.IRIrefOrFunction();
                return expr;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: {
                Node gn = this.RDFLiteral();
                return this.asExpr(gn);
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                Node gn = this.NumericLiteral();
                return this.asExpr(gn);
            }
            case 53: 
            case 54: {
                Node gn = this.BooleanLiteral();
                return this.asExpr(gn);
            }
            case 12: 
            case 13: {
                Var gn = this.Var();
                return this.asExpr(gn);
            }
        }
        this.jj_la1[66] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr BrackettedExpression() throws ParseException {
        this.jj_consume_token(73);
        Expr expr = this.Expression();
        this.jj_consume_token(74);
        return expr;
    }

    public final Expr BuiltInCall() throws ParseException {
        Expr expr1 = null;
        Expr expr2 = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                this.jj_consume_token(73);
                Expr expr = this.Expression();
                this.jj_consume_token(74);
                return new E_Str(expr);
            }
            case 45: {
                this.jj_consume_token(45);
                this.jj_consume_token(73);
                Expr expr = this.Expression();
                this.jj_consume_token(74);
                return new E_Lang(expr);
            }
            case 46: {
                this.jj_consume_token(46);
                this.jj_consume_token(73);
                expr1 = this.Expression();
                this.jj_consume_token(82);
                expr2 = this.Expression();
                this.jj_consume_token(74);
                return new E_LangMatches(expr1, expr2);
            }
            case 44: {
                this.jj_consume_token(44);
                this.jj_consume_token(73);
                Expr expr = this.Expression();
                this.jj_consume_token(74);
                return new E_Datatype(expr);
            }
            case 40: {
                this.jj_consume_token(40);
                this.jj_consume_token(73);
                Var gn = this.Var();
                this.jj_consume_token(74);
                return new E_Bound(new ExprVar((Node)gn));
            }
            case 52: {
                this.jj_consume_token(52);
                this.jj_consume_token(73);
                expr1 = this.Expression();
                this.jj_consume_token(82);
                expr2 = this.Expression();
                this.jj_consume_token(74);
                return new E_SameTerm(expr1, expr2);
            }
            case 48: {
                Token t = this.jj_consume_token(48);
                this.jj_consume_token(73);
                Expr expr = this.Expression();
                this.jj_consume_token(74);
                return new E_IsIRI(expr);
            }
            case 47: {
                Token t = this.jj_consume_token(47);
                this.jj_consume_token(73);
                Expr expr = this.Expression();
                this.jj_consume_token(74);
                return new E_IsURI(expr);
            }
            case 49: {
                this.jj_consume_token(49);
                this.jj_consume_token(73);
                Expr expr = this.Expression();
                this.jj_consume_token(74);
                return new E_IsBlank(expr);
            }
            case 50: {
                this.jj_consume_token(50);
                this.jj_consume_token(73);
                Expr expr = this.Expression();
                this.jj_consume_token(74);
                return new E_IsLiteral(expr);
            }
            case 51: {
                Expr expr = this.RegexExpression();
                return expr;
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expr RegexExpression() throws ParseException {
        Expr patExpr = null;
        Expr flagsExpr = null;
        this.jj_consume_token(51);
        this.jj_consume_token(73);
        Expr expr = this.Expression();
        this.jj_consume_token(82);
        patExpr = this.Expression();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 82: {
                this.jj_consume_token(82);
                flagsExpr = this.Expression();
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
            }
        }
        this.jj_consume_token(74);
        return new E_Regex(expr, patExpr, flagsExpr);
    }

    public final Expr IRIrefOrFunction() throws ParseException {
        ExprList a = null;
        Object aParam = null;
        boolean distinct = false;
        String iri = this.IRIref();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: 
            case 75: {
                a = this.ArgList();
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        if (a == null) {
            return this.asExpr(this.createNode(iri));
        }
        return new E_Function(iri, a);
    }

    public final Node RDFLiteral() throws ParseException {
        String lex = null;
        lex = this.String();
        String lang = null;
        String uri = null;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: 
            case 99: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        Token t = this.jj_consume_token(14);
                        lang = SPARQLParser10.stripChars(t.image, 1);
                        break block0;
                    }
                    case 99: {
                        this.jj_consume_token(99);
                        uri = this.IRIref();
                        break block0;
                    }
                }
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[71] = this.jj_gen;
            }
        }
        return this.createLiteral(lex, lang, uri);
    }

    public final Node NumericLiteral() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56, 57, 58 -> this.NumericLiteralUnsigned();
            case 59, 60, 61 -> this.NumericLiteralPositive();
            case 62, 63, 64 -> this.NumericLiteralNegative();
            default -> {
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Node NumericLiteralUnsigned() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                Token t = this.jj_consume_token(56);
                return this.createLiteralInteger(t.image);
            }
            case 57: {
                Token t = this.jj_consume_token(57);
                return this.createLiteralDecimal(t.image);
            }
            case 58: {
                Token t = this.jj_consume_token(58);
                return this.createLiteralDouble(t.image);
            }
        }
        this.jj_la1[73] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node NumericLiteralPositive() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                Token t = this.jj_consume_token(59);
                return this.createLiteralInteger(t.image);
            }
            case 60: {
                Token t = this.jj_consume_token(60);
                return this.createLiteralDecimal(t.image);
            }
            case 61: {
                Token t = this.jj_consume_token(61);
                return this.createLiteralDouble(t.image);
            }
        }
        this.jj_la1[74] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node NumericLiteralNegative() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 62: {
                Token t = this.jj_consume_token(62);
                return this.createLiteralInteger(t.image);
            }
            case 63: {
                Token t = this.jj_consume_token(63);
                return this.createLiteralDecimal(t.image);
            }
            case 64: {
                Token t = this.jj_consume_token(64);
                return this.createLiteralDouble(t.image);
            }
        }
        this.jj_la1[75] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BooleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                this.jj_consume_token(53);
                return this.XSD_TRUE;
            }
            case 54: {
                this.jj_consume_token(54);
                return this.XSD_FALSE;
            }
        }
        this.jj_la1[76] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String String() throws ParseException {
        Token t;
        String lex = switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 69 -> {
                t = this.jj_consume_token(69);
                yield SPARQLParser10.stripQuotes(t.image);
            }
            case 70 -> {
                t = this.jj_consume_token(70);
                yield SPARQLParser10.stripQuotes(t.image);
            }
            case 71 -> {
                t = this.jj_consume_token(71);
                yield SPARQLParser10.stripQuotes3(t.image);
            }
            case 72 -> {
                t = this.jj_consume_token(72);
                yield SPARQLParser10.stripQuotes3(t.image);
            }
            default -> {
                this.jj_la1[77] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        lex = SPARQLParser10.unescapeStr(lex, t.beginLine, t.beginColumn);
        return lex;
    }

    public final String IRIref() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                String iri = this.IRI_REF();
                return iri;
            }
            case 9: 
            case 10: {
                String iri = this.PrefixedName();
                return iri;
            }
        }
        this.jj_la1[78] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String PrefixedName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: {
                Token t = this.jj_consume_token(10);
                return this.resolvePName(t.image, t.beginLine, t.beginColumn);
            }
            case 9: {
                Token t = this.jj_consume_token(9);
                return this.resolvePName(t.image, t.beginLine, t.beginColumn);
            }
        }
        this.jj_la1[79] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Node BlankNode() throws ParseException {
        Token t = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                t = this.jj_consume_token(11);
                return this.createBNode(t.image, t.beginLine, t.beginColumn);
            }
            case 80: {
                t = this.jj_consume_token(80);
                return this.createBNode(t.beginLine, t.beginColumn);
            }
        }
        this.jj_la1[80] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String IRI_REF() throws ParseException {
        Token t = this.jj_consume_token(8);
        return this.resolveQuotedIRI(t.image, t.beginLine, t.beginColumn);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{0x3900000, 262144, 524288, 0, 0x600000, 0x600000, 12288, 12288, 0, 14080, 14080, 0, 0, 0, 1792, 0, 0x10000000, 0xC000000, -1073727744, -1073741824, 14080, -1073727744, 0x8000000, 0x4000000, 0xC000000, 16128, 0, 0, 0, 16128, 16128, 0, 0, 0, 1792, 0, 0, 0, 16128, 16128, 0, 16128, 0, 145152, 145152, 0, 145152, 0, 16128, 16128, 16128, 14080, 12288, 3840, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14080, 14080, 0, 0, 0, 16384, 16384, 0, 0, 0, 0, 0, 0, 1792, 1536, 2048};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 2, 0, 0, 0, 0, 2, 0, 0, 2, 4, 2, 1, 4, 0, 0, 2093824, 0, 2093824, 2093824, 0, 0, 0, -10485760, 176, 176, 0, -10485760, -10485760, 0, 48, 64, 2093824, 0, 0, 0, -10485760, -10485760, 0, -10485760, 0, 0, 0, 0, 0, 0, -10485760, -10485760, -10485760, 0, 0, -10485760, 0, 0, 0, 0, -134217728, -134217728, 0, 0, -134217728, 0, 0, -8391936, -8391936, 2093824, 0, 0, 0, 0, -16777216, 0x7000000, 0x38000000, -1073741824, 0x600000, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 0, 0, 512, 0, 512, 512, 0, 0, 0, 84961, 4096, 4096, 524288, 84961, 84961, 524288, 4096, 0, 512, 262144, 2560, 262144, 84961, 84961, 524288, 84961, 131072, 0, 0, 262144, 0, 16896, 84961, 84961, 68065, 0, 0, 68065, 0x20000000, 0x40000000, 0x3F00000, 0x3F00000, -2147483647, 1, 0, 0, -2147483647, 0, 0, -2080373791, 993, 0, 262144, 2560, 0, 0, 1, 0, 0, 1, 0, 480, 0, 0, 65536};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 6, 6, 1, 6, 6, 1, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public SPARQLParser10(InputStream stream) {
        this(stream, null);
    }

    public SPARQLParser10(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source = new SPARQLParser10TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(e2);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SPARQLParser10(Reader stream) {
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new SPARQLParser10TokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SPARQLParser10(SPARQLParser10TokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SPARQLParser10TokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[108];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 81; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 108; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SPARQLParser10.jj_la1_init_0();
        SPARQLParser10.jj_la1_init_1();
        SPARQLParser10.jj_la1_init_2();
        SPARQLParser10.jj_la1_init_3();
    }
}

