/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.aggregate;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Accumulator;
import org.apache.jena.sparql.expr.aggregate.AccumulatorFactory;
import org.apache.jena.sparql.expr.aggregate.AggregateRegistry;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.expr.aggregate.AggregatorBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterExpr;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.sparql.util.FmtUtils;

public class AggCustom
extends AggregatorBase {
    private final String iri;

    public AggCustom(String iri, boolean distinct, ExprList exprs) {
        super("AGG", distinct, exprs);
        this.iri = iri;
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggCustom(this.iri, this.isDistinct, exprs);
    }

    @Override
    public String asSparqlExpr(SerializationContext sCxt) {
        IndentedLineBuffer x = new IndentedLineBuffer();
        if (!AggregateRegistry.isRegistered(this.iri)) {
            x.append(this.getName(), new Object[0]);
            x.append(" ", new Object[0]);
        }
        String uriStr = FmtUtils.stringForURI(this.iri, sCxt);
        x.append(uriStr, new Object[0]);
        x.append("(", new Object[0]);
        if (this.isDistinct) {
            x.append("DISTINCT ", new Object[0]);
        }
        x.incIndent();
        ExprUtils.fmtSPARQL((IndentedWriter)x, this.getExprList(), sCxt);
        x.decIndent();
        x.append(")", new Object[0]);
        return x.asString();
    }

    @Override
    public String toPrefixString() {
        IndentedLineBuffer x = new IndentedLineBuffer();
        x.append("(", new Object[0]);
        x.append(Lib.lowercase(this.getName()), new Object[0]);
        x.append(" <", new Object[0]);
        x.append(this.iri, new Object[0]);
        x.append("> ", new Object[0]);
        x.incIndent();
        if (this.isDistinct) {
            x.append("distinct ", new Object[0]);
        }
        boolean first = true;
        for (Expr e2 : this.getExprList()) {
            if (!first) {
                x.append(" ", new Object[0]);
            }
            first = false;
            WriterExpr.output((IndentedWriter)x, e2, null);
            first = false;
        }
        x.decIndent();
        x.append(")", new Object[0]);
        return x.asString();
    }

    @Override
    public Accumulator createAccumulator() {
        AccumulatorFactory f = AggregateRegistry.getAccumulatorFactory(this.iri);
        if (f == null) {
            throw new QueryExecException("Unregistered aggregate: " + this.iri);
        }
        return f.createAccumulator(this, this.isDistinct);
    }

    @Override
    public Node getValueEmpty() {
        return AggregateRegistry.getNoGroupValue(this.iri);
    }

    @Override
    public Expr getExpr() {
        if (this.exprList.size() == 0) {
            return null;
        }
        return this.exprList.get(0);
    }

    public String getIRI() {
        return this.iri;
    }

    @Override
    public int hashCode() {
        if (!AggregateRegistry.isRegistered(this.iri)) {
            return this.asFunction().hashCode();
        }
        return 0x181 ^ this.getExprList().hashCode() ^ this.iri.hashCode();
    }

    private E_Function asFunction() {
        return new E_Function(this.iri, this.exprList);
    }

    @Override
    public boolean equals(Aggregator other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!AggregateRegistry.isRegistered(this.iri)) {
            E_Function f1 = this.asFunction();
            if (!(other instanceof AggCustom)) {
                return false;
            }
            E_Function f2 = ((AggCustom)other).asFunction();
            return f1.equals(f2, bySyntax);
        }
        if (!(other instanceof AggCustom)) {
            return false;
        }
        AggCustom agg = (AggCustom)other;
        return Objects.equals(this.iri, agg.iri) && this.isDistinct == agg.isDistinct && this.getExprList().equals(agg.getExprList(), bySyntax);
    }

    public static Accumulator createAccNull() {
        return new AccCustom();
    }

    private static class AccCustom
    implements Accumulator {
        private int nBindings = 0;

        @Override
        public void accumulate(Binding binding, FunctionEnv functionEnv) {
            ++this.nBindings;
        }

        @Override
        public NodeValue getValue() {
            return null;
        }
    }
}

