/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFatalException;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.util.PrintSerializableBase;

public abstract class QueryIteratorBase
extends PrintSerializableBase
implements QueryIterator {
    private boolean finished = false;
    private final AtomicBoolean requestingCancel;
    private volatile boolean cancelOnce = false;
    private Object cancelLock = new Object();

    public QueryIteratorBase() {
        this(null);
    }

    public QueryIteratorBase(AtomicBoolean cancelSignal) {
        if (cancelSignal == null) {
            cancelSignal = new AtomicBoolean(false);
        }
        this.requestingCancel = cancelSignal;
    }

    private boolean requestingCancel() {
        return this.requestingCancel != null && this.requestingCancel.get();
    }

    private void haveCancelled() {
    }

    protected abstract boolean hasNextBinding();

    protected abstract Binding moveToNextBinding();

    protected abstract void closeIterator();

    protected abstract void requestCancel();

    boolean getRequestingCancel() {
        return this.requestingCancel();
    }

    protected boolean isFinished() {
        return this.finished;
    }

    @Override
    public final boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.cancelOnce) {
            this.close();
            throw new QueryCancelledException();
        }
        boolean r = this.hasNextBinding();
        if (!r) {
            try {
                this.close();
            }
            catch (QueryFatalException ex) {
                Log.error(this, "Fatal exception: " + ex.getMessage());
                throw ex;
            }
        }
        return r;
    }

    @Override
    public final Binding next() {
        return this.nextBinding();
    }

    @Override
    public final Binding nextBinding() {
        try {
            boolean shouldCancel = this.requestingCancel();
            if (shouldCancel) {
                this.close();
                throw new QueryCancelledException();
            }
            if (this.finished) {
                throw new NoSuchElementException(Lib.className(this));
            }
            if (!this.hasNextBinding()) {
                throw new NoSuchElementException(Lib.className(this));
            }
            Binding obj = this.moveToNextBinding();
            if (obj == null) {
                throw new NoSuchElementException(Lib.className(this));
            }
            if (shouldCancel && !this.finished) {
                this.close();
            }
            return obj;
        }
        catch (QueryFatalException ex) {
            Log.error(this, "QueryFatalException", ex);
            throw ex;
        }
    }

    @Override
    public final void remove() {
        Log.warn(this, "Call to QueryIterator.remove() : " + Lib.className(this) + ".remove");
        throw new UnsupportedOperationException(Lib.className(this) + ".remove");
    }

    @Override
    public void close() {
        if (this.finished) {
            return;
        }
        try {
            this.closeIterator();
        }
        catch (QueryException ex) {
            Log.warn(this, "QueryException in close()", ex);
        }
        this.finished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void cancel() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (!this.cancelOnce) {
                if (this.requestingCancel != null) {
                    this.requestingCancel.set(true);
                }
                this.cancelOnce = true;
                this.requestCancel();
            }
        }
    }

    protected static void performClose(QueryIterator iter) {
        if (iter == null) {
            return;
        }
        iter.close();
    }

    protected static void performRequestCancel(QueryIterator iter) {
        if (iter == null) {
            return;
        }
        iter.cancel();
    }
}

