/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.impl.repositories;

import java.net.URI;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.ontapi.GraphRepository;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParser;

public class DocumentGraphRepository
implements GraphRepository {
    private final Supplier<Graph> factory;
    private final Map<String, Source> mappings = new HashMap<String, Source>();
    private final Map<String, Graph> graphs = new HashMap<String, Graph>();

    public DocumentGraphRepository() {
        this(GraphMemFactory::createDefaultGraph);
    }

    public DocumentGraphRepository(Supplier<Graph> factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    public static String check(String fileNameOrURI) {
        Objects.requireNonNull(fileNameOrURI, "Null fileNameOrURI");
        RuntimeException ex = new RuntimeException("Wrong URI: <" + fileNameOrURI + ">");
        String file = null;
        if (fileNameOrURI.startsWith("file:")) {
            file = fileNameOrURI.replace("file:", "/");
        } else if (fileNameOrURI.startsWith("/")) {
            file = fileNameOrURI;
        }
        try {
            if (file != null) {
                Paths.get(file, new String[0]);
            }
            return fileNameOrURI;
        }
        catch (Exception e2) {
            ex.addSuppressed(e2);
            try {
                new URI(fileNameOrURI);
                return fileNameOrURI;
            }
            catch (Exception e3) {
                ex.addSuppressed(e3);
                throw ex;
            }
        }
    }

    private static Source parseLocation(String fileNameOrUri) {
        return new Source(DocumentGraphRepository.check(fileNameOrUri), RDFLanguages.resourceNameToLang(fileNameOrUri, Lang.RDFXML));
    }

    private static Graph read(Source source, Graph target) {
        RDFParser.create().source(source.location).lang(source.lang).parse(target);
        return target;
    }

    public DocumentGraphRepository addMapping(String id, String fileNameOrUri) {
        this.mappings.put(Objects.requireNonNull(id, "Null Graph Id"), DocumentGraphRepository.parseLocation(fileNameOrUri));
        return this;
    }

    private Source getMapping(String id) {
        return this.mappings.computeIfAbsent(id, DocumentGraphRepository::parseLocation);
    }

    @Override
    public Graph get(String id) {
        return this.graphs.computeIfAbsent(Objects.requireNonNull(id, "Null Graph Id"), s -> DocumentGraphRepository.read(this.getMapping((String)s), this.factory.get()));
    }

    @Override
    public Stream<String> ids() {
        return this.getIds().stream();
    }

    @Override
    public Graph put(String id, Graph graph) {
        return this.graphs.put(Objects.requireNonNull(id, "Null Graph Id"), Objects.requireNonNull(graph, "Null Graph"));
    }

    @Override
    public Graph remove(String id) {
        this.mappings.remove(id);
        return this.graphs.remove(Objects.requireNonNull(id, "Null Graph Id"));
    }

    @Override
    public void clear() {
        this.mappings.clear();
        this.graphs.clear();
    }

    @Override
    public long count() {
        return this.getIds().size();
    }

    @Override
    public boolean contains(String id) {
        return this.graphs.containsKey(id) || this.mappings.containsKey(id);
    }

    public Set<String> getIds() {
        return Stream.of(this.graphs.keySet(), this.mappings.keySet()).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    private record Source(String location, Lang lang) {
    }
}

