/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.sys;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.apache.jena.atlas.RuntimeIOException;
import org.apache.jena.dboe.base.file.Location;

public class IO_DB {
    public static Location asLocation(Path path) {
        Objects.requireNonNull(path, "IOX.asLocation(null)");
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new RuntimeIOException("Path is not naming a directory: " + path);
        }
        return Location.create(path.toString());
    }

    public static Path asPath(Location location) {
        if (location.isMem()) {
            throw new RuntimeIOException("Location is a memory location: " + location);
        }
        return Paths.get(location.getDirectoryPath(), new String[0]);
    }

    public static File asFile(Location loc) {
        return new File(loc.getDirectoryPath());
    }
}

