/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emfforms.common.Optional;
import org.eclipse.emfforms.spi.swt.table.CellLabelProviderFactory;
import org.eclipse.emfforms.spi.swt.table.EditingSupportCreator;
import org.eclipse.emfforms.spi.swt.table.TableViewerSWTCustomization;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;

public class ColumnDescriptionImpl
implements TableViewerSWTCustomization.ColumnDescription {
    private final boolean resizeable;
    private final boolean moveable;
    private final int styleBits;
    private final int weight;
    private final int minWidth;
    private final IObservableValue columnText;
    private final IObservableValue tooltipText;
    private final CellLabelProviderFactory labelProvider;
    private final Optional<EditingSupportCreator> editingSupport;
    private final Optional<Image> image;

    public ColumnDescriptionImpl(boolean resizeable, boolean moveable, int styleBits, int weight, int minWidth, IObservableValue columnText, IObservableValue tooltipText, CellLabelProviderFactory labelProvider, EditingSupportCreator editingSupport, Image image) {
        this.resizeable = resizeable;
        this.moveable = moveable;
        this.styleBits = styleBits;
        this.weight = weight;
        this.minWidth = minWidth;
        this.columnText = columnText;
        this.tooltipText = tooltipText;
        this.labelProvider = labelProvider;
        this.editingSupport = Optional.ofNullable((Object)editingSupport);
        this.image = Optional.ofNullable((Object)image);
    }

    @Override
    public boolean isResizeable() {
        return this.resizeable;
    }

    @Override
    public boolean isMoveable() {
        return this.moveable;
    }

    @Override
    public int getStyleBits() {
        return this.styleBits;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public IObservableValue getColumnText() {
        return this.columnText;
    }

    @Override
    public IObservableValue getColumnTooltip() {
        return this.tooltipText;
    }

    @Override
    public CellLabelProvider createLabelProvider(TableViewer columnViewer) {
        return this.labelProvider.createCellLabelProvider(columnViewer);
    }

    @Override
    public Optional<EditingSupport> createEditingSupport(TableViewer columnViewer) {
        if (this.editingSupport.isPresent()) {
            return Optional.of((Object)((EditingSupportCreator)this.editingSupport.get()).createEditingSupport(columnViewer));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Image> getColumnImage() {
        return this.image;
    }
}

