/*
 * Decompiled with CFR 0.152.
 */
package pum.simuref.configuration.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import pum.simuref.configuration.core.Mapping;
import pum.simuref.configuration.managers.ConfigurationManager;
import pum.simuref.configuration.managers.ProjectManager;

public class MappingConfiguration
extends PropertyPage {
    private Table tableMappedModels;
    private Table tableModelCode;
    private Text pathModelFile;
    private Text pathProjectFolder;
    private Button btnAddMapping;
    private IProject project;
    private List<Mapping> listModelProjects;
    private List<String> listMappedModels;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getDefaultsButton().setVisible(false);
    }

    public boolean performOk() {
        this.saveConfiguration();
        ConfigurationManager.getInstance();
        ConfigurationManager.saveConfiguration(this.project);
        return true;
    }

    private void saveConfiguration() {
        ArrayList<Mapping> listModelProjects = new ArrayList<Mapping>();
        ArrayList<String> listMappedModels = new ArrayList<String>();
        int i = 0;
        while (i < this.tableMappedModels.getItemCount()) {
            listMappedModels.add(this.tableMappedModels.getItem(i).getText());
            ++i;
        }
        i = 0;
        while (i < this.tableModelCode.getItemCount()) {
            TableItem ti = this.tableModelCode.getItem(i);
            Mapping m = new Mapping(ti.getText(0), ti.getText(1));
            listModelProjects.add(m);
            ++i;
        }
        ConfigurationManager.getInstance();
        ConfigurationManager.setConfiguration(this.project, listModelProjects, listMappedModels);
    }

    protected void performApply() {
        this.performOk();
    }

    private void fillTables() {
        TableItem ti;
        int i = 0;
        while (i < this.listMappedModels.size()) {
            ti = new TableItem(this.tableMappedModels, 0);
            ti.setText(this.listMappedModels.get(i));
            ++i;
        }
        i = 0;
        while (i < this.listModelProjects.size()) {
            ti = new TableItem(this.tableModelCode, 0);
            ti.setText(0, this.listModelProjects.get(i).getPathModelFile());
            ti.setText(1, this.listModelProjects.get(i).getPathProjectFolder());
            ++i;
        }
    }

    private void loadConfiguration() {
        ConfigurationManager.getInstance();
        this.listModelProjects = ConfigurationManager.getModelProjectMappings(this.project);
        this.listMappedModels = ConfigurationManager.getMappedModels(this.project);
    }

    public Control createContents(Composite parent) {
        Composite containerCodeModel = new Composite(parent, 0);
        containerCodeModel.setLayout((Layout)new GridLayout(1, false));
        TabFolder tabFolder = new TabFolder(containerCodeModel, 0);
        GridData gd_tabFolder = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_tabFolder.widthHint = 600;
        tabFolder.setLayoutData((Object)gd_tabFolder);
        tabFolder.setBounds(0, 0, 150, 50);
        TabItem tbtmNewItem = new TabItem(tabFolder, 0);
        tbtmNewItem.setText("Code to Model");
        Composite composite = new Composite((Composite)tabFolder, 0);
        tbtmNewItem.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblModelFilesMapped = new Label(composite, 0);
        lblModelFilesMapped.setBounds(0, 0, 59, 14);
        lblModelFilesMapped.setText("Model files mapped to this project:");
        new Label(composite, 0);
        this.tableMappedModels = new Table(composite, 67584);
        GridData gd_tableProjectModel = new GridData(4, 4, true, true, 1, 2);
        gd_tableProjectModel.heightHint = 113;
        gd_tableProjectModel.widthHint = 295;
        this.tableMappedModels.setLayoutData((Object)gd_tableProjectModel);
        this.tableMappedModels.setHeaderVisible(true);
        this.tableMappedModels.setLinesVisible(true);
        TableColumn tblclmnModelFile = new TableColumn(this.tableMappedModels, 0);
        tblclmnModelFile.setWidth(518);
        tblclmnModelFile.setText("Model File");
        new Label(composite, 0);
        Button btnRemoveModel = new Button(composite, 0);
        GridData gd_btnRemoveModel = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_btnRemoveModel.widthHint = 99;
        btnRemoveModel.setLayoutData((Object)gd_btnRemoveModel);
        btnRemoveModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MappingConfiguration.this.tableMappedModels.getSelectionIndex() != -1) {
                    MappingConfiguration.this.tableMappedModels.remove(MappingConfiguration.this.tableMappedModels.getSelectionIndex());
                }
            }
        });
        btnRemoveModel.setText("Remove");
        new Label(composite, 0);
        Button btnAddModel = new Button(composite, 0);
        btnAddModel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnAddModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(MappingConfiguration.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.setTitle("Model Selection");
                dialog.setMessage("Select the model file from the tree:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                switch (dialog.open()) {
                    case 0: {
                        Object o = dialog.getFirstResult();
                        String stringModel = o.toString().substring(2);
                        TableItem ti = new TableItem(MappingConfiguration.this.tableMappedModels, 0);
                        ti.setText(stringModel);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        });
        btnAddModel.setText("Add");
        TabItem tbtmModelToCode = new TabItem(tabFolder, 0);
        tbtmModelToCode.setText("Model to Code");
        Composite compositeModelCode = new Composite((Composite)tabFolder, 0);
        tbtmModelToCode.setControl((Control)compositeModelCode);
        compositeModelCode.setLayout((Layout)new GridLayout(2, false));
        Label lblModelFilesMapped_1 = new Label(compositeModelCode, 0);
        lblModelFilesMapped_1.setText("Model files mapped to the corresponding code project:");
        new Label(compositeModelCode, 0);
        this.tableModelCode = new Table(compositeModelCode, 67584);
        GridData gd_tableModelCode = new GridData(0x1000000, 4, true, true, 1, 1);
        gd_tableModelCode.widthHint = 461;
        gd_tableModelCode.heightHint = 74;
        this.tableModelCode.setLayoutData((Object)gd_tableModelCode);
        this.tableModelCode.setHeaderVisible(true);
        this.tableModelCode.setLinesVisible(true);
        TableColumn tblclmnModel = new TableColumn(this.tableModelCode, 0);
        tblclmnModel.setWidth(230);
        tblclmnModel.setText("Model File");
        TableColumn tblclmnProjectFolder = new TableColumn(this.tableModelCode, 0);
        tblclmnProjectFolder.setWidth(236);
        tblclmnProjectFolder.setText("Project Folder");
        Button btnRemoveModelCode = new Button(compositeModelCode, 0);
        btnRemoveModelCode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MappingConfiguration.this.tableModelCode.getSelectionIndex() != -1) {
                    MappingConfiguration.this.tableModelCode.remove(MappingConfiguration.this.tableModelCode.getSelectionIndex());
                }
            }
        });
        btnRemoveModelCode.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnRemoveModelCode.setText("Remove");
        Label lblNewMapping = new Label(compositeModelCode, 258);
        lblNewMapping.setText("New Mapping");
        GridData gd_lblNewMapping = new GridData(0x1000000, 4, false, false, 2, 1);
        gd_lblNewMapping.heightHint = 11;
        gd_lblNewMapping.widthHint = 381;
        lblNewMapping.setLayoutData((Object)gd_lblNewMapping);
        Label lblModelFile = new Label(compositeModelCode, 0);
        lblModelFile.setText("Model File:");
        new Label(compositeModelCode, 0);
        this.pathModelFile = new Text(compositeModelCode, 2048);
        this.pathModelFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.pathModelFile.setBounds(0, 0, 64, 19);
        Button btnBrowseModel = new Button(compositeModelCode, 0);
        btnBrowseModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(MappingConfiguration.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.setTitle("Model Selection");
                dialog.setMessage("Select the model file from the tree:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                switch (dialog.open()) {
                    case 0: {
                        Object o = dialog.getFirstResult();
                        String stringModel = o.toString().substring(2);
                        MappingConfiguration.this.pathModelFile.setText(stringModel);
                        MappingConfiguration.this.checkReady();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        });
        btnBrowseModel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnBrowseModel.setText("Browse Model");
        Label lblProjectFolder = new Label(compositeModelCode, 0);
        lblProjectFolder.setText("Project Folder:");
        new Label(compositeModelCode, 0);
        this.pathProjectFolder = new Text(compositeModelCode, 2048);
        this.pathProjectFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button btnBrowseProject = new Button(compositeModelCode, 0);
        btnBrowseProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                System.out.println(e);
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(MappingConfiguration.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
                dialog.setTitle("Code Selection");
                dialog.setMessage("Select the code project from the tree:");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                switch (dialog.open()) {
                    case 0: {
                        Object o = dialog.getFirstResult();
                        String stringModel = o.toString().substring(2);
                        MappingConfiguration.this.pathProjectFolder.setText(stringModel);
                        MappingConfiguration.this.checkReady();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
        });
        btnBrowseProject.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnBrowseProject.setText("Browse Project");
        new Label(compositeModelCode, 0);
        this.btnAddMapping = new Button(compositeModelCode, 0);
        this.btnAddMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem ti = new TableItem(MappingConfiguration.this.tableModelCode, 0);
                String[] values = new String[]{MappingConfiguration.this.pathModelFile.getText(), MappingConfiguration.this.pathProjectFolder.getText()};
                ti.setText(values);
                MappingConfiguration.this.pathModelFile.setText("");
                MappingConfiguration.this.pathProjectFolder.setText("");
                MappingConfiguration.this.btnAddMapping.setEnabled(false);
            }
        });
        this.btnAddMapping.setEnabled(false);
        this.btnAddMapping.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnAddMapping.setText("Add Mapping");
        this.project = ProjectManager.getActualProjectForPropertyPage(this);
        this.loadConfiguration();
        this.fillTables();
        return containerCodeModel;
    }

    private void checkReady() {
        if (!this.pathProjectFolder.getText().isEmpty() && !this.pathModelFile.getText().isEmpty()) {
            this.btnAddMapping.setEnabled(true);
        }
    }
}

