/*
 * Decompiled with CFR 0.152.
 */
package pum.simuref.configuration.managers;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import pum.simuref.configuration.core.Configuration;
import pum.simuref.configuration.core.Mapping;
import pum.simuref.configuration.managers.XMLManager;

public class XMLProjectFileManager
extends XMLManager {
    private static final String MAP_CONFIG = ".emfmappings.xml";
    private static final String CONFIGURATOR_TAG = "mappingConfiguration";

    public static void saveConfiguratuon(Configuration configuration) {
        DocumentBuilder builder = XMLProjectFileManager.createDocumentBuilder();
        if (builder != null) {
            Element mappingEntry;
            Document doc = builder.newDocument();
            Element root = doc.createElement(CONFIGURATOR_TAG);
            doc.appendChild(root);
            for (String mappedModel : configuration.getMappedModelFiles()) {
                mappingEntry = doc.createElement("mappingProjectToModel");
                mappingEntry.setTextContent(mappedModel);
                root.appendChild(mappingEntry);
            }
            for (Mapping m : configuration.getMappingListModelFileToProject()) {
                mappingEntry = doc.createElement("mappingModelToProject");
                Element sourceEntry = doc.createElement("model");
                Element targetEntry = doc.createElement("code");
                sourceEntry.setTextContent(m.getPathModelFile());
                targetEntry.setTextContent(m.getPathProjectFolder());
                mappingEntry.appendChild(sourceEntry);
                mappingEntry.appendChild(targetEntry);
                root.appendChild(mappingEntry);
            }
            Transformer transformer = XMLProjectFileManager.createTransformer();
            DOMSource source = new DOMSource(doc);
            URI uri = configuration.getProject().getLocationURI();
            StreamResult result = new StreamResult(uri + "/" + MAP_CONFIG);
            try {
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    public static Configuration loadConfiguration(IProject project) {
        if (!XMLProjectFileManager.configurationFileExists(project)) {
            return null;
        }
        Configuration configuration = new Configuration(project);
        DocumentBuilder builder = XMLProjectFileManager.createDocumentBuilder();
        if (builder != null) {
            Document doc = null;
            try {
                URI uri = project.getLocationURI();
                doc = builder.parse(uri + "/" + MAP_CONFIG);
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (doc != null) {
                Element root = doc.getDocumentElement();
                NodeList entryListC2M = root.getElementsByTagName("mappingProjectToModel");
                ArrayList<String> mappedModelFiles = new ArrayList<String>();
                int i = 0;
                while (i < entryListC2M.getLength()) {
                    Element entry = (Element)entryListC2M.item(i);
                    mappedModelFiles.add(entry.getTextContent());
                    ++i;
                }
                configuration.setMappedModelFiles(mappedModelFiles);
                NodeList entryListM2C = root.getElementsByTagName("mappingModelToProject");
                ArrayList<Mapping> mappingModelFileProject = new ArrayList<Mapping>();
                int i2 = 0;
                while (i2 < entryListM2C.getLength()) {
                    Element entry = (Element)entryListM2C.item(i2);
                    NodeList nodeListSource = entry.getElementsByTagName("model");
                    NodeList nodeListTarget = entry.getElementsByTagName("code");
                    Mapping m = new Mapping(nodeListSource.item(0).getTextContent(), nodeListTarget.item(0).getTextContent());
                    mappingModelFileProject.add(m);
                    ++i2;
                }
                configuration.setMappingListModelFileToProject(mappingModelFileProject);
            }
        }
        return configuration;
    }

    private static boolean configurationFileExists(IProject project) {
        URI uri = project.getLocationURI();
        String path = String.valueOf(uri.getPath()) + "/" + MAP_CONFIG;
        File file = new File(path);
        return file.exists();
    }
}

