/*
 * Decompiled with CFR 0.152.
 */
package pum.simuref.configuration.managers;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EObject;
import pum.simuref.configuration.core.Configuration;
import pum.simuref.configuration.core.Mapping;
import pum.simuref.configuration.managers.ConfigurationManager;
import pum.simuref.configuration.managers.ProjectManager;

public class MappingManager {
    private static MappingManager singelton = null;

    private MappingManager() {
    }

    public static synchronized MappingManager getInstance() {
        if (singelton == null) {
            singelton = new MappingManager();
        }
        return singelton;
    }

    public String getModelPathStringForJavaProject() {
        ConfigurationManager.getInstance();
        IProject project = ProjectManager.getActualProject();
        Configuration config = ConfigurationManager.getConfiguration(project);
        ArrayList<String> result = config.getMappedModelFiles();
        if (!result.isEmpty()) {
            return result.get(0);
        }
        return null;
    }

    public String getJavaProjectNameForEmfElement(EObject eObject) {
        ConfigurationManager.getInstance();
        if (eObject.eResource().getURI().scheme().equals("platform")) {
            IProject project = ProjectManager.getActualProject();
            Configuration config = ConfigurationManager.getConfiguration(project);
            ArrayList<Mapping> temp = config.getMappingListModelFileToProject();
            ArrayList<String> result = new ArrayList<String>();
            String pathEObject = eObject.eResource().getURI().path().replace("/resource/", "");
            if (!temp.isEmpty()) {
                for (Mapping m : temp) {
                    if (!m.getPathModelFile().equals(pathEObject)) continue;
                    result.add(m.getPathProjectFolder());
                }
            }
            return (String)result.get(0);
        }
        return null;
    }

    public IProject getActualProject() {
        return ProjectManager.getActualProject();
    }
}

