/*
 * Decompiled with CFR 0.152.
 */
package pum.simuref.configuration.managers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import pum.simuref.configuration.core.Configuration;
import pum.simuref.configuration.core.Mapping;
import pum.simuref.configuration.managers.XMLProjectFileManager;

public class ConfigurationManager {
    private static LinkedList<Configuration> configurations;
    private static ConfigurationManager instance;

    private ConfigurationManager() {
        configurations = new LinkedList();
        System.out.println("MappingManager initialized!");
    }

    public static ConfigurationManager getInstance() {
        if (instance == null) {
            instance = new ConfigurationManager();
        }
        return instance;
    }

    public static void saveConfiguration(IProject project) {
        XMLProjectFileManager.saveConfiguratuon(ConfigurationManager.getConfiguration(project));
    }

    private static Configuration loadConfiguration(IProject project) {
        return XMLProjectFileManager.loadConfiguration(project);
    }

    public static void setConfiguration(IProject project, ArrayList<Mapping> modelToCode, ArrayList<String> mappedModels) {
        Configuration configuration = ConfigurationManager.getConfiguration(project);
        configuration.setMappedModelFiles(mappedModels);
        configuration.setMappingListModelFileToProject(modelToCode);
    }

    public static Configuration getConfiguration(IProject project) {
        Configuration configuration = null;
        if (!configurations.isEmpty()) {
            for (Configuration tempConfiguration : configurations) {
                if (!tempConfiguration.getProject().equals((Object)project)) continue;
                configuration = tempConfiguration;
            }
        }
        if (configuration == null) {
            configuration = ConfigurationManager.loadConfiguration(project);
        }
        if (configuration == null) {
            configuration = new Configuration(project);
        }
        configurations.add(configuration);
        return configuration;
    }

    public static List<String> getMappedModels(IProject project) {
        Configuration configuration = ConfigurationManager.getConfiguration(project);
        return configuration.getMappedModelFiles();
    }

    public static List<Mapping> getModelProjectMappings(IProject project) {
        Configuration configuration = ConfigurationManager.getConfiguration(project);
        return configuration.getMappingListModelFileToProject();
    }
}

