/*
 * Decompiled with CFR 0.152.
 */
package ilg.gnumcueclipse.debug.gdbjtag.memory;

import ilg.gnumcueclipse.core.EclipseUtils;
import ilg.gnumcueclipse.debug.gdbjtag.Activator;
import ilg.gnumcueclipse.debug.gdbjtag.datamodel.PeripheralDMContext;
import ilg.gnumcueclipse.debug.gdbjtag.memory.PeripheralMemoryBlockExtension;
import ilg.gnumcueclipse.debug.gdbjtag.memory.PeripheralMemoryBlockRetrieval;
import ilg.gnumcueclipse.debug.gdbjtag.ui.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class MemoryBlockMonitor {
    private static final MemoryBlockMonitor fgInstance = new MemoryBlockMonitor();

    public static MemoryBlockMonitor getInstance() {
        return fgInstance;
    }

    public MemoryBlockMonitor() {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("MemoryBlockMonitor()");
        }
    }

    public void displayPeripheralMonitor(IWorkbenchWindow workbenchWindow, PeripheralDMContext peripheralDMContext, boolean isChecked) {
        Object object;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("MemoryBlockMonitor.displayPeripheralMonitor(" + isChecked + ")");
        }
        if ((object = peripheralDMContext.getAdapter(PeripheralMemoryBlockRetrieval.class)) instanceof IMemoryBlockRetrieval) {
            IMemoryBlockRetrieval memoryBlockRetrieval = (IMemoryBlockRetrieval)object;
            if (isChecked) {
                this.addMemoryBlock(workbenchWindow, peripheralDMContext, memoryBlockRetrieval);
                this.showMemoryView(workbenchWindow);
            } else {
                this.removeMemoryBlock(workbenchWindow, peripheralDMContext);
            }
        }
    }

    public void savePeripheralNames(IMemoryBlock[] memoryBlocks) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("MemoryBlockMonitor.savePeripheralNames()");
        }
        int i = 0;
        while (i < memoryBlocks.length) {
            PeripheralMemoryBlockExtension memBlock;
            IMemoryBlockRetrieval memRetrieval;
            if (memoryBlocks[i] instanceof PeripheralMemoryBlockExtension && (memRetrieval = (memBlock = (PeripheralMemoryBlockExtension)memoryBlocks[i]).getMemoryBlockRetrieval()) instanceof PeripheralMemoryBlockRetrieval) {
                ((PeripheralMemoryBlockRetrieval)memRetrieval).saveMemoryBlocks();
                break;
            }
            ++i;
        }
    }

    public void addMemoryBlock(IWorkbenchWindow workbenchWindow, PeripheralDMContext peripheralDMContext, IMemoryBlockRetrieval memoryBlockRetrieval) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("MemoryBlockMonitor.addMemoryBlock() " + peripheralDMContext.getName());
        }
        String addr = peripheralDMContext.getPeripheralInstance().getHexAddress();
        try {
            if (memoryBlockRetrieval instanceof IMemoryBlockRetrievalExtension) {
                IMemoryBlockExtension memoryBlockToAdd = ((IMemoryBlockRetrievalExtension)memoryBlockRetrieval).getExtendedMemoryBlock(addr, (Object)peripheralDMContext);
                if (memoryBlockToAdd != null) {
                    DebugPlugin.getDefault().getMemoryBlockManager().addMemoryBlocks(new IMemoryBlock[]{memoryBlockToAdd});
                    this.addDefaultRenderings(workbenchWindow, (IMemoryBlock)memoryBlockToAdd, "ilg.gnumcueclipse.debug.gdbjtag.memoryRendering");
                } else {
                    EclipseUtils.openError((String)Messages.AddMemoryBlockAction_title, (String)Messages.AddMemoryBlockAction_noMemoryBlock, null);
                }
            } else {
                Activator.log((String)("Cannot process memory block retrieval " + memoryBlockRetrieval));
            }
        }
        catch (DebugException e) {
            EclipseUtils.openError((String)Messages.AddMemoryBlockAction_title, (String)Messages.AddMemoryBlockAction_failed, (Exception)((Object)e));
        }
        catch (NumberFormatException numberFormatException) {
            String msg = String.valueOf(Messages.AddMemoryBlockAction_failed) + "\n" + Messages.AddMemoryBlockAction_input_invalid;
            EclipseUtils.openError((String)Messages.AddMemoryBlockAction_title, (String)msg, null);
        }
    }

    private void removeMemoryBlock(IWorkbenchWindow workbenchWindow, PeripheralDMContext peripheralDMContext) {
        IMemoryBlock[] memoryBlocks;
        if (Activator.getInstance().isDebugging()) {
            System.out.println("MemoryBlockMonitor.removeMemoryBlock() " + peripheralDMContext.getName());
        }
        IMemoryBlock[] iMemoryBlockArray = memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks();
        int n = memoryBlocks.length;
        int n2 = 0;
        while (n2 < n) {
            IMemoryBlock memoryBlock = iMemoryBlockArray[n2];
            if (memoryBlock instanceof PeripheralMemoryBlockExtension) {
                String expression = ((PeripheralMemoryBlockExtension)memoryBlock).getExpression();
                if (expression.equals(peripheralDMContext.getPeripheralInstance().getDisplayName())) {
                    DebugPlugin.getDefault().getMemoryBlockManager().removeMemoryBlocks(new IMemoryBlock[]{memoryBlock});
                }
            } else {
                Activator.log((String)("Cannot process memory block " + memoryBlock));
            }
            ++n2;
        }
    }

    public void removeMemoryBlocks(IMemoryBlock[] memoryBlocks) {
        DebugPlugin.getDefault().getMemoryBlockManager().removeMemoryBlocks(memoryBlocks);
    }

    private void addDefaultRenderings(IWorkbenchWindow workbenchWindow, IMemoryBlock memoryBlock, String renderingId) {
        if (renderingId == null) {
            renderingId = "";
        }
        IMemoryRenderingType type = null;
        IMemoryRenderingType primaryType = DebugUITools.getMemoryRenderingManager().getPrimaryRenderingType(memoryBlock);
        if (primaryType != null && renderingId.equals(primaryType.getId())) {
            type = primaryType;
        }
        if (type == null) {
            IMemoryRenderingType[] defaultTypes;
            IMemoryRenderingType[] iMemoryRenderingTypeArray = defaultTypes = DebugUITools.getMemoryRenderingManager().getDefaultRenderingTypes(memoryBlock);
            int n = defaultTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IMemoryRenderingType defaultType = iMemoryRenderingTypeArray[n2];
                if (Activator.getInstance().isDebugging()) {
                    System.out.println("addDefaultRenderings() " + defaultType.getId());
                }
                type = defaultType;
                if (renderingId.equals(defaultType.getId())) break;
                ++n2;
            }
        }
        try {
            if (type != null) {
                this.createRenderingInContainer(workbenchWindow, memoryBlock, type, "org.eclipse.debug.ui.MemoryView.RenderingViewPane.1");
            }
        }
        catch (CoreException e) {
            Activator.log((Throwable)e);
        }
    }

    private void createRenderingInContainer(IWorkbenchWindow workbenchWindow, IMemoryBlock memoryBlock, IMemoryRenderingType memoryRenderingType, String paneId) throws CoreException {
        IMemoryRenderingSite site;
        if (Activator.getInstance().isDebugging()) {
            System.out.println(String.format("MemoryBlockMonitor.createRenderingInContainer() 0x%X", memoryBlock.getStartAddress()));
        }
        if ((site = this.getRenderingSite(workbenchWindow)) != null) {
            IMemoryRenderingContainer container = site.getContainer(paneId);
            IMemoryRendering rendering = memoryRenderingType.createRendering();
            if (rendering != null) {
                rendering.init(container, memoryBlock);
                container.addMemoryRendering(rendering);
            }
        }
    }

    private IMemoryRenderingSite getRenderingSite(IWorkbenchWindow workbenchWindow) {
        if (workbenchWindow != null) {
            IViewPart viewPart = workbenchWindow.getActivePage().findView("org.eclipse.debug.ui.MemoryView");
            return (IMemoryRenderingSite)viewPart;
        }
        return null;
    }

    public void showMemoryView(final IWorkbenchWindow workbenchWindow) {
        if (Activator.getInstance().isDebugging()) {
            System.out.println("showView(MemoryView)");
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    workbenchWindow.getActivePage().showView("org.eclipse.debug.ui.MemoryView");
                    if (Activator.getInstance().isDebugging()) {
                        System.out.println("showView(MemoryView) done");
                    }
                }
                catch (PartInitException e) {
                    Activator.log((Throwable)e);
                }
            }
        });
    }
}

