/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.liqp.nodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.embedcdt.core.liqp.TemplateContext;
import org.eclipse.embedcdt.core.liqp.nodes.LNode;
import org.eclipse.embedcdt.core.liqp.tags.Tag;

public class BlockNode
implements LNode {
    private List<LNode> children = new ArrayList<LNode>();
    private final boolean isRootBlock;

    public BlockNode() {
        this(false);
    }

    public BlockNode(boolean isRootBlock) {
        this.isRootBlock = isRootBlock;
    }

    public void add(LNode node) {
        this.children.add(node);
    }

    public List<LNode> getChildren() {
        return new ArrayList<LNode>(this.children);
    }

    @Override
    public Object render(TemplateContext context) {
        StringBuilder builder = new StringBuilder();
        for (LNode node : this.children) {
            Object value = node.render(context);
            if (value == null) continue;
            if (value == Tag.Statement.BREAK || value == Tag.Statement.CONTINUE) {
                return value;
            }
            if (value.getClass().isArray()) {
                Object[] array;
                Object[] objectArray = array = (Object[])value;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    builder.append(String.valueOf(obj));
                    ++n2;
                }
            } else {
                builder.append(String.valueOf(value));
            }
            if (builder.length() <= context.protectionSettings.maxSizeRenderedString) continue;
            throw new RuntimeException("rendered string exceeds " + context.protectionSettings.maxSizeRenderedString);
        }
        return builder.toString();
    }
}

