/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore.p3execution;

import org.eclipse.elk.alg.common.Tree;
import org.eclipse.elk.alg.common.spore.InternalProperties;
import org.eclipse.elk.alg.common.spore.Node;
import org.eclipse.elk.alg.common.utils.SVGImage;
import org.eclipse.elk.alg.common.utils.Utils;
import org.eclipse.elk.alg.spore.SPOrEPhases;
import org.eclipse.elk.alg.spore.graph.Graph;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class GrowTreePhase
implements ILayoutPhase<SPOrEPhases, Graph> {
    private SVGImage svg;
    private Tree<Node> root;
    private boolean overlapsExisted;

    public LayoutProcessorConfiguration<SPOrEPhases, Graph> getLayoutProcessorConfiguration(Graph graph) {
        return LayoutProcessorConfiguration.create();
    }

    public void process(Graph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Grow Tree", 1.0f);
        this.root = graph.tree;
        if (((Boolean)graph.getProperty(InternalProperties.DEBUG_SVG)).booleanValue()) {
            this.svg = new SVGImage(String.valueOf(ElkUtil.debugFolderPath((String)"spore")) + "40or");
            this.svg.addGroups(new String[]{"n", "e", "o"});
            this.debugOut();
        } else {
            this.svg = new SVGImage(null);
        }
        this.overlapsExisted = false;
        this.growAt(graph.tree);
        graph.setProperty(InternalProperties.OVERLAPS_EXISTED, this.overlapsExisted);
        progressMonitor.done();
    }

    private void growAt(Tree<Node> r) {
        for (Tree c : r.children) {
            ((Node)c.node).translate(((Node)r.node).vertex.clone().sub(((Node)r.node).originalVertex));
            double t = Utils.overlap((ElkRectangle)((Node)r.node).rect, (ElkRectangle)((Node)c.node).rect);
            if (t > 1.0) {
                this.overlapsExisted = true;
            }
            ((Node)c.node).setCenterPosition(((Node)r.node).vertex.clone().add(((Node)c.node).originalVertex.clone().sub(((Node)r.node).originalVertex).scale(t)));
            this.debugOut(r);
            this.growAt((Tree<Node>)c);
        }
    }

    private void debugOut() {
        this.debugOut(null);
    }

    private void debugOut(Tree<Node> c) {
        this.svg.clearGroup("n");
        this.svg.clearGroup("e");
        this.svg.clearGroup("o");
        this.drawTree(this.root, this.svg);
        this.svg.g("n").addRect(((Node)this.root.node).rect, "fill=\"blue\" stroke=\"none\" opacity=\"0.2\"");
        if (c != null) {
            this.svg.g("o").addRect(((Node)c.node).rect, "fill=\"red\" stroke=\"none\" opacity=\"0.2\"");
        }
        this.svg.isave();
    }

    private void drawTree(Tree<Node> t, SVGImage img) {
        img.g("n").addRect(((Node)t.node).rect, "fill=\"none\" stroke=\"black\"");
        t.children.forEach(c -> {
            img.g("e").addLine(((Node)tree.node).vertex.x, ((Node)tree.node).vertex.y, ((Node)c.node).vertex.x, ((Node)c.node).vertex.y, "stroke=\"blue\"");
            this.drawTree((Tree<Node>)c, img);
        });
    }
}

