/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.graph;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphElement;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.PortType;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.EdgeLabelPlacement;
import org.eclipse.elk.core.options.PortSide;

public final class LEdge
extends LGraphElement {
    private static final long serialVersionUID = 1429497419118554817L;
    private KVectorChain bendPoints = new KVectorChain();
    private LPort source;
    private LPort target;
    private final List<LLabel> labels = Lists.newArrayListWithCapacity((int)3);

    public String toString() {
        if (this.source != null && this.target != null) {
            return (Object)((Object)this.source.getNode()) + "(" + (Object)((Object)this.source) + ")->" + (Object)((Object)this.target.getNode()) + "(" + (Object)((Object)this.target) + ")";
        }
        return "e_" + ((Object)((Object)this)).hashCode();
    }

    public void reverse(LGraph layeredGraph, boolean adaptPorts) {
        LPort oldSource = this.getSource();
        LPort oldTarget = this.getTarget();
        this.setSource(null);
        this.setTarget(null);
        if (adaptPorts && ((Boolean)oldTarget.getProperty(InternalProperties.INPUT_COLLECT)).booleanValue()) {
            this.setSource(LGraphUtil.provideCollectorPort(layeredGraph, oldTarget.getNode(), PortType.OUTPUT, PortSide.EAST));
        } else {
            this.setSource(oldTarget);
        }
        if (adaptPorts && ((Boolean)oldSource.getProperty(InternalProperties.OUTPUT_COLLECT)).booleanValue()) {
            this.setTarget(LGraphUtil.provideCollectorPort(layeredGraph, oldSource.getNode(), PortType.INPUT, PortSide.WEST));
        } else {
            this.setTarget(oldSource);
        }
        for (LLabel label : this.labels) {
            EdgeLabelPlacement labelPlacement = (EdgeLabelPlacement)label.getProperty(LayeredOptions.EDGE_LABELS_PLACEMENT);
            if (labelPlacement == EdgeLabelPlacement.TAIL) {
                label.setProperty(LayeredOptions.EDGE_LABELS_PLACEMENT, EdgeLabelPlacement.HEAD);
                continue;
            }
            if (labelPlacement != EdgeLabelPlacement.HEAD) continue;
            label.setProperty(LayeredOptions.EDGE_LABELS_PLACEMENT, EdgeLabelPlacement.TAIL);
        }
        boolean reversed = (Boolean)this.getProperty(InternalProperties.REVERSED);
        this.setProperty(InternalProperties.REVERSED, !reversed);
        this.bendPoints = KVectorChain.reverse((KVectorChain)this.bendPoints);
    }

    public LPort getSource() {
        return this.source;
    }

    public void setSource(LPort source) {
        if (this.source != null) {
            this.source.getOutgoingEdges().remove((Object)this);
        }
        this.source = source;
        if (this.source != null) {
            this.source.getOutgoingEdges().add(this);
        }
    }

    public LPort getTarget() {
        return this.target;
    }

    public void setTarget(LPort target) {
        if (this.target != null) {
            this.target.getIncomingEdges().remove((Object)this);
        }
        this.target = target;
        if (this.target != null) {
            this.target.getIncomingEdges().add(this);
        }
    }

    public void setTargetAndInsertAtIndex(LPort targetPort, int index) {
        if (this.target != null) {
            this.target.getIncomingEdges().remove((Object)this);
        }
        this.target = targetPort;
        if (this.target != null) {
            this.target.getIncomingEdges().add(index, this);
        }
    }

    public boolean isSelfLoop() {
        if (this.source == null || this.target == null) {
            return false;
        }
        return this.source.getNode() != null && this.source.getNode() == this.target.getNode();
    }

    public boolean isInLayerEdge() {
        return !this.isSelfLoop() && this.source.getNode().getLayer() == this.target.getNode().getLayer();
    }

    public KVectorChain getBendPoints() {
        return this.bendPoints;
    }

    public List<LLabel> getLabels() {
        return this.labels;
    }

    public LPort getOther(LPort port) {
        if (port == this.source) {
            return this.target;
        }
        if (port == this.target) {
            return this.source;
        }
        throw new IllegalArgumentException("'port' must be either the source port or target port of the edge.");
    }

    public LNode getOther(LNode node) {
        if (node == this.source.getNode()) {
            return this.target.getNode();
        }
        if (node == this.target.getNode()) {
            return this.source.getNode();
        }
        throw new IllegalArgumentException("'node' must either be the source node or target node of the edge.");
    }
}

