/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.rendering;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class GraphRenderingConfigurator {
    protected static final int NODE_FONT_SIZE = 9;
    protected static final int PORT_FONT_SIZE = 6;
    protected static final int EDGE_FONT_SIZE = 8;
    protected static final int MIN_FONT_HEIGHT = 3;
    protected Color nodeBorderColor;
    protected Color nodeFillColor;
    protected Font nodeLabelFont;
    private int nodeFontSize;
    protected Color portBorderColor;
    protected Color portFillColor;
    protected Font portLabelFont;
    private int portFontSize;
    protected Color edgeColor;
    protected Font edgeLabelFont;
    private int edgeFontSize;
    protected Color labelBorderColor;
    protected Color labelFillColor;
    protected Color labelTextColor;
    protected Color outOfBoundsColor;
    protected Color rootNodeColor;
    private Display display;

    public GraphRenderingConfigurator(Display display) {
        this.display = display;
        this.initialize();
    }

    public final Display getDisplay() {
        return this.display;
    }

    protected void initialize() {
        this.nodeLabelFont = new Font((Device)this.display, "sans", 9, 0);
        this.nodeBorderColor = new Color((Device)this.display, 2, 15, 3);
        this.nodeFillColor = new Color((Device)this.display, 168, 220, 190);
        this.portLabelFont = new Font((Device)this.display, "sans", 6, 0);
        this.portBorderColor = new Color((Device)this.display, 2, 9, 40);
        this.portFillColor = new Color((Device)this.display, 2, 9, 40);
        this.edgeLabelFont = new Font((Device)this.display, "sans", 8, 0);
        this.edgeColor = new Color((Device)this.display, 23, 36, 54);
        this.labelBorderColor = new Color((Device)this.display, 63, 117, 67);
        this.labelFillColor = null;
        this.labelTextColor = new Color((Device)this.display, 2, 15, 3);
        this.outOfBoundsColor = new Color((Device)this.display, 255, 205, 210);
        this.rootNodeColor = new Color((Device)this.display, 240, 240, 240);
    }

    public final void dispose() {
        if (this.nodeBorderColor != null) {
            this.nodeBorderColor.dispose();
        }
        if (this.nodeFillColor != null) {
            this.nodeFillColor.dispose();
        }
        if (this.nodeLabelFont != null) {
            this.nodeLabelFont.dispose();
        }
        if (this.labelBorderColor != null) {
            this.labelBorderColor.dispose();
        }
        if (this.labelTextColor != null) {
            this.labelTextColor.dispose();
        }
        if (this.portBorderColor != null) {
            this.portBorderColor.dispose();
        }
        if (this.portFillColor != null) {
            this.portFillColor.dispose();
        }
        if (this.portLabelFont != null) {
            this.portLabelFont.dispose();
        }
        if (this.edgeColor != null) {
            this.edgeColor.dispose();
        }
        if (this.edgeLabelFont != null) {
            this.edgeLabelFont.dispose();
        }
        if (this.outOfBoundsColor != null) {
            this.outOfBoundsColor.dispose();
        }
        if (this.rootNodeColor != null) {
            this.rootNodeColor.dispose();
        }
    }

    public void setScale(double scale) {
        int newEdgeFontSize;
        int newPortFontSize;
        int newNodeFontSize = Math.max((int)Math.round(9.0 * scale), 2);
        if (newNodeFontSize != this.nodeFontSize) {
            if (this.nodeLabelFont != null) {
                this.nodeLabelFont.dispose();
            }
            this.nodeLabelFont = new Font((Device)this.display, "sans", newNodeFontSize, 0);
            this.nodeFontSize = newNodeFontSize;
        }
        if ((newPortFontSize = Math.max((int)Math.round(6.0 * scale), 2)) != this.portFontSize) {
            if (this.portLabelFont != null) {
                this.portLabelFont.dispose();
            }
            this.portLabelFont = new Font((Device)this.display, "sans", newPortFontSize, 0);
            this.portFontSize = newPortFontSize;
        }
        if ((newEdgeFontSize = Math.max((int)Math.round(8.0 * scale), 2)) != this.edgeFontSize) {
            if (this.edgeLabelFont != null) {
                this.edgeLabelFont.dispose();
            }
            this.edgeLabelFont = new Font((Device)this.display, "sans", newEdgeFontSize, 0);
            this.edgeFontSize = newEdgeFontSize;
        }
    }

    public final Color getNodeBorderColor() {
        return this.nodeBorderColor;
    }

    public final Color getNodeFillColor() {
        return this.nodeFillColor;
    }

    public final Font getNodeLabelFont() {
        return this.nodeLabelFont;
    }

    public final Color getPortBorderColor() {
        return this.portBorderColor;
    }

    public final Color getPortFillColor() {
        return this.portFillColor;
    }

    public final Font getPortLabelFont() {
        return this.portLabelFont;
    }

    public final Color getEdgeColor() {
        return this.edgeColor;
    }

    public final Font getEdgeLabelFont() {
        return this.edgeLabelFont;
    }

    public final Color getLabelBorderColor() {
        return this.labelBorderColor;
    }

    public final Color getLabelFillColor() {
        return this.labelFillColor;
    }

    public final Color getLabelTextColor() {
        return this.labelTextColor;
    }

    public final Color getOutOfBoundsColor() {
        return this.outOfBoundsColor;
    }

    public final Color getRootNodeColor() {
        return this.rootNodeColor;
    }
}

