/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.core.comments.AggregatedHeuristicsAttachmentDecider;
import org.eclipse.elk.core.comments.IAttachmentDecider;
import org.eclipse.elk.core.comments.IAttachmentTargetProvider;
import org.eclipse.elk.core.comments.IBoundsProvider;
import org.eclipse.elk.core.comments.IEligibilityFilter;
import org.eclipse.elk.core.comments.IExplicitAttachmentProvider;
import org.eclipse.elk.core.comments.IHeuristic;
import org.eclipse.elk.core.comments.ShapeLayoutBoundsProvider;
import org.eclipse.elk.core.comments.SiblingAttachmentTargetProvider;
import org.eclipse.elk.core.klayoutdata.KLayoutData;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.KNode;

public final class CommentAttacher {
    private boolean includeHierarchy = true;
    private boolean explicitAttachmentsDisableHeuristics = true;
    private IExplicitAttachmentProvider explicitAttachmentProvider = a -> null;
    private IBoundsProvider boundsProvider = new ShapeLayoutBoundsProvider();
    private IAttachmentTargetProvider targetProvider = new SiblingAttachmentTargetProvider();
    private List<IEligibilityFilter> eligibilityFilters = Lists.newArrayList();
    private List<IHeuristic> heuristics = Lists.newArrayList();
    private IAttachmentDecider attachmentDecider = new AggregatedHeuristicsAttachmentDecider();

    public CommentAttacher limitToCurrentHierarchyLevel() {
        this.includeHierarchy = false;
        return this;
    }

    public CommentAttacher keepHeuristicsEnabledWithExplicitAttachments() {
        this.explicitAttachmentsDisableHeuristics = false;
        return this;
    }

    public CommentAttacher withExplicitAttachmentProvider(IExplicitAttachmentProvider provider) {
        this.explicitAttachmentProvider = provider == null ? a -> null : provider;
        return this;
    }

    public CommentAttacher withBoundsProvider(IBoundsProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("The bounds provider must not be null.");
        }
        this.boundsProvider = provider;
        return this;
    }

    public CommentAttacher withAttachmentTargetProvider(IAttachmentTargetProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("The attachment target provider must not be null.");
        }
        this.targetProvider = provider;
        return this;
    }

    public CommentAttacher addEligibilityFilter(IEligibilityFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("The eligibility filter must not be null.");
        }
        this.eligibilityFilters.add(filter);
        return this;
    }

    public CommentAttacher addHeuristic(IHeuristic heuristic) {
        if (heuristic == null) {
            throw new IllegalArgumentException("The attachment heuristic must not be null.");
        }
        this.heuristics.add(heuristic);
        return this;
    }

    public CommentAttacher withAttachmentDecider(IAttachmentDecider decider) {
        if (decider == null) {
            throw new IllegalArgumentException("The attachment target provider must not be null.");
        }
        this.attachmentDecider = decider;
        return this;
    }

    public Collection<KEdge> attachComments(KNode graph) {
        this.preprocess(graph);
        ArrayList explicitAttachments = Lists.newArrayList();
        ArrayList heuristicAttachments = Lists.newArrayList();
        LinkedList processingQueue = Lists.newLinkedList((Iterable)graph.getChildren());
        while (!processingQueue.isEmpty()) {
            KNode node = (KNode)processingQueue.poll();
            if (CommentAttacher.isComment(node)) {
                KGraphElement heuristicAttachment;
                KGraphElement explicitAttachment = this.explicitAttachmentProvider.findExplicitAttachment(node);
                if (explicitAttachment != null) {
                    explicitAttachments.add(Pair.of(node, explicitAttachment));
                } else if ((explicitAttachments.isEmpty() || !this.explicitAttachmentsDisableHeuristics) && this.isEligibleForHeuristicAttachment(node) && (heuristicAttachment = this.findHeuristicAttachment(node)) != null) {
                    heuristicAttachments.add(Pair.of(node, heuristicAttachment));
                }
            }
            if (!this.includeHierarchy) continue;
            processingQueue.addAll(node.getChildren());
        }
        this.cleanup();
        Collection<KEdge> createdEdges = this.edgeifyFoundAttachments(explicitAttachments, heuristicAttachments);
        return createdEdges;
    }

    private void preprocess(KNode graph) {
        this.explicitAttachmentProvider.preprocess(graph, this.includeHierarchy);
        this.boundsProvider.preprocess(graph, this.includeHierarchy);
        this.targetProvider.preprocess(graph, this.includeHierarchy);
        this.eligibilityFilters.stream().forEach(f -> f.preprocess(graph, this.includeHierarchy));
        this.heuristics.stream().forEach(h -> h.preprocess(graph, this.includeHierarchy));
    }

    private boolean isEligibleForHeuristicAttachment(KNode comment) {
        return this.eligibilityFilters.stream().allMatch(f -> f.eligibleForAttachment(comment));
    }

    private KGraphElement findHeuristicAttachment(KNode comment) {
        if (this.heuristics.isEmpty()) {
            return null;
        }
        List<KGraphElement> candidates = this.targetProvider.provideAttachmentTargetsFor(comment);
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        HashMap results = Maps.newHashMap();
        for (KGraphElement candidate : candidates) {
            HashMap candidateResults = Maps.newHashMap();
            results.put(candidate, candidateResults);
            for (IHeuristic heuristic : this.heuristics) {
                candidateResults.put(heuristic.getClass(), heuristic.normalized(comment, candidate));
            }
        }
        return this.attachmentDecider.makeAttachmentDecision(results);
    }

    private Collection<KEdge> edgeifyFoundAttachments(Collection<Pair<KNode, KGraphElement>> explicitAttachments, Collection<Pair<KNode, KGraphElement>> heuristicAttachments) {
        ArrayList createdEdges = Lists.newArrayListWithCapacity((int)(explicitAttachments.size() + heuristicAttachments.size()));
        createdEdges.addAll(this.edgeifyFoundAttachments(explicitAttachments));
        if (explicitAttachments.isEmpty() || !this.explicitAttachmentsDisableHeuristics) {
            createdEdges.addAll(this.edgeifyFoundAttachments(heuristicAttachments));
        }
        return createdEdges;
    }

    private Collection<KEdge> edgeifyFoundAttachments(Collection<Pair<KNode, KGraphElement>> attachments) {
        ArrayList createdEdges = Lists.newArrayListWithCapacity((int)attachments.size());
        for (Pair<KNode, KGraphElement> attachment : attachments) {
            if (!(attachment.getSecond() instanceof KNode)) continue;
            KNode comment = attachment.getFirst();
            KNode target = (KNode)attachment.getSecond();
            KEdge edge = ElkUtil.createInitializedEdge();
            edge.setSource(comment);
            edge.setTarget(target);
            createdEdges.add(edge);
        }
        return createdEdges;
    }

    private void cleanup() {
        this.explicitAttachmentProvider.cleanup();
        this.boundsProvider.cleanup();
        this.targetProvider.cleanup();
        this.eligibilityFilters.stream().forEach(f -> f.cleanup());
        this.heuristics.stream().forEach(h -> h.cleanup());
    }

    public static boolean isComment(KNode node) {
        KLayoutData layoutData = (KLayoutData)node.getData(KLayoutData.class);
        return (Boolean)layoutData.getProperty(CoreOptions.COMMENT_BOX);
    }
}

