/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.elk.core.GraphIssue;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.klayoutdata.KEdgeLayout;
import org.eclipse.elk.core.klayoutdata.KLayoutData;
import org.eclipse.elk.core.klayoutdata.KShapeLayout;
import org.eclipse.elk.core.util.IValidatingGraphElementVisitor;
import org.eclipse.elk.graph.KEdge;
import org.eclipse.elk.graph.KGraphElement;
import org.eclipse.elk.graph.properties.IProperty;

public class LayoutOptionValidator
implements IValidatingGraphElementVisitor {
    private final List<GraphIssue> issues = new ArrayList<GraphIssue>();

    @Override
    public void visit(KGraphElement element) {
        KLayoutData layoutData = element instanceof KEdge ? (KLayoutData)element.getData(KEdgeLayout.class) : (KLayoutData)element.getData(KShapeLayout.class);
        for (Map.Entry entry : layoutData.getProperties()) {
            this.issues.addAll(this.checkProperty((IProperty<Object>)((IProperty)entry.getKey()), entry.getValue(), element));
        }
    }

    public List<GraphIssue> checkProperty(IProperty<Object> property, Object value, KGraphElement element) {
        String optionName = null;
        if (property instanceof LayoutOptionData) {
            LayoutOptionData optionData = (LayoutOptionData)property;
            optionName = optionData.getName();
            if (value != null && !this.isValidType(optionData, value)) {
                String message = "The assigned value " + value.toString() + " of the option '" + optionName + "' does not match the type " + optionData.getOptionClass().getSimpleName() + ".";
                return Collections.singletonList(new GraphIssue(element, message, GraphIssue.Severity.ERROR));
            }
        }
        if (value != null) {
            String message;
            if (property.getLowerBound().compareTo(value) > 0) {
                if (optionName == null) {
                    optionName = property.getId();
                }
                message = "The assigned value " + value.toString() + " of the option '" + optionName + "' is less than the lower bound " + property.getLowerBound().toString() + ".";
                return Collections.singletonList(new GraphIssue(element, message, GraphIssue.Severity.ERROR));
            }
            if (property.getUpperBound().compareTo(value) < 0) {
                if (optionName == null) {
                    optionName = property.getId();
                }
                message = "The assigned value " + value.toString() + " of the option '" + optionName + "' is greater than the upper bound " + property.getUpperBound().toString() + ".";
                return Collections.singletonList(new GraphIssue(element, message, GraphIssue.Severity.ERROR));
            }
        }
        return Collections.emptyList();
    }

    protected boolean isValidType(LayoutOptionData optionData, Object value) {
        switch (optionData.getType()) {
            case STRING: {
                return value instanceof String;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case INT: {
                return value instanceof Integer;
            }
            case FLOAT: {
                return value instanceof Float;
            }
            case ENUMSET: {
                return value instanceof EnumSet;
            }
        }
        return optionData.getOptionClass().isInstance(value);
    }

    public List<GraphIssue> getIssues() {
        return this.issues;
    }
}

