/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.ui.preferences;

import org.eclipse.elk.core.service.ElkServicePlugin;
import org.eclipse.elk.core.ui.ElkUiPlugin;
import org.eclipse.elk.core.ui.Messages;
import org.eclipse.elk.core.ui.views.LayoutViewPart;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LayoutPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button animationCheckBox;
    private Button zoomCheckBox;
    private Button progressCheckBox;
    private Button debugCheckBox;
    private Button execTimeCheckBox;
    private static final int VERTICAL_LAYOUT_SPACING = 10;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 5;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, false);
        compositeLayout.verticalSpacing = 10;
        composite.setLayout((Layout)compositeLayout);
        Group generalGroup = this.createGeneralOptionsGroup(composite);
        generalGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        Group devOptionsGroup = this.createDeveloperOptionsGroup(composite);
        devOptionsGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        return composite;
    }

    private Group createGeneralOptionsGroup(Composite parent) {
        IPreferenceStore mainPrefStore = this.getPreferenceStore();
        Group generalGroup = new Group(parent, 0);
        generalGroup.setText(Messages.getString("kiml.ui.35"));
        this.animationCheckBox = new Button((Composite)generalGroup, 16416);
        this.animationCheckBox.setText(Messages.getString("kiml.ui.64"));
        this.animationCheckBox.setToolTipText(Messages.getString("kiml.ui.67"));
        this.animationCheckBox.setSelection(mainPrefStore.getBoolean("org.eclipse.elk.animation"));
        this.zoomCheckBox = new Button((Composite)generalGroup, 16416);
        this.zoomCheckBox.setText(Messages.getString("kiml.ui.65"));
        this.zoomCheckBox.setToolTipText(Messages.getString("kiml.ui.68"));
        this.zoomCheckBox.setSelection(mainPrefStore.getBoolean("org.eclipse.elk.zoomToFit"));
        this.progressCheckBox = new Button((Composite)generalGroup, 16416);
        this.progressCheckBox.setText(Messages.getString("kiml.ui.66"));
        this.progressCheckBox.setToolTipText(Messages.getString("kiml.ui.69"));
        this.progressCheckBox.setSelection(mainPrefStore.getBoolean("org.eclipse.elk.progressDialog"));
        FillLayout layout = new FillLayout(512);
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.spacing = LayoutConstants.getSpacing().y;
        generalGroup.setLayout((Layout)layout);
        return generalGroup;
    }

    private Group createDeveloperOptionsGroup(Composite parent) {
        IPreferenceStore servicePrefStore = ElkServicePlugin.getInstance().getPreferenceStore();
        Group developerGroup = new Group(parent, 0);
        developerGroup.setText(Messages.getString("kiml.ui.81"));
        this.execTimeCheckBox = new Button((Composite)developerGroup, 16416);
        this.execTimeCheckBox.setText(Messages.getString("kiml.ui.79"));
        this.execTimeCheckBox.setToolTipText(Messages.getString("kiml.ui.80"));
        this.execTimeCheckBox.setSelection(servicePrefStore.getBoolean("elk.exectime.measure"));
        this.debugCheckBox = new Button((Composite)developerGroup, 16416);
        this.debugCheckBox.setText(Messages.getString("kiml.ui.71"));
        this.debugCheckBox.setToolTipText(Messages.getString("kiml.ui.72"));
        this.debugCheckBox.setSelection(servicePrefStore.getBoolean("elk.debug.graph"));
        FillLayout layout = new FillLayout(512);
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        layout.spacing = LayoutConstants.getSpacing().y;
        developerGroup.setLayout((Layout)layout);
        return developerGroup;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ElkUiPlugin.getInstance().getPreferenceStore());
    }

    protected void performDefaults() {
        super.performDefaults();
        IPreferenceStore mainPrefStore = this.getPreferenceStore();
        IPreferenceStore servicePrefStore = ElkServicePlugin.getInstance().getPreferenceStore();
        this.animationCheckBox.setSelection(mainPrefStore.getDefaultBoolean("org.eclipse.elk.animation"));
        this.zoomCheckBox.setSelection(mainPrefStore.getDefaultBoolean("org.eclipse.elk.zoomToFit"));
        this.progressCheckBox.setSelection(mainPrefStore.getDefaultBoolean("org.eclipse.elk.progressDialog"));
        this.debugCheckBox.setSelection(servicePrefStore.getDefaultBoolean("elk.debug.graph"));
        this.execTimeCheckBox.setSelection(servicePrefStore.getDefaultBoolean("elk.exectime.measure"));
    }

    public boolean performOk() {
        IPreferenceStore mainPrefStore = this.getPreferenceStore();
        IPreferenceStore servicePrefStore = ElkServicePlugin.getInstance().getPreferenceStore();
        mainPrefStore.setValue("org.eclipse.elk.animation", this.animationCheckBox.getSelection());
        mainPrefStore.setValue("org.eclipse.elk.zoomToFit", this.zoomCheckBox.getSelection());
        mainPrefStore.setValue("org.eclipse.elk.progressDialog", this.progressCheckBox.getSelection());
        servicePrefStore.setValue("elk.debug.graph", this.debugCheckBox.getSelection());
        servicePrefStore.setValue("elk.exectime.measure", this.execTimeCheckBox.getSelection());
        LayoutViewPart layoutView = LayoutViewPart.findView();
        if (layoutView != null) {
            layoutView.refresh();
        }
        return true;
    }
}

