/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import org.eclipse.elk.alg.layered.ILayoutPhase;
import org.eclipse.elk.alg.layered.IntermediateProcessingConfiguration;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.p3order.AbstractPortDistributor;
import org.eclipse.elk.alg.layered.p3order.BarycenterHeuristic;
import org.eclipse.elk.alg.layered.p3order.ICrossingMinimizationHeuristic;
import org.eclipse.elk.alg.layered.p3order.LayerTotalPortDistributor;
import org.eclipse.elk.alg.layered.p3order.NodeRelativePortDistributor;
import org.eclipse.elk.alg.layered.p3order.constraints.ForsterConstraintResolver;
import org.eclipse.elk.alg.layered.p3order.counting.AbstractCrossingsCounter;
import org.eclipse.elk.alg.layered.p3order.counting.BarthJuengerMutzelCrossingsCounter;
import org.eclipse.elk.alg.layered.p3order.counting.HyperedgeCrossingsCounter;
import org.eclipse.elk.alg.layered.properties.GraphProperties;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.alg.layered.properties.PortType;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class LayerSweepCrossingMinimizer
implements ILayoutPhase {
    private static final IntermediateProcessingConfiguration INTERMEDIATE_PROCESSING_CONFIGURATION = IntermediateProcessingConfiguration.createEmpty().addBeforePhase3(IntermediateProcessorStrategy.LONG_EDGE_SPLITTER).addBeforePhase4(IntermediateProcessorStrategy.PORT_DISTRIBUTER).addBeforePhase4(IntermediateProcessorStrategy.GREEDY_SWITCH).addBeforePhase4(IntermediateProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR).addAfterPhase5(IntermediateProcessorStrategy.LONG_EDGE_JOINER);
    private float[] portRanks;
    private LNode[][] bestSweep;
    private LNode[][] curSweep;
    private LNode[][] prevSweep;
    private BarthJuengerMutzelCrossingsCounter normalCrossingsCounter;
    private HyperedgeCrossingsCounter hyperedgeCrossingsCounter;
    private AbstractCrossingsCounter inlayerCrossingsCounter;
    private boolean[] hasHyperedgesEast;
    private boolean[] hasHyperedgesWest;
    private final Multimap<LNode, LNode> layoutUnits = LinkedListMultimap.create();

    @Override
    public IntermediateProcessingConfiguration getIntermediateProcessingConfiguration(LGraph graph) {
        IntermediateProcessingConfiguration configuration = IntermediateProcessingConfiguration.fromExisting(INTERMEDIATE_PROCESSING_CONFIGURATION);
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.NON_FREE_PORTS)) {
            configuration.addBeforePhase3(IntermediateProcessorStrategy.PORT_LIST_SORTER);
        }
        return configuration;
    }

    private void initialize(LGraph layeredGraph) {
        int layerCount = layeredGraph.getLayers().size();
        this.bestSweep = new LNode[layerCount][];
        this.curSweep = new LNode[layerCount][];
        this.prevSweep = new LNode[layerCount][];
        int[] inLayerEdgeCount = new int[layerCount];
        boolean[] hasNorthSouthPorts = new boolean[layerCount];
        this.hasHyperedgesEast = new boolean[layerCount];
        this.hasHyperedgesWest = new boolean[layerCount];
        int nodeCount = 0;
        int portCount = 0;
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            int layerIndex = layerIter.previousIndex();
            int layerNodeCount = layer.getNodes().size();
            assert (layerNodeCount > 0);
            this.bestSweep[layerIndex] = new LNode[layerNodeCount];
            this.prevSweep[layerIndex] = new LNode[layerNodeCount];
            this.curSweep[layerIndex] = new LNode[layerNodeCount];
            inLayerEdgeCount[layerIndex] = 0;
            hasNorthSouthPorts[layerIndex] = false;
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            while (nodeIter.hasNext()) {
                LNode node;
                this.curSweep[layerIndex][nodeIter.previousIndex()] = node = nodeIter.next();
                node.id = nodeCount++;
                LNode layoutUnit = (LNode)((Object)node.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT));
                if (layoutUnit != null) {
                    this.layoutUnits.put((Object)layoutUnit, (Object)node);
                }
                for (LPort port : node.getPorts()) {
                    port.id = portCount++;
                    for (LEdge edge : port.getOutgoingEdges()) {
                        if (edge.getTarget().getNode().getLayer() != layer) continue;
                        int n = layerIndex;
                        inLayerEdgeCount[n] = inLayerEdgeCount[n] + 1;
                    }
                    if (port.getSide() == PortSide.EAST) {
                        if (port.getOutgoingEdges().size() + port.getIncomingEdges().size() <= 1) continue;
                        this.hasHyperedgesEast[layerIndex] = true;
                        continue;
                    }
                    if (port.getSide() == PortSide.WEST) {
                        if (port.getOutgoingEdges().size() + port.getIncomingEdges().size() <= 1) continue;
                        this.hasHyperedgesWest[layerIndex] = true;
                        continue;
                    }
                    assert (port.getOutgoingEdges().isEmpty() && port.getIncomingEdges().isEmpty());
                }
                if (node.getType() != LNode.NodeType.NORTH_SOUTH_PORT) continue;
                int n = layerIndex;
                inLayerEdgeCount[n] = inLayerEdgeCount[n] + 1;
                hasNorthSouthPorts[layerIndex] = true;
            }
        }
        boolean allLayerCombinationsHaveHyperedges = true;
        boolean noLayerCombinationHasHyperedges = true;
        int i = 0;
        while (i < this.hasHyperedgesWest.length - 1) {
            boolean b = this.hasHyperedgesEast[i] || this.hasHyperedgesWest[i + 1];
            allLayerCombinationsHaveHyperedges &= b;
            noLayerCombinationHasHyperedges &= !b;
            ++i;
        }
        this.portRanks = new float[portCount];
        int[] portPos = new int[portCount];
        if (!allLayerCombinationsHaveHyperedges) {
            this.normalCrossingsCounter = new BarthJuengerMutzelCrossingsCounter(inLayerEdgeCount, hasNorthSouthPorts, portPos);
            this.inlayerCrossingsCounter = this.normalCrossingsCounter;
        }
        if (!noLayerCombinationHasHyperedges) {
            this.hyperedgeCrossingsCounter = new HyperedgeCrossingsCounter(inLayerEdgeCount, hasNorthSouthPorts, portPos);
            this.inlayerCrossingsCounter = this.hyperedgeCrossingsCounter;
        }
    }

    private void dispose() {
        this.portRanks = null;
        this.bestSweep = null;
        this.curSweep = null;
        this.prevSweep = null;
        this.normalCrossingsCounter = null;
        this.hyperedgeCrossingsCounter = null;
        this.hasHyperedgesEast = null;
        this.hasHyperedgesWest = null;
        this.layoutUnits.clear();
    }

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Layer sweep crossing minimization", 1.0f);
        Random random = (Random)layeredGraph.getProperty(InternalProperties.RANDOM);
        int layerCount = layeredGraph.getLayers().size();
        if (layerCount < 2) {
            monitor.done();
            return;
        }
        this.initialize(layeredGraph);
        int bestSweepCrossings = Integer.MAX_VALUE;
        int runCount = (Integer)layeredGraph.getProperty(LayeredOptions.THOROUGHNESS);
        BarycenterHeuristic.BarycenterState[][] barycenterStates = new BarycenterHeuristic.BarycenterState[layeredGraph.getLayers().size()][];
        int i = 0;
        for (Layer layer : layeredGraph.getLayers()) {
            layer.id = i;
            barycenterStates[i] = new BarycenterHeuristic.BarycenterState[layer.getNodes().size()];
            int j = 0;
            for (LNode node : layer.getNodes()) {
                node.id = j;
                barycenterStates[i][j] = new BarycenterHeuristic.BarycenterState(node);
                ++j;
            }
            ++i;
        }
        ForsterConstraintResolver constraintResolver = new ForsterConstraintResolver(barycenterStates, this.layoutUnits);
        BarycenterHeuristic crossminHeuristic = new BarycenterHeuristic(barycenterStates, constraintResolver, random, this.portRanks);
        NodeRelativePortDistributor nodeRelativePortDistributor = new NodeRelativePortDistributor(this.portRanks);
        LayerTotalPortDistributor layerTotalPortDistributor = new LayerTotalPortDistributor(this.portRanks);
        int run = 0;
        while (run < runCount && bestSweepCrossings > 0) {
            boolean forward = random.nextBoolean();
            int fixedLayerIndex = forward ? 0 : layerCount - 1;
            LNode[] fixedLayer = this.curSweep[fixedLayerIndex];
            AbstractPortDistributor portDistributor = random.nextBoolean() ? nodeRelativePortDistributor : layerTotalPortDistributor;
            this.minimizeCrossings(fixedLayer, crossminHeuristic, forward, false, true);
            int curSweepCrossings = Integer.MAX_VALUE;
            int prevSweepCrossings = Integer.MAX_VALUE;
            boolean firstSweep = true;
            do {
                LNode[] freeLayer;
                int layerIndex;
                LayerSweepCrossingMinimizer.copySweep(this.curSweep, this.prevSweep);
                prevSweepCrossings = curSweepCrossings;
                curSweepCrossings = 0;
                curSweepCrossings += this.inlayerCrossingsCounter.countCrossings(fixedLayer, fixedLayerIndex);
                if (forward) {
                    layerIndex = 1;
                    while (layerIndex < layerCount) {
                        freeLayer = this.curSweep[layerIndex];
                        portDistributor.calculatePortRanks(fixedLayer, PortType.OUTPUT);
                        this.minimizeCrossings(freeLayer, crossminHeuristic, true, !firstSweep, false);
                        curSweepCrossings += this.inlayerCrossingsCounter.countCrossings(freeLayer, layerIndex);
                        curSweepCrossings = this.hasHyperedgesWest[layerIndex] || this.hasHyperedgesEast[layerIndex - 1] ? (curSweepCrossings += this.hyperedgeCrossingsCounter.countCrossings(fixedLayer, freeLayer)) : (curSweepCrossings += this.normalCrossingsCounter.countCrossings(fixedLayer, freeLayer));
                        fixedLayer = freeLayer;
                        ++layerIndex;
                    }
                    fixedLayerIndex = layerCount - 1;
                } else {
                    layerIndex = layerCount - 2;
                    while (layerIndex >= 0) {
                        freeLayer = this.curSweep[layerIndex];
                        portDistributor.calculatePortRanks(fixedLayer, PortType.INPUT);
                        this.minimizeCrossings(freeLayer, crossminHeuristic, false, !firstSweep, false);
                        curSweepCrossings += this.inlayerCrossingsCounter.countCrossings(freeLayer, layerIndex);
                        curSweepCrossings = this.hasHyperedgesEast[layerIndex] || this.hasHyperedgesWest[layerIndex + 1] ? (curSweepCrossings += this.hyperedgeCrossingsCounter.countCrossings(freeLayer, fixedLayer)) : (curSweepCrossings += this.normalCrossingsCounter.countCrossings(freeLayer, fixedLayer));
                        fixedLayer = freeLayer;
                        --layerIndex;
                    }
                    fixedLayerIndex = 0;
                }
                firstSweep = false;
                boolean bl = forward = !forward;
            } while (curSweepCrossings < prevSweepCrossings && curSweepCrossings > 0);
            if (curSweepCrossings < bestSweepCrossings || prevSweepCrossings < bestSweepCrossings) {
                if (curSweepCrossings <= prevSweepCrossings) {
                    LayerSweepCrossingMinimizer.copySweep(this.curSweep, this.bestSweep);
                    bestSweepCrossings = curSweepCrossings;
                } else {
                    LayerSweepCrossingMinimizer.copySweep(this.prevSweep, this.bestSweep);
                    bestSweepCrossings = prevSweepCrossings;
                }
            }
            ++run;
        }
        ListIterator<Layer> layerIter = layeredGraph.getLayers().listIterator();
        while (layerIter.hasNext()) {
            Layer layer = layerIter.next();
            LNode[] nodes = this.bestSweep[layerIter.previousIndex()];
            ListIterator<LNode> nodeIter = layer.getNodes().listIterator();
            while (nodeIter.hasNext()) {
                nodeIter.next();
                nodeIter.set(nodes[nodeIter.previousIndex()]);
            }
        }
        this.dispose();
        monitor.done();
    }

    private void minimizeCrossings(LNode[] layer, ICrossingMinimizationHeuristic heuristic, boolean forward, boolean preOrdered, boolean randomize) {
        ArrayList nodes = Lists.newArrayList((Object[])layer);
        heuristic.minimizeCrossings(nodes, preOrdered, randomize, forward);
        int index = 0;
        for (LNode nodeGroup : nodes) {
            layer[index++] = nodeGroup;
        }
    }

    private static void copySweep(LNode[][] source, LNode[][] dest) {
        int i = 0;
        while (i < dest.length) {
            int j = 0;
            while (j < dest[i].length) {
                dest[i][j] = source[i][j];
                ++j;
            }
            ++i;
        }
    }
}

