/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.greedyswitch;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.InLayerEdgeAllCrossingsCounter;
import org.eclipse.elk.alg.layered.intermediate.greedyswitch.PortIterable;
import org.eclipse.elk.core.options.PortSide;

public class InLayerEdgeTwoNodeCrossingCounter
extends InLayerEdgeAllCrossingsCounter {
    private final List<ComparableEdgeAndPort> relevantEdgesAndPorts = Lists.newArrayList();
    private int upperLowerCrossings;
    private int lowerUpperCrossings;
    private LNode upperNode;
    private LNode lowerNode;

    public InLayerEdgeTwoNodeCrossingCounter(LNode[] nodeOrder) {
        super(nodeOrder);
    }

    public void countCrossingsBetweenNodes(LNode upper, LNode lower) {
        this.upperNode = upper;
        this.lowerNode = lower;
        this.upperLowerCrossings = this.countCrossingsOnSide(PortSide.EAST);
        this.upperLowerCrossings += this.countCrossingsOnSide(PortSide.WEST);
        this.notifyOfSwitch(upper, lower);
        this.lowerUpperCrossings = this.countCrossingsOnSide(PortSide.EAST);
        this.lowerUpperCrossings += this.countCrossingsOnSide(PortSide.WEST);
        this.notifyOfSwitch(lower, upper);
    }

    private int countCrossingsOnSide(PortSide side) {
        this.relevantEdgesAndPorts.clear();
        this.addEdgesAndPortsConnectedToNodesAndSort(side);
        return this.iterateThroughRelevantEdgesAndPortsAndCountCrossings();
    }

    private void addEdgesAndPortsConnectedToNodesAndSort(PortSide side) {
        this.iterateThroughEdgesAndCollectThem(this.upperNode, side);
        this.iterateThroughEdgesAndCollectThem(this.lowerNode, side);
        Collections.sort(this.relevantEdgesAndPorts);
    }

    private void iterateThroughEdgesAndCollectThem(LNode node, PortSide side) {
        Iterable<LPort> ports = PortIterable.inNorthSouthEastWestOrder(node, side);
        for (LPort port : ports) {
            for (LEdge edge : port.getConnectedEdges()) {
                if (edge.isSelfLoop()) continue;
                this.addThisEndOrBothEndsOfEdge(node, port, edge);
            }
        }
    }

    private int iterateThroughRelevantEdgesAndPortsAndCountCrossings() {
        int crossings = 0;
        for (ComparableEdgeAndPort eP : this.relevantEdgesAndPorts) {
            crossings += super.countCrossingsOn(eP.edge, eP.port);
        }
        return crossings;
    }

    private void addThisEndOrBothEndsOfEdge(LNode node, LPort port, LEdge edge) {
        this.relevantEdgesAndPorts.add(new ComparableEdgeAndPort(port, edge, this.positionOf(port)));
        if (this.isInLayer(edge) && this.notConnectedToOtherNode(edge, node)) {
            LPort otherEnd = this.otherEndOf(edge, port);
            this.relevantEdgesAndPorts.add(new ComparableEdgeAndPort(otherEnd, edge, this.positionOf(otherEnd)));
        }
    }

    private boolean notConnectedToOtherNode(LEdge edge, LNode node) {
        if (((Object)((Object)node)).equals((Object)this.upperNode)) {
            return !((Object)((Object)edge.getTarget().getNode())).equals((Object)this.lowerNode) && !((Object)((Object)edge.getSource().getNode())).equals((Object)this.lowerNode);
        }
        return !((Object)((Object)edge.getTarget().getNode())).equals((Object)this.upperNode) && !((Object)((Object)edge.getSource().getNode())).equals((Object)this.upperNode);
    }

    public int getUpperLowerCrossings() {
        return this.upperLowerCrossings;
    }

    public int getLowerUpperCrossings() {
        return this.lowerUpperCrossings;
    }

    private LPort otherEndOf(LEdge edge, LPort fromPort) {
        return fromPort == edge.getSource() ? edge.getTarget() : edge.getSource();
    }

    private class ComparableEdgeAndPort
    implements Comparable<ComparableEdgeAndPort> {
        private final LPort port;
        private final LEdge edge;
        private final int portPosition;

        public ComparableEdgeAndPort(LPort port, LEdge edge, int portPosition) {
            this.port = port;
            this.edge = edge;
            this.portPosition = portPosition;
        }

        @Override
        public int compareTo(ComparableEdgeAndPort o) {
            return this.portPosition < o.portPosition || this.portPosition == o.portPosition && InLayerEdgeTwoNodeCrossingCounter.this.isInLayer(this.edge) && InLayerEdgeTwoNodeCrossingCounter.this.isInLayer(o.edge) && InLayerEdgeTwoNodeCrossingCounter.this.positionOf(InLayerEdgeTwoNodeCrossingCounter.this.otherEndOf(this.edge, this.port)) > InLayerEdgeTwoNodeCrossingCounter.this.positionOf(InLayerEdgeTwoNodeCrossingCounter.this.otherEndOf(o.edge, o.port)) ? -1 : (this.portPosition == o.portPosition && InLayerEdgeTwoNodeCrossingCounter.this.otherEndOf(this.edge, this.port) == InLayerEdgeTwoNodeCrossingCounter.this.otherEndOf(this.edge, this.port) ? 0 : 1);
        }

        public String toString() {
            return "ComparableEdgeAndPort [port=" + (Object)((Object)this.port) + ", edge=" + (Object)((Object)this.edge) + ", portPosition=" + this.portPosition + "]";
        }
    }
}

