/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.compound;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ListIterator;
import org.eclipse.elk.alg.layered.ILayoutProcessor;
import org.eclipse.elk.alg.layered.compound.CrossHierarchyEdge;
import org.eclipse.elk.alg.layered.compound.CrossHierarchyEdgeComparator;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphUtil;
import org.eclipse.elk.alg.layered.graph.LLabel;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class CompoundGraphPostprocessor
implements ILayoutProcessor {
    private static final Predicate<CrossHierarchyEdge> HAS_JUNCTION_POINTS_PREDICATE = new Predicate<CrossHierarchyEdge>(){

        public boolean apply(CrossHierarchyEdge chEdge) {
            KVectorChain jps = (KVectorChain)chEdge.getEdge().getProperty(LayeredOptions.JUNCTION_POINTS);
            return jps != null && !jps.isEmpty();
        }
    };

    @Override
    public void process(LGraph graph, IElkProgressMonitor monitor) {
        monitor.begin("Compound graph postprocessor", 1.0f);
        boolean addUnnecessaryBendpoints = (Boolean)graph.getProperty(LayeredOptions.UNNECESSARY_BENDPOINTS);
        Multimap crossHierarchyMap = (Multimap)graph.getProperty(InternalProperties.CROSS_HIERARCHY_MAP);
        HashSet dummyEdges = Sets.newHashSet();
        for (LEdge origEdge : crossHierarchyMap.keySet()) {
            ArrayList crossHierarchyEdges = new ArrayList(crossHierarchyMap.get((Object)origEdge));
            Collections.sort(crossHierarchyEdges, new CrossHierarchyEdgeComparator(graph));
            LPort sourcePort = ((CrossHierarchyEdge)crossHierarchyEdges.get(0)).getActualSource();
            LPort targetPort = ((CrossHierarchyEdge)crossHierarchyEdges.get(crossHierarchyEdges.size() - 1)).getActualTarget();
            origEdge.getBendPoints().clear();
            LNode referenceNode = sourcePort.getNode();
            LGraph referenceGraph = LGraphUtil.isDescendant(targetPort.getNode(), referenceNode) ? (LGraph)referenceNode.getProperty(InternalProperties.NESTED_LGRAPH) : referenceNode.getGraph();
            KVectorChain junctionPoints = (KVectorChain)origEdge.getProperty(LayeredOptions.JUNCTION_POINTS);
            if (Iterables.any(crossHierarchyEdges, HAS_JUNCTION_POINTS_PREDICATE)) {
                if (junctionPoints == null) {
                    junctionPoints = new KVectorChain();
                    origEdge.setProperty(LayeredOptions.JUNCTION_POINTS, junctionPoints);
                } else {
                    junctionPoints.clear();
                }
            } else if (junctionPoints != null) {
                origEdge.setProperty(LayeredOptions.JUNCTION_POINTS, null);
            }
            KVector lastPoint = null;
            for (CrossHierarchyEdge chEdge : crossHierarchyEdges) {
                KVector offset = new KVector();
                LGraphUtil.changeCoordSystem(offset, chEdge.getGraph(), referenceGraph);
                LEdge ledge = chEdge.getEdge();
                KVectorChain bendPoints = new KVectorChain();
                bendPoints.addAllAsCopies(0, (Iterable)ledge.getBendPoints());
                bendPoints.offset(offset);
                KVector sourcePoint = new KVector(ledge.getSource().getAbsoluteAnchor());
                KVector targetPoint = new KVector(ledge.getTarget().getAbsoluteAnchor());
                sourcePoint.add(offset);
                targetPoint.add(offset);
                if (lastPoint != null) {
                    boolean yDiffEnough;
                    KVector nextPoint = bendPoints.isEmpty() ? targetPoint : (KVector)bendPoints.getFirst();
                    boolean xDiffEnough = Math.abs(lastPoint.x - nextPoint.x) > 0.001;
                    boolean bl = yDiffEnough = Math.abs(lastPoint.y - nextPoint.y) > 0.001;
                    if (!addUnnecessaryBendpoints && xDiffEnough && yDiffEnough || addUnnecessaryBendpoints && (xDiffEnough || yDiffEnough)) {
                        origEdge.getBendPoints().add((Object)sourcePoint);
                    }
                }
                origEdge.getBendPoints().addAll((Collection)bendPoints);
                lastPoint = bendPoints.isEmpty() ? sourcePoint : (KVector)bendPoints.getLast();
                KVectorChain ledgeJPs = (KVectorChain)ledge.getProperty(LayeredOptions.JUNCTION_POINTS);
                if (ledgeJPs != null) {
                    KVectorChain jpCopies = new KVectorChain();
                    jpCopies.addAllAsCopies(0, (Iterable)ledgeJPs);
                    jpCopies.offset(offset);
                    junctionPoints.addAll((Collection)jpCopies);
                }
                if (chEdge.getActualTarget() == targetPort) {
                    if (targetPort.getNode().getGraph() != chEdge.getGraph()) {
                        offset = new KVector();
                        LGraphUtil.changeCoordSystem(offset, targetPort.getNode().getGraph(), referenceGraph);
                    }
                    origEdge.setProperty(InternalProperties.TARGET_OFFSET, offset);
                }
                ListIterator<LLabel> labelIterator = ledge.getLabels().listIterator();
                while (labelIterator.hasNext()) {
                    LLabel currLabel = (LLabel)((Object)labelIterator.next());
                    if (currLabel.getProperty(InternalProperties.ORIGINAL_LABEL_EDGE) != origEdge) continue;
                    LGraphUtil.changeCoordSystem(currLabel.getPosition(), ledge.getSource().getNode().getGraph(), referenceGraph);
                    labelIterator.remove();
                    origEdge.getLabels().add(currLabel);
                }
                dummyEdges.add(ledge);
            }
            origEdge.setSource(sourcePort);
            origEdge.setTarget(targetPort);
        }
        for (LEdge dummyEdge : dummyEdges) {
            dummyEdge.setSource(null);
            dummyEdge.setTarget(null);
        }
        monitor.done();
    }
}

