/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BooleanSupplier;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.IUpdate;

public final class ActionUtils {
    private ActionUtils() {
    }

    public static IAction createGlobalAction(ActionFactory factory, final Runnable action) {
        ActionFactory.IWorkbenchAction template = factory.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        Action result = new Action(template.getText()){

            public void run() {
                action.run();
            }
        };
        result.setActionDefinitionId(template.getActionDefinitionId());
        result.setId(template.getId());
        result.setImageDescriptor(template.getImageDescriptor());
        result.setDisabledImageDescriptor(template.getDisabledImageDescriptor());
        template.dispose();
        return result;
    }

    public static UpdateableAction createGlobalAction(ActionFactory factory, final Runnable action, final BooleanSupplier enabled) {
        ActionFactory.IWorkbenchAction template = factory.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        UpdateableAction result = new UpdateableAction(template.getText()){

            public void run() {
                action.run();
            }

            public void update() {
                this.setEnabled(enabled.getAsBoolean());
            }
        };
        result.setActionDefinitionId(template.getActionDefinitionId());
        result.setId(template.getId());
        result.setImageDescriptor(template.getImageDescriptor());
        result.setDisabledImageDescriptor(template.getDisabledImageDescriptor());
        result.update();
        template.dispose();
        return result;
    }

    public static UpdateableAction createTextAction(ITextOperationTarget target, ActionFactory factory, int operationCode) {
        if (operationCode == 2) {
            return ActionUtils.createGlobalAction(factory, () -> target.doOperation(operationCode), () -> true);
        }
        return ActionUtils.createGlobalAction(factory, () -> target.doOperation(operationCode), () -> target.canDoOperation(operationCode));
    }

    private static UpdateableAction[] createStandardTextActions(ITextOperationTarget target, boolean editable) {
        UpdateableAction[] actions = new UpdateableAction[8];
        if (editable) {
            actions[1] = ActionUtils.createTextAction(target, ActionFactory.UNDO, 1);
            actions[2] = ActionUtils.createTextAction(target, ActionFactory.REDO, 2);
            actions[3] = ActionUtils.createTextAction(target, ActionFactory.CUT, 3);
            actions[5] = ActionUtils.createTextAction(target, ActionFactory.PASTE, 5);
            actions[6] = ActionUtils.createTextAction(target, ActionFactory.DELETE, 6);
        }
        actions[4] = ActionUtils.createTextAction(target, ActionFactory.COPY, 4);
        actions[7] = ActionUtils.createTextAction(target, ActionFactory.SELECT_ALL, 7);
        return actions;
    }

    public static UpdateableAction[] fillStandardTextActions(ITextOperationTarget target, boolean editable, MenuManager manager) {
        UpdateableAction[] actions = ActionUtils.createStandardTextActions(target, editable);
        if (manager != null) {
            if (editable) {
                manager.add((IAction)actions[1]);
                manager.add((IAction)actions[2]);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)actions[3]);
            }
            manager.add((IAction)actions[4]);
            if (editable) {
                manager.add((IAction)actions[5]);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)actions[6]);
            }
            manager.add((IAction)actions[7]);
        }
        return actions;
    }

    public static void setGlobalActions(Control control, Collection<? extends IAction> actions, IHandlerService service) {
        ActiveShellExpression expression = new ActiveShellExpression(control.getShell());
        class ActivationListener
        implements Listener {
            private Collection<IHandlerActivation> handlerActivations = new ArrayList<IHandlerActivation>();
            private final /* synthetic */ IHandlerService val$service;
            private final /* synthetic */ Collection val$actions;
            private final /* synthetic */ ActiveShellExpression val$expression;

            ActivationListener(IHandlerService iHandlerService, Collection collection, ActiveShellExpression activeShellExpression) {
                this.val$service = iHandlerService;
                this.val$actions = collection;
                this.val$expression = activeShellExpression;
            }

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: 
                    case 16: 
                    case 27: {
                        if (this.handlerActivations.isEmpty()) break;
                        this.val$service.deactivateHandlers(this.handlerActivations);
                        this.handlerActivations.clear();
                        break;
                    }
                    case 15: {
                        if (!this.handlerActivations.isEmpty()) {
                            return;
                        }
                        for (IAction action : this.val$actions) {
                            if (action == null) continue;
                            this.handlerActivations.add(this.val$service.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action), (Expression)this.val$expression, false));
                            if (!(action instanceof IUpdate)) continue;
                            ((IUpdate)action).update();
                        }
                        break;
                    }
                }
            }
        }
        ActivationListener activationListener = new ActivationListener(service, actions, expression);
        control.addListener(27, (Listener)activationListener);
        control.addListener(16, (Listener)activationListener);
        control.addListener(15, (Listener)activationListener);
        control.addListener(12, (Listener)activationListener);
    }

    public static void setGlobalActions(Control control, IHandlerService service, IAction ... actions) {
        ActionUtils.setGlobalActions(control, Arrays.asList(actions), service);
    }

    public static void setGlobalActions(Control control, Collection<? extends IAction> actions) {
        ActionUtils.setGlobalActions(control, actions, (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class));
    }

    public static void setGlobalActions(Control control, IAction ... actions) {
        ActionUtils.setGlobalActions(control, Arrays.asList(actions));
    }

    public static abstract class UpdateableAction
    extends Action
    implements IUpdate {
        public UpdateableAction(String text) {
            super(text);
        }
    }
}

