/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.templateEditor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.model.fcore.FcorePackage;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.PatternEditorInput;
import org.eclipse.egf.pattern.ui.editors.PatternMethodEditorInput;
import org.eclipse.egf.pattern.ui.editors.templateEditor.ConvertPluginProjectOperation;
import org.eclipse.egf.pattern.ui.editors.templateEditor.TemplateEditorUtility;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.Position;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplateEditor
extends MultiPageEditorPart {
    public static final String ID = "org.eclipse.egf.pattern.ui.abstract.template.editor.id";
    private String projectName = "___templateproject";
    protected IEditorPart openEditor;
    protected Map<String, Position> startPositions = new HashMap<String, Position>();
    protected WorkbenchPage templateActivePage;
    protected Map<String, TextEditor> editorMap = new HashMap<String, TextEditor>();
    protected List<TextEditor> editorList = new ArrayList<TextEditor>();
    private static final String JET_TRANSFORM_POINT_ID = "org.eclipse.jet.transform";
    private static final String PLUGIN_EDITOR_ID = "org.eclipse.pde.ui.manifestEditor";
    AdapterImpl patternAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            EReference ref;
            if (FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME.equals(msg.getFeature())) {
                AbstractTemplateEditor.this.setPartName((String)msg.getNewValue());
            } else if (msg.getFeature() instanceof EReference && "methods".equals((ref = (EReference)msg.getFeature()).getName())) {
                AbstractTemplateEditor.this.refreshTemplateEditor(msg);
            }
        }
    };
    AdapterImpl methodAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (FcorePackage.Literals.NAMED_MODEL_ELEMENT__NAME.equals(msg.getFeature())) {
                AbstractTemplateEditor.this.executeMethodEditorRename();
            }
        }
    };

    protected abstract void initProblems();

    protected abstract void divideByMethods();

    public abstract void setActivePage(String var1);

    public void doSave(IProgressMonitor monitor) {
        int i = 0;
        while (i < this.getPageCount()) {
            this.getEditor(i).doSave(monitor);
            ++i;
        }
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof PatternEditorInput)) {
            throw new PartInitException(Messages.Editor_wrong_input);
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Pattern getPattern() {
        PatternEditorInput input = (PatternEditorInput)this.getEditorInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        return input.getPattern();
    }

    public IEditorPart initEditor(IFile templateFile) throws CoreException {
        block3: {
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
                this.templateActivePage = new WorkbenchPage((WorkbenchWindow)activeWorkbenchWindow, null);
                if (this.templateActivePage != null && templateFile != null) break block3;
                return null;
            }
            catch (PartInitException e) {
                Activator.getDefault().logError(e);
                return null;
            }
        }
        return this.templateActivePage.openEditor((IEditorInput)new FileEditorInput(templateFile), this.getDelegateEditorID(), false);
    }

    protected abstract String getDelegateEditorID();

    protected IFile setPublicTemplateEditor(Pattern pattern, EList<PatternMethod> methods, String fileExtention) {
        IFile templateFile = null;
        try {
            IFolder src;
            Resource eResource = pattern.eResource();
            IPlatformFcore platformFcore = EGFCorePlugin.getPlatformFcore((Resource)eResource);
            IPlatformBundle platformBundle = platformFcore.getPlatformBundle();
            IProject project = platformBundle.getProject();
            NullProgressMonitor monitor = new NullProgressMonitor();
            String tempProjectName = "." + project.getName() + this.projectName;
            IProject templateProject = ResourcesPlugin.getWorkspace().getRoot().getProject(tempProjectName);
            if (!templateProject.exists()) {
                this.getTemplateProject(templateProject, tempProjectName, monitor);
                templateProject.delete(true, true, (IProgressMonitor)monitor);
                this.getTemplateProject(templateProject, tempProjectName, monitor);
                ConvertPluginProjectOperation convert = new ConvertPluginProjectOperation(templateProject, platformBundle);
                convert.execute((IProgressMonitor)monitor);
            }
            if (!(src = templateProject.getFolder("src")).exists()) {
                src.create(true, false, null);
            }
            this.filterUselessExtension(templateProject, monitor);
            templateFile = src.getFile(fileExtention);
            if (!templateFile.exists()) {
                templateFile.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
            } else {
                templateFile.setContents((InputStream)new ByteArrayInputStream(new byte[0]), true, false, null);
            }
            PatternMethod footMethod = null;
            for (PatternMethod method : methods) {
                if (method.equals(pattern.getFooterMethod())) {
                    footMethod = method;
                    continue;
                }
                this.visitMethod(project, method, templateFile, true);
            }
            this.visitMethod(project, footMethod, templateFile, false);
            this.openEditor = this.initEditor(templateFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return templateFile;
    }

    private void visitMethod(IProject project, PatternMethod method, IFile templateFile, boolean seprator) throws CoreException, IOException {
        IFile file = project.getFile(method.getPatternFilePath().path());
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        }
        templateFile.appendContents(file.getContents(), false, false, null);
        if (seprator) {
            templateFile.appendContents((InputStream)new StringBufferInputStream("\n"), true, false, null);
        }
        int startPosition = TemplateEditorUtility.getStartPosition(this.startPositions);
        int length = TemplateEditorUtility.getSourceLength(file.getContents());
        Position position = new Position(startPosition, length);
        this.startPositions.put(method.getName(), position);
    }

    protected void addPatternChangeAdapter(Pattern pattern) {
        if (pattern != null && !pattern.eAdapters().contains((Object)this.patternAdapter)) {
            pattern.eAdapters().add((Object)this.patternAdapter);
            EList methods = pattern.getMethods();
            for (PatternMethod method : methods) {
                this.addMethodChangeAdapter(method);
            }
        }
    }

    protected void addMethodChangeAdapter(PatternMethod method) {
        if (method != null && !method.eAdapters().contains((Object)this.methodAdapter)) {
            method.eAdapters().add((Object)this.methodAdapter);
        }
    }

    protected void removePatternChangeAdapter() {
        Pattern pattern = this.getPattern();
        if (pattern != null && pattern.eAdapters().contains((Object)this.patternAdapter)) {
            pattern.eAdapters().remove((Object)this.patternAdapter);
        }
        if (pattern != null) {
            EList methods = pattern.getMethods();
            for (PatternMethod method : methods) {
                this.removeMethodChangeAdapter(method);
            }
        }
    }

    protected void removeMethodChangeAdapter(PatternMethod method) {
        if (method != null && method.eAdapters().contains((Object)this.methodAdapter)) {
            method.eAdapters().remove((Object)this.methodAdapter);
        }
    }

    public WorkbenchPage getTemplateActivePage() {
        return this.templateActivePage;
    }

    private void refreshTemplateEditor(Notification msg) {
        Object newValue = msg.getNewValue();
        Object oldValue = msg.getOldValue();
        int eventType = msg.getEventType();
        if (newValue != null && newValue instanceof PatternMethod || newValue == null && oldValue instanceof PatternMethod) {
            switch (eventType) {
                case 3: {
                    this.executeMethodEditorAdd((PatternMethod)newValue);
                    break;
                }
                case 4: {
                    this.executeMethodEditorRemove((PatternMethod)oldValue);
                    break;
                }
                case 7: {
                    this.executeMethodEditorsReorder((PatternMethod)newValue, oldValue);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    private void executeMethodEditorRename() {
        for (TextEditor editor : this.editorList) {
            int index;
            PatternMethod patternMethod = ((PatternMethodEditorInput)editor.getEditorInput()).getPatternMethod();
            if (patternMethod == null || (index = this.getIndexOfMethodEditor(editor)) == -1) continue;
            this.setPageText(index, patternMethod.getName());
        }
    }

    private void executeMethodEditorRemove(PatternMethod deleteMethod) {
        int i = 0;
        while (i < this.getPageCount()) {
            PatternMethod patternMethod;
            IEditorPart currentEditor = this.getEditor(i);
            IEditorInput editorInput = currentEditor.getEditorInput();
            if (editorInput instanceof PatternMethodEditorInput && (patternMethod = ((PatternMethodEditorInput)editorInput).getPatternMethod()) == null) {
                this.removePage(i);
                this.removeEditor(currentEditor);
            }
            ++i;
        }
    }

    private void removeEditor(IEditorPart editor) {
        this.editorList.remove(editor);
        Set<Map.Entry<String, TextEditor>> entrySet = this.editorMap.entrySet();
        for (Map.Entry<String, TextEditor> entry : entrySet) {
            if (!entry.getValue().equals(editor)) continue;
            this.editorMap.remove(entry.getKey());
            return;
        }
    }

    protected void executeMethodEditorAdd(PatternMethod addMethod) {
        this.addMethodChangeAdapter(addMethod);
    }

    protected void addEditor(TextEditor editor, PatternMethod method) {
        try {
            PatternMethodEditorInput input = new PatternMethodEditorInput(method.eResource(), method.getID());
            int index = this.addPage((IEditorPart)editor, (IEditorInput)input);
            this.setPageText(index, method.getName());
            this.editorMap.put(method.getID(), editor);
            this.editorList.add(editor);
        }
        catch (PartInitException e) {
            Activator.getDefault().logError(e);
        }
    }

    protected void setPatternFilePath(PatternMethod addMethod) {
        URI computeFileURI = PatternHelper.Filename.computeFileURI((PatternMethod)addMethod);
        addMethod.setPatternFilePath(computeFileURI);
    }

    protected void executeMethodEditorsReorder(PatternMethod moveMethod, Object oldValue) {
        int newIndex = this.getPattern().getMethods().indexOf((Object)moveMethod);
        if (oldValue instanceof Integer) {
            int oldIndex = (Integer)oldValue;
            String id = moveMethod.getID();
            TextEditor textEditor = this.editorMap.get(id);
            if (textEditor.isDirty()) {
                textEditor.doSave(null);
            }
            this.removePage(oldIndex);
            this.editorMap.remove(id);
            this.editorList.remove(textEditor);
            try {
                TextEditor newEditor = this.createNewEditor();
                PatternMethodEditorInput input = new PatternMethodEditorInput(moveMethod.eResource(), id);
                this.addPage(newIndex, (IEditorPart)newEditor, (IEditorInput)input);
                this.editorMap.put(id, newEditor);
                this.editorList.add(newIndex, newEditor);
            }
            catch (PartInitException e) {
                Activator.getDefault().logError(e);
            }
            this.setPageText(newIndex, moveMethod.getName());
        }
    }

    protected int getIndexOfMethodEditor(TextEditor editor) {
        int index = -1;
        int i = 0;
        while (i < this.getPageCount()) {
            IEditorPart currentEditor = this.getEditor(i);
            if (editor.equals(currentEditor)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public void filterUselessExtension(IProject project, NullProgressMonitor monitor) {
        IFile plugInFile = project.getFile("plugin.xml");
        if (plugInFile.exists()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            try {
                ManifestEditor editor;
                IBaseModel base;
                WorkbenchPage templateActivePage = new WorkbenchPage((WorkbenchWindow)activeWorkbenchWindow, null);
                IEditorPart part = IDE.openEditor((IWorkbenchPage)templateActivePage, (IFile)plugInFile, (String)PLUGIN_EDITOR_ID);
                if (part instanceof ManifestEditor && (base = (editor = (ManifestEditor)part).getAggregateModel()) instanceof IBundlePluginModelBase) {
                    IPluginExtension[] extensions;
                    IBundlePluginModelBase bundlePluginModel = (IBundlePluginModelBase)base;
                    IPluginBase pluginBase = bundlePluginModel.getPluginBase();
                    IPluginModelBase pluginModel = pluginBase.getPluginModel();
                    IPluginExtension[] iPluginExtensionArray = extensions = pluginModel.getPluginBase().getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPluginExtension currentExtension = iPluginExtensionArray[n2];
                        String point = currentExtension.getPoint();
                        if (!JET_TRANSFORM_POINT_ID.equals(point)) {
                            try {
                                pluginModel.getPluginBase().remove(currentExtension);
                            }
                            catch (CoreException e) {
                                Activator.getDefault().logError(e);
                            }
                        }
                        ++n2;
                    }
                    part.doSave((IProgressMonitor)monitor);
                }
                part.dispose();
            }
            catch (WorkbenchException e) {
                Activator.getDefault().logError(e);
            }
        }
    }

    public Map<String, TextEditor> getEditorMap() {
        return this.editorMap;
    }

    public List<TextEditor> getEditorList() {
        return this.editorList;
    }

    protected abstract TextEditor createNewEditor();

    private void getTemplateProject(IProject templateProject, String tempProjectName, NullProgressMonitor monitor) {
        IJavaProject javaProject = TemplateEditorUtility.createJavaProject(tempProjectName, (IProgressMonitor)monitor);
        templateProject = javaProject.getProject();
    }

    public void dispose() {
        this.removePatternChangeAdapter();
        super.dispose();
    }
}

