/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.common.java;

import java.util.Map;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.pattern.BackCall;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternInjectedCall;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.SuperCall;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.AssemblyContentProvider;
import org.eclipse.egf.pattern.engine.ParameterMatcher;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.utils.JavaMethodGenerationHelper;
import org.eclipse.emf.common.util.EList;

public abstract class AbstractJavaAssemblyContentProvider
extends AssemblyContentProvider {
    protected final JavaMethodGenerationHelper javaMethodHelper;

    public AbstractJavaAssemblyContentProvider(Pattern pattern, JavaMethodGenerationHelper helper) {
        super(pattern);
        this.javaMethodHelper = helper;
    }

    protected void call(BackCall object) throws PatternException {
        this.content.append("{").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("final Map<String, Object> parameters = new HashMap<String, Object>();").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("index = ictx.getBuffer().length();").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("ictx.getExecutionBuffer().append(ictx.getBuffer());").append(EGFCommonConstants.LINE_SEPARATOR);
        EList allParameters = this.pattern.getAllParameters();
        for (PatternParameter parameter : allParameters) {
            String name = parameter.getName();
            this.content.append("parameters.put(\"").append(name).append("\", this.").append(name).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
        }
        this.content.append("CallbackContext ctx_callback = new CallbackContext(ictx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("CallHelper.callBack(ctx_callback, parameters);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(SuperCall call) throws PatternException {
        if (call.getPattern().getSuperPattern() == null) {
            return;
        }
        this.content.append("super.").append("orchestration").append("(new SuperOrchestrationContext(ictx));").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(PatternInjectedCall call) throws PatternException {
        Pattern pattern = call.getCalled();
        String ctxName = "ctx_" + PatternHelper.generateID();
        this.content.append("ExecutionContext ").append(ctxName).append(" = new ExecutionContext(ictx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append(ctxName).append(".setValue(").append("PatternContext.INJECTED_CONTEXT, ").append(call.getContext().getName()).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("CallHelper.execute(\"").append(pattern.getID()).append("\", ").append(ctxName).append(");").append(EGFCommonConstants.LINE_SEPARATOR).append(EGFCommonConstants.LINE_SEPARATOR);
    }

    protected void call(PatternCall call) throws PatternException {
        Pattern pattern = call.getCalled();
        this.content.append("{").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("final Map<String, Object> parameters = new HashMap<String, Object>();").append(EGFCommonConstants.LINE_SEPARATOR);
        if (call.getParameterMatching().isEmpty()) {
            ParameterMatcher matcher = ParameterMatcher.create(call.getPattern(), pattern);
            if (!matcher.matches()) {
                throw new PatternException(Messages.bind((String)Messages.assembly_error10, (Object)call.getPattern().getName()));
            }
            for (PatternParameter key : matcher.getMatching().keySet()) {
                this.content.append("parameters.put(\"").append(key.getName()).append("\", this.").append(matcher.getMatching().get(key).getName()).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        } else {
            for (Map.Entry binding : call.getParameterMatching()) {
                this.content.append("parameters.put(\"").append(((PatternParameter)binding.getKey()).getName()).append("\", this.").append(((PatternParameter)binding.getValue()).getName()).append(");").append(EGFCommonConstants.LINE_SEPARATOR);
            }
        }
        String ctxName = "ctx_" + PatternHelper.generateID();
        this.content.append("ExecutionContext ").append(ctxName).append(" = new ExecutionContext(ictx);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("CallHelper.executeWithInjection(\"").append(pattern.getID()).append("\", ").append(ctxName).append(", parameters);").append(EGFCommonConstants.LINE_SEPARATOR);
        this.content.append("}").append(EGFCommonConstants.LINE_SEPARATOR);
    }

    public void setContent(StringBuilder content) {
        super.setContent(content);
        this.javaMethodHelper.setContent(content);
    }
}

